/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.balm.api.proxy;

import java.lang.reflect.InvocationTargetException;
import net.blay09.mods.balm.api.proxy.ProxyResolutionException;

public class SidedProxy<T> {
    private final String commonName;
    private final String clientName;
    private T proxy;

    public SidedProxy(String commonName, String clientName) {
        this.commonName = commonName;
        this.clientName = clientName;
    }

    public void resolveCommon() throws ProxyResolutionException {
        try {
            this.proxy = Class.forName(this.commonName).getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new ProxyResolutionException(e);
        }
    }

    public void resolveClient() throws ProxyResolutionException {
        try {
            this.proxy = Class.forName(this.clientName).getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new ProxyResolutionException(e);
        }
    }

    public T get() {
        if (this.proxy == null) {
            throw new IllegalStateException("Tried to access proxy before it was resolved");
        }
        return this.proxy;
    }
}

