/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.azurelib.helper;

import mod.azure.azurelib.platform.Services;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.VibrationParticleOption;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.gameevent.vibrations.VibrationInfo;
import net.minecraft.world.level.gameevent.vibrations.VibrationSystem;
import net.minecraft.world.phys.Vec3;

public interface AzureTicker {
    public static void tick(Level level, VibrationSystem.Data data, VibrationSystem.User user) {
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        if (data.m_280602_() == null) {
            AzureTicker.trySelectAndScheduleVibration(serverLevel, data, user);
        }
        if (data.m_280602_() == null) {
            return;
        }
        boolean bl = data.m_280274_() > 0;
        data.m_280502_();
        if (data.m_280274_() <= 0) {
            bl = AzureTicker.receiveVibration(serverLevel, data, user, data.m_280602_());
        }
        if (bl) {
            user.m_280022_();
        }
    }

    private static void trySelectAndScheduleVibration(ServerLevel serverLevel, VibrationSystem.Data data, VibrationSystem.User user) {
        data.m_280457_().m_245156_(serverLevel.m_46467_()).ifPresent(vibrationInfo -> {
            data.m_280036_(vibrationInfo);
            Vec3 vec3 = vibrationInfo.f_243906_();
            data.m_280178_(user.m_280576_(vibrationInfo.f_243776_()));
            if (Services.PLATFORM.isDevelopmentEnvironment()) {
                serverLevel.m_8767_((ParticleOptions)new VibrationParticleOption(user.m_280010_(), data.m_280274_()), vec3.f_82479_, vec3.f_82480_, vec3.f_82481_, 1, 0.0, 0.0, 0.0, 0.0);
            }
            user.m_280022_();
            data.m_280457_().m_246080_();
        });
    }

    private static boolean receiveVibration(ServerLevel serverLevel, VibrationSystem.Data data, VibrationSystem.User user, VibrationInfo vibrationInfo) {
        BlockPos blockPos = BlockPos.m_274446_((Position)vibrationInfo.f_243906_());
        BlockPos blockPos2 = user.m_280010_().m_142502_((Level)serverLevel).map(BlockPos::m_274446_).orElse(blockPos);
        if (user.m_280215_() && !AzureTicker.areAdjacentChunksTicking((Level)serverLevel, blockPos2)) {
            return false;
        }
        user.m_280271_(serverLevel, blockPos, vibrationInfo.f_243709_(), (Entity)vibrationInfo.m_246794_(serverLevel).orElse(null), (Entity)vibrationInfo.m_247126_(serverLevel).orElse(null), VibrationSystem.Listener.m_280659_((BlockPos)blockPos, (BlockPos)blockPos2));
        data.m_280036_(null);
        return true;
    }

    private static boolean areAdjacentChunksTicking(Level level, BlockPos blockPos) {
        ChunkPos chunkPos = new ChunkPos(blockPos);
        for (int i = chunkPos.f_45578_ - 1; i < chunkPos.f_45578_ + 1; ++i) {
            for (int j = chunkPos.f_45579_ - 1; j < chunkPos.f_45579_ + 1; ++j) {
                LevelChunk chunkAccess = level.m_7726_().m_7131_(i, j);
                if (chunkAccess != null && level.m_183438_(chunkAccess.m_7697_().m_45588_())) continue;
                return false;
            }
        }
        return true;
    }
}

