/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.atmospheric.core.registry.builtin;

import com.google.common.collect.Maps;
import com.teamabnormals.atmospheric.core.AtmosphericConfig;
import com.teamabnormals.atmospheric.core.registry.AtmosphericBlocks;
import com.teamabnormals.blueprint.common.world.modification.structure.SimpleStructureRepaletter;
import com.teamabnormals.blueprint.common.world.modification.structure.StructureRepaletter;
import com.teamabnormals.blueprint.common.world.modification.structure.StructureRepaletterEntry;
import com.teamabnormals.blueprint.core.api.conditions.ConfigValueCondition;
import com.teamabnormals.blueprint.core.registry.BlueprintDataPackRegistries;
import com.teamabnormals.blueprint.core.registry.BlueprintHolderSets;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.levelgen.structure.BuiltinStructures;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.common.crafting.conditions.ICondition;

public final class AtmosphericStructureRepaletters {
    public static void bootstrap(BootstapContext<StructureRepaletterEntry> context) {
        HolderGetter structures = context.m_255420_(Registries.f_256944_);
        AtmosphericStructureRepaletters.yuccaDesertVillage(context, (HolderGetter<Structure>)structures, "yucca_buttons", Blocks.f_50254_, (Block)AtmosphericBlocks.YUCCA_BUTTON.get());
        AtmosphericStructureRepaletters.yuccaDesertVillage(context, (HolderGetter<Structure>)structures, "yucca_doors", Blocks.f_50486_, (Block)AtmosphericBlocks.YUCCA_DOOR.get());
        AtmosphericStructureRepaletters.yuccaDesertVillage(context, (HolderGetter<Structure>)structures, "yucca_fences", Blocks.f_50481_, (Block)AtmosphericBlocks.YUCCA_FENCE.get());
        AtmosphericStructureRepaletters.yuccaDesertVillage(context, (HolderGetter<Structure>)structures, "yucca_fence_gates", Blocks.f_50476_, (Block)AtmosphericBlocks.YUCCA_FENCE_GATE.get());
        AtmosphericStructureRepaletters.yuccaDesertVillage(context, (HolderGetter<Structure>)structures, "yucca_trapdoors", Blocks.f_50219_, (Block)AtmosphericBlocks.YUCCA_TRAPDOOR.get());
        AtmosphericStructureRepaletters.yuccaDesertVillage(context, (HolderGetter<Structure>)structures, "yucca_ladders", Blocks.f_50155_, (Block)AtmosphericBlocks.YUCCA_LADDER.get());
        AtmosphericStructureRepaletters.yuccaDesertVillage(context, (HolderGetter<Structure>)structures, "yucca_chests", Blocks.f_50087_, (Block)AtmosphericBlocks.YUCCA_CHEST.get());
        AtmosphericStructureRepaletters.yuccaDesertVillage(context, (HolderGetter<Structure>)structures, "yucca_bookshelves", Blocks.f_50078_, (Block)AtmosphericBlocks.YUCCA_BOOKSHELF.get());
        AtmosphericStructureRepaletters.grimwoodAncientCity(context, (HolderGetter<Structure>)structures, "grimwood_logs", Blocks.f_50004_, (Block)AtmosphericBlocks.GRIMWOOD_LOG.get());
        AtmosphericStructureRepaletters.grimwoodAncientCity(context, (HolderGetter<Structure>)structures, "grimwood_fences", Blocks.f_50483_, (Block)AtmosphericBlocks.GRIMWOOD_FENCE.get());
        AtmosphericStructureRepaletters.grimwoodAncientCity(context, (HolderGetter<Structure>)structures, "grimwood_planks", Blocks.f_50745_, (Block)AtmosphericBlocks.GRIMWOOD_PLANKS.get());
        AtmosphericStructureRepaletters.grimwoodAncientCity(context, (HolderGetter<Structure>)structures, "grimwood_ladders", Blocks.f_50155_, (Block)AtmosphericBlocks.GRIMWOOD_LADDER.get());
        AtmosphericStructureRepaletters.grimwoodAncientCity(context, (HolderGetter<Structure>)structures, "grimwood_chests", Blocks.f_50087_, (Block)AtmosphericBlocks.GRIMWOOD_CHEST.get());
    }

    private static void yuccaDesertVillage(BootstapContext<StructureRepaletterEntry> context, HolderGetter<Structure> structures, String name, Block replacesBlock, Block replacesWith) {
        AtmosphericStructureRepaletters.basicRepaletter(context, structures, (ICondition)AtmosphericStructureRepaletters.config(AtmosphericConfig.COMMON.yuccaDesertVillages, "yucca_desert_villages"), name + "_in_desert_villages", replacesBlock, replacesWith, BuiltinStructures.f_209865_);
    }

    private static void grimwoodAncientCity(BootstapContext<StructureRepaletterEntry> context, HolderGetter<Structure> structures, String name, Block replacesBlock, Block replacesWith) {
        AtmosphericStructureRepaletters.basicRepaletter(context, structures, (ICondition)AtmosphericStructureRepaletters.config(AtmosphericConfig.COMMON.grimwoodAncientCities, "grimwood_ancient_cities"), name + "_in_ancient_cities", replacesBlock, replacesWith, BuiltinStructures.f_226492_);
    }

    @SafeVarargs
    private static void basicRepaletter(BootstapContext<StructureRepaletterEntry> context, HolderGetter<Structure> structures, ICondition condition, String name, Block replacesBlock, Block replacesWith, ResourceKey<Structure> ... selector) {
        context.m_255272_(AtmosphericStructureRepaletters.repaletterKey(name), (Object)new StructureRepaletterEntry((HolderSet)BlueprintHolderSets.conditional((HolderSet)HolderSet.m_205800_(Stream.of(selector).map(arg_0 -> structures.m_255043_(arg_0)).collect(Collectors.toList())), (ICondition[])new ICondition[]{condition}), Optional.empty(), false, (StructureRepaletter)new SimpleStructureRepaletter(replacesBlock, replacesWith)));
    }

    public static ConfigValueCondition config(ForgeConfigSpec.ConfigValue<?> value, String key, boolean inverted) {
        return new ConfigValueCondition(new ResourceLocation("atmospheric", "config"), value, key, (Map)Maps.newHashMap(), inverted);
    }

    public static ConfigValueCondition config(ForgeConfigSpec.ConfigValue<?> value, String key) {
        return AtmosphericStructureRepaletters.config(value, key, false);
    }

    private static ResourceKey<StructureRepaletterEntry> repaletterKey(String name) {
        return ResourceKey.m_135785_((ResourceKey)BlueprintDataPackRegistries.STRUCTURE_REPALETTERS, (ResourceLocation)new ResourceLocation("atmospheric", name));
    }
}

