/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.atmospheric.core.registry.builtin;

import javax.annotation.Nullable;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;

public class AtmosphericDamageTypes {
    public static final ResourceKey<DamageType> YUCCA_SAPLING = AtmosphericDamageTypes.createKey("yucca_sapling");
    public static final ResourceKey<DamageType> YUCCA_FLOWER = AtmosphericDamageTypes.createKey("yucca_flower");
    public static final ResourceKey<DamageType> YUCCA_BRANCH = AtmosphericDamageTypes.createKey("yucca_branch");
    public static final ResourceKey<DamageType> YUCCA_LEAVES = AtmosphericDamageTypes.createKey("yucca_leaves");
    public static final ResourceKey<DamageType> BARREL_CACTUS = AtmosphericDamageTypes.createKey("barrel_cactus");
    public static final ResourceKey<DamageType> ALOE_LEAVES = AtmosphericDamageTypes.createKey("aloe_leaves");
    public static final ResourceKey<DamageType> PASSION_FRUIT_SEED = AtmosphericDamageTypes.createKey("passion_fruit_seed");

    public static void bootstrap(BootstapContext<DamageType> context) {
        AtmosphericDamageTypes.register(context, PASSION_FRUIT_SEED, "passionFruitSeed", 0.1f);
        AtmosphericDamageTypes.register(context, YUCCA_FLOWER, "yuccaFlower", 0.1f);
        AtmosphericDamageTypes.register(context, YUCCA_BRANCH, "yuccaBranch", 0.1f);
        AtmosphericDamageTypes.register(context, YUCCA_LEAVES, "yuccaLeaves", 0.1f);
        AtmosphericDamageTypes.register(context, YUCCA_SAPLING, "yuccaSapling", 0.1f);
        AtmosphericDamageTypes.register(context, BARREL_CACTUS, "barrelCactus", 0.1f);
        AtmosphericDamageTypes.register(context, ALOE_LEAVES, "aloeLeaves", 0.1f);
    }

    public static DamageSource passionFruitSeed(Level level, Entity source, @Nullable Entity causingEntity) {
        return level.m_269111_().m_268998_(PASSION_FRUIT_SEED, source, causingEntity);
    }

    public static DamageSource barrelCactus(Level level) {
        return level.m_269111_().m_269079_(BARREL_CACTUS);
    }

    public static DamageSource aloeLeaves(Level level) {
        return level.m_269111_().m_269079_(ALOE_LEAVES);
    }

    public static Holder.Reference<DamageType> register(BootstapContext<DamageType> context, ResourceKey<DamageType> key, String localizationKey, float exhaustion) {
        return context.m_255272_(key, (Object)new DamageType("atmospheric." + localizationKey, exhaustion));
    }

    public static ResourceKey<DamageType> createKey(String name) {
        return ResourceKey.m_135785_((ResourceKey)Registries.f_268580_, (ResourceLocation)new ResourceLocation("atmospheric", name));
    }
}

