/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.atmospheric.core.registry;

import com.teamabnormals.atmospheric.core.other.AtmosphericGeneration;
import com.teamabnormals.atmospheric.core.registry.AtmosphericEntityTypes;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BiomeDefaultFeatures;
import net.minecraft.data.worldgen.BootstapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.Music;
import net.minecraft.sounds.Musics;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.biome.AmbientMoodSettings;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeGenerationSettings;
import net.minecraft.world.level.biome.BiomeSpecialEffects;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.levelgen.carver.ConfiguredWorldCarver;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="atmospheric", bus=Mod.EventBusSubscriber.Bus.MOD)
public class AtmosphericBiomes {
    public static final ResourceKey<Biome> RAINFOREST = AtmosphericBiomes.createKey("rainforest");
    public static final ResourceKey<Biome> SPARSE_RAINFOREST = AtmosphericBiomes.createKey("sparse_rainforest");
    public static final ResourceKey<Biome> RAINFOREST_BASIN = AtmosphericBiomes.createKey("rainforest_basin");
    public static final ResourceKey<Biome> SPARSE_RAINFOREST_BASIN = AtmosphericBiomes.createKey("sparse_rainforest_basin");
    public static final ResourceKey<Biome> DUNES = AtmosphericBiomes.createKey("dunes");
    public static final ResourceKey<Biome> FLOURISHING_DUNES = AtmosphericBiomes.createKey("flourishing_dunes");
    public static final ResourceKey<Biome> ROCKY_DUNES = AtmosphericBiomes.createKey("rocky_dunes");
    public static final ResourceKey<Biome> PETRIFIED_DUNES = AtmosphericBiomes.createKey("petrified_dunes");
    public static final ResourceKey<Biome> SPINY_THICKET = AtmosphericBiomes.createKey("spiny_thicket");
    public static final ResourceKey<Biome> SCRUBLAND = AtmosphericBiomes.createKey("scrubland");
    public static final ResourceKey<Biome> SNOWY_SCRUBLAND = AtmosphericBiomes.createKey("snowy_scrubland");
    public static final ResourceKey<Biome> ASPEN_PARKLAND = AtmosphericBiomes.createKey("aspen_parkland");
    public static final ResourceKey<Biome> LAUREL_FOREST = AtmosphericBiomes.createKey("laurel_forest");
    public static final ResourceKey<Biome> KOUSA_JUNGLE = AtmosphericBiomes.createKey("kousa_jungle");
    public static final ResourceKey<Biome> GRIMWOODS = AtmosphericBiomes.createKey("grimwoods");
    public static final ResourceKey<Biome> HOT_SPRINGS = AtmosphericBiomes.createKey("hot_springs");
    public static final List<ResourceKey<Biome>> NATURAL_BIOMES = List.of(RAINFOREST, SPARSE_RAINFOREST, RAINFOREST_BASIN, SPARSE_RAINFOREST_BASIN, DUNES, FLOURISHING_DUNES, ROCKY_DUNES, PETRIFIED_DUNES, SPINY_THICKET, SCRUBLAND, SNOWY_SCRUBLAND, ASPEN_PARKLAND, LAUREL_FOREST, KOUSA_JUNGLE);

    public static void bootstrap(BootstapContext<Biome> context) {
        HolderGetter features = context.m_255420_(Registries.f_256988_);
        HolderGetter carvers = context.m_255420_(Registries.f_257003_);
        context.m_255272_(RAINFOREST, (Object)AtmosphericBiomes.rainforest((HolderGetter<PlacedFeature>)features, carvers, false, false));
        context.m_255272_(SPARSE_RAINFOREST, (Object)AtmosphericBiomes.rainforest((HolderGetter<PlacedFeature>)features, carvers, false, true));
        context.m_255272_(RAINFOREST_BASIN, (Object)AtmosphericBiomes.rainforest((HolderGetter<PlacedFeature>)features, carvers, true, false));
        context.m_255272_(SPARSE_RAINFOREST_BASIN, (Object)AtmosphericBiomes.rainforest((HolderGetter<PlacedFeature>)features, carvers, true, true));
        context.m_255272_(DUNES, (Object)AtmosphericBiomes.dunes((HolderGetter<PlacedFeature>)features, carvers, false, false));
        context.m_255272_(FLOURISHING_DUNES, (Object)AtmosphericBiomes.dunes((HolderGetter<PlacedFeature>)features, carvers, false, true));
        context.m_255272_(ROCKY_DUNES, (Object)AtmosphericBiomes.dunes((HolderGetter<PlacedFeature>)features, carvers, true, false));
        context.m_255272_(PETRIFIED_DUNES, (Object)AtmosphericBiomes.dunes((HolderGetter<PlacedFeature>)features, carvers, true, true));
        context.m_255272_(SPINY_THICKET, (Object)AtmosphericBiomes.spinyThicket((HolderGetter<PlacedFeature>)features, carvers));
        context.m_255272_(SCRUBLAND, (Object)AtmosphericBiomes.scrubland((HolderGetter<PlacedFeature>)features, carvers, false));
        context.m_255272_(SNOWY_SCRUBLAND, (Object)AtmosphericBiomes.scrubland((HolderGetter<PlacedFeature>)features, carvers, true));
        context.m_255272_(ASPEN_PARKLAND, (Object)AtmosphericBiomes.aspenParkland((HolderGetter<PlacedFeature>)features, carvers));
        context.m_255272_(LAUREL_FOREST, (Object)AtmosphericBiomes.laurelForest((HolderGetter<PlacedFeature>)features, carvers));
        context.m_255272_(KOUSA_JUNGLE, (Object)AtmosphericBiomes.kousaJungle((HolderGetter<PlacedFeature>)features, carvers));
        context.m_255272_(GRIMWOODS, (Object)AtmosphericBiomes.grimwoods((HolderGetter<PlacedFeature>)features, carvers));
        context.m_255272_(HOT_SPRINGS, (Object)AtmosphericBiomes.hotSprings((HolderGetter<PlacedFeature>)features, carvers));
    }

    public static ResourceKey<Biome> createKey(String name) {
        return ResourceKey.m_135785_((ResourceKey)Registries.f_256952_, (ResourceLocation)new ResourceLocation("atmospheric", name));
    }

    private static Biome rainforest(HolderGetter<PlacedFeature> features, HolderGetter<ConfiguredWorldCarver<?>> carvers, boolean basin, boolean sparse) {
        BiomeGenerationSettings.Builder generation = new BiomeGenerationSettings.Builder(features, carvers);
        AtmosphericGeneration.rainforest(generation, basin, sparse);
        MobSpawnSettings.Builder spawns = new MobSpawnSettings.Builder();
        BiomeDefaultFeatures.m_126788_((MobSpawnSettings.Builder)spawns);
        BiomeDefaultFeatures.m_126734_((MobSpawnSettings.Builder)spawns);
        spawns.m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(EntityType.f_20508_, 40, 1, 2));
        spawns.m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(EntityType.f_20499_, 8, 4, 4));
        return AtmosphericBiomes.biome(true, 0.9f, 0.95f, 6675400, 408635, spawns, generation, null);
    }

    private static Biome dunes(HolderGetter<PlacedFeature> features, HolderGetter<ConfiguredWorldCarver<?>> carvers, boolean rocky, boolean variant) {
        BiomeGenerationSettings.Builder generation = new BiomeGenerationSettings.Builder(features, carvers);
        AtmosphericGeneration.dunes(generation, rocky, variant);
        MobSpawnSettings.Builder spawns = new MobSpawnSettings.Builder();
        BiomeDefaultFeatures.m_176859_((MobSpawnSettings.Builder)spawns);
        BiomeDefaultFeatures.m_194725_((MobSpawnSettings.Builder)spawns, (int)19, (int)1, (int)100, (boolean)false);
        spawns.m_48376_(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData(EntityType.f_20458_, 80, 4, 4));
        return AtmosphericBiomes.biome(false, 2.0f, 0.0f, 14988944, spawns, generation, null);
    }

    private static Biome spinyThicket(HolderGetter<PlacedFeature> features, HolderGetter<ConfiguredWorldCarver<?>> carvers) {
        BiomeGenerationSettings.Builder generation = new BiomeGenerationSettings.Builder(features, carvers);
        AtmosphericGeneration.spinyThicket(generation);
        MobSpawnSettings.Builder spawns = new MobSpawnSettings.Builder();
        BiomeDefaultFeatures.m_176859_((MobSpawnSettings.Builder)spawns);
        BiomeDefaultFeatures.m_194725_((MobSpawnSettings.Builder)spawns, (int)19, (int)1, (int)100, (boolean)false);
        spawns.m_48376_(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData(EntityType.f_20458_, 80, 4, 4));
        return AtmosphericBiomes.biome(false, 2.0f, 0.85f, 14988944, spawns, generation, null);
    }

    private static Biome scrubland(HolderGetter<PlacedFeature> features, HolderGetter<ConfiguredWorldCarver<?>> carvers, boolean snowy) {
        BiomeGenerationSettings.Builder generation = new BiomeGenerationSettings.Builder(features, carvers);
        AtmosphericGeneration.scrubland(generation, snowy);
        MobSpawnSettings.Builder spawns = new MobSpawnSettings.Builder();
        spawns.m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(EntityType.f_20457_, 2, 1, 1));
        spawns.m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(EntityType.f_20560_, 1, 1, 1));
        spawns.m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(EntityType.f_20555_, 2, 2, 4));
        spawns.m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData((EntityType)AtmosphericEntityTypes.COCHINEAL.get(), 4, 1, 4));
        BiomeDefaultFeatures.m_176859_((MobSpawnSettings.Builder)spawns);
        BiomeDefaultFeatures.m_194725_((MobSpawnSettings.Builder)spawns, (int)19, (int)1, (int)(!snowy ? 100 : 20), (boolean)false);
        spawns.m_48376_(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData(EntityType.f_20458_, 80, 4, 4));
        if (snowy) {
            spawns.m_48376_(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData(EntityType.f_20481_, 80, 4, 4));
        }
        return AtmosphericBiomes.biome(snowy, !snowy ? 2.0f : 0.0f, 0.0f, 13021599, spawns, generation, null);
    }

    private static Biome aspenParkland(HolderGetter<PlacedFeature> features, HolderGetter<ConfiguredWorldCarver<?>> carvers) {
        BiomeGenerationSettings.Builder generation = new BiomeGenerationSettings.Builder(features, carvers);
        AtmosphericGeneration.aspenParkland(generation);
        MobSpawnSettings.Builder spawns = new MobSpawnSettings.Builder();
        BiomeDefaultFeatures.m_126788_((MobSpawnSettings.Builder)spawns);
        spawns.m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(EntityType.f_20499_, 10, 1, 1));
        spawns.m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(EntityType.f_20517_, 15, 1, 1));
        return AtmosphericBiomes.biome(true, 2.0f, 0.0f, spawns, generation, Musics.m_263184_((Holder)SoundEvents.f_283788_));
    }

    private static Biome kousaJungle(HolderGetter<PlacedFeature> features, HolderGetter<ConfiguredWorldCarver<?>> carvers) {
        BiomeGenerationSettings.Builder generation = new BiomeGenerationSettings.Builder(features, carvers);
        AtmosphericGeneration.kousaJungle(generation);
        MobSpawnSettings.Builder spawns = new MobSpawnSettings.Builder();
        BiomeDefaultFeatures.m_126734_((MobSpawnSettings.Builder)spawns);
        spawns.m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(EntityType.f_20499_, 8, 4, 4));
        spawns.m_48376_(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData(EntityType.f_20505_, 2, 1, 3));
        BiomeDefaultFeatures.m_126788_((MobSpawnSettings.Builder)spawns);
        return AtmosphericBiomes.biome(true, -0.5f, 0.5f, spawns, generation, null);
    }

    private static Biome grimwoods(HolderGetter<PlacedFeature> features, HolderGetter<ConfiguredWorldCarver<?>> carvers) {
        BiomeGenerationSettings.Builder generation = new BiomeGenerationSettings.Builder(features, carvers);
        AtmosphericGeneration.grimwoods(generation);
        MobSpawnSettings.Builder spawns = new MobSpawnSettings.Builder();
        BiomeDefaultFeatures.m_126788_((MobSpawnSettings.Builder)spawns);
        return AtmosphericBiomes.biome(true, 0.25f, 0.0f, 9539946, 8882547, 5403055, 0x131333, 9866116, spawns, generation, null);
    }

    private static Biome laurelForest(HolderGetter<PlacedFeature> features, HolderGetter<ConfiguredWorldCarver<?>> carvers) {
        BiomeGenerationSettings.Builder generation = new BiomeGenerationSettings.Builder(features, carvers);
        AtmosphericGeneration.laurelForest(generation);
        MobSpawnSettings.Builder spawns = new MobSpawnSettings.Builder();
        BiomeDefaultFeatures.m_126788_((MobSpawnSettings.Builder)spawns);
        BiomeDefaultFeatures.m_126734_((MobSpawnSettings.Builder)spawns);
        spawns.m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(EntityType.f_20499_, 5, 4, 4));
        return AtmosphericBiomes.biomeWithGrass(true, 0.85f, 0.5f, 12249691, 11392595, spawns, generation, Musics.m_263184_((Holder)SoundEvents.f_283788_));
    }

    private static Biome hotSprings(HolderGetter<PlacedFeature> features, HolderGetter<ConfiguredWorldCarver<?>> carvers) {
        BiomeGenerationSettings.Builder generation = new BiomeGenerationSettings.Builder(features, carvers);
        AtmosphericGeneration.hotSprings(generation);
        MobSpawnSettings.Builder spawns = new MobSpawnSettings.Builder();
        BiomeDefaultFeatures.m_126788_((MobSpawnSettings.Builder)spawns);
        BiomeDefaultFeatures.m_126734_((MobSpawnSettings.Builder)spawns);
        spawns.m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(EntityType.f_20499_, 8, 4, 4));
        spawns.m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(EntityType.f_20517_, 4, 2, 3));
        spawns.m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(EntityType.f_20452_, 8, 2, 4));
        return AtmosphericBiomes.biome(false, 0.25f, 0.4f, 4445678, 270131, spawns, generation, null);
    }

    private static Biome biome(boolean precipitation, float temperature, float downfall, MobSpawnSettings.Builder spawns, BiomeGenerationSettings.Builder generation, @Nullable Music music) {
        return AtmosphericBiomes.biome(precipitation, temperature, downfall, 12638463, spawns, generation, music);
    }

    private static Biome biome(boolean precipitation, float temperature, float downfall, int waterColor, int waterFogColor, MobSpawnSettings.Builder spawns, BiomeGenerationSettings.Builder generation, @Nullable Music music) {
        return AtmosphericBiomes.biome(precipitation, temperature, downfall, waterColor, waterFogColor, 12638463, spawns, generation, music);
    }

    private static Biome biome(boolean precipitation, float temperature, float downfall, int fogColor, MobSpawnSettings.Builder spawns, BiomeGenerationSettings.Builder generation, @Nullable Music music) {
        return AtmosphericBiomes.biome(precipitation, temperature, downfall, 4159204, 329011, fogColor, spawns, generation, music);
    }

    private static Biome biome(boolean precipitation, float temperature, float downfall, int waterColor, int waterFogColor, int fogColor, MobSpawnSettings.Builder spawns, BiomeGenerationSettings.Builder generation, @Nullable Music music) {
        return new Biome.BiomeBuilder().m_264558_(precipitation).m_47609_(temperature).m_47611_(downfall).m_47603_(new BiomeSpecialEffects.Builder().m_48034_(waterColor).m_48037_(waterFogColor).m_48019_(fogColor).m_48040_(AtmosphericBiomes.calculateSkyColor(temperature)).m_48027_(AmbientMoodSettings.f_47387_).m_48021_(music).m_48018_()).m_47605_(spawns.m_48381_()).m_47601_(generation.m_255380_()).m_47592_();
    }

    private static Biome biomeWithGrass(boolean precipitation, float temperature, float downfall, int grassColor, int foliageColor, MobSpawnSettings.Builder spawns, BiomeGenerationSettings.Builder generation, @Nullable Music music) {
        return new Biome.BiomeBuilder().m_264558_(precipitation).m_47609_(temperature).m_47611_(downfall).m_47603_(new BiomeSpecialEffects.Builder().m_48045_(grassColor).m_48043_(foliageColor).m_48034_(4159204).m_48037_(329011).m_48019_(12638463).m_48040_(AtmosphericBiomes.calculateSkyColor(temperature)).m_48027_(AmbientMoodSettings.f_47387_).m_48021_(music).m_48018_()).m_47605_(spawns.m_48381_()).m_47601_(generation.m_255380_()).m_47592_();
    }

    private static Biome biome(boolean precipitation, float temperature, float downfall, int grassColor, int foliageColor, int waterColor, int waterFogColor, int fogColor, MobSpawnSettings.Builder spawns, BiomeGenerationSettings.Builder generation, @Nullable Music music) {
        return new Biome.BiomeBuilder().m_264558_(precipitation).m_47609_(temperature).m_47611_(downfall).m_47603_(new BiomeSpecialEffects.Builder().m_48045_(grassColor).m_48043_(foliageColor).m_48034_(waterColor).m_48037_(waterFogColor).m_48019_(fogColor).m_48040_(AtmosphericBiomes.calculateSkyColor(temperature)).m_48027_(AmbientMoodSettings.f_47387_).m_48021_(music).m_48018_()).m_47605_(spawns.m_48381_()).m_47601_(generation.m_255380_()).m_47592_();
    }

    private static int calculateSkyColor(float temperature) {
        float clampedTemp = Mth.m_14036_((float)(temperature / 3.0f), (float)-1.0f, (float)1.0f);
        return Mth.m_14169_((float)(0.62222224f - clampedTemp * 0.05f), (float)(0.5f + clampedTemp * 0.1f), (float)1.0f);
    }
}

