/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.atmospheric.core.data.client;

import com.teamabnormals.atmospheric.common.block.DragonRootsBlock;
import com.teamabnormals.atmospheric.common.block.OrangeBlock;
import com.teamabnormals.atmospheric.common.block.state.properties.DragonRootsStage;
import com.teamabnormals.atmospheric.core.Atmospheric;
import com.teamabnormals.atmospheric.core.other.AtmosphericBlockFamilies;
import com.teamabnormals.atmospheric.core.registry.AtmosphericBlocks;
import com.teamabnormals.blueprint.core.data.client.BlueprintBlockStateProvider;
import net.minecraft.core.Direction;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.ConfiguredModel;
import net.minecraftforge.client.model.generators.ModelBuilder;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.client.model.generators.MultiPartBlockStateBuilder;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.registries.RegistryObject;

public class AtmosphericBlockStateProvider
extends BlueprintBlockStateProvider {
    public AtmosphericBlockStateProvider(PackOutput output, ExistingFileHelper helper) {
        super(output, "atmospheric", helper);
    }

    protected void registerStatesAndModels() {
        this.blockFamily(AtmosphericBlockFamilies.DOLERITE_FAMILY);
        this.blockFamily(AtmosphericBlockFamilies.POLISHED_DOLERITE_FAMILY);
        this.blockFamily(AtmosphericBlockFamilies.ROSEWOOD_PLANKS_FAMILY);
        this.logBlocks(AtmosphericBlocks.ROSEWOOD_LOG, AtmosphericBlocks.ROSEWOOD);
        this.logBlocks(AtmosphericBlocks.STRIPPED_ROSEWOOD_LOG, AtmosphericBlocks.STRIPPED_ROSEWOOD);
        this.leavesBlock(AtmosphericBlocks.ROSEWOOD_LEAVES);
        this.crossBlockWithPot(AtmosphericBlocks.ROSEWOOD_SAPLING, AtmosphericBlocks.POTTED_ROSEWOOD_SAPLING);
        this.hangingSignBlocks(AtmosphericBlocks.STRIPPED_ROSEWOOD_LOG, AtmosphericBlocks.ROSEWOOD_HANGING_SIGNS);
        this.woodworksBlocks(AtmosphericBlocks.ROSEWOOD_PLANKS, AtmosphericBlocks.ROSEWOOD_BOARDS, AtmosphericBlocks.ROSEWOOD_LADDER, AtmosphericBlocks.ROSEWOOD_BOOKSHELF, AtmosphericBlocks.ROSEWOOD_BEEHIVE, AtmosphericBlocks.ROSEWOOD_CHEST, AtmosphericBlocks.TRAPPED_ROSEWOOD_CHEST);
        this.chiseledBookshelfBlock(AtmosphericBlocks.CHISELED_ROSEWOOD_BOOKSHELF, DEFAULT_BOOKSHELF_POSITIONS);
        this.leafPileBlock(AtmosphericBlocks.ROSEWOOD_LEAVES, AtmosphericBlocks.ROSEWOOD_LEAF_PILE);
        this.directionalBlock(AtmosphericBlocks.PASSION_FRUIT_CRATE);
        this.directionalBlockSharedBottom(AtmosphericBlocks.SHIMMERING_PASSION_FRUIT_CRATE, AtmosphericBlocks.PASSION_FRUIT_CRATE);
        this.blockFamily(AtmosphericBlockFamilies.MORADO_PLANKS_FAMILY);
        this.logBlocks(AtmosphericBlocks.MORADO_LOG, AtmosphericBlocks.MORADO_WOOD);
        this.logBlocks(AtmosphericBlocks.STRIPPED_MORADO_LOG, AtmosphericBlocks.STRIPPED_MORADO_WOOD);
        this.leavesBlock(AtmosphericBlocks.MORADO_LEAVES);
        this.crossBlockWithPot(AtmosphericBlocks.MORADO_SAPLING, AtmosphericBlocks.POTTED_MORADO_SAPLING);
        this.hangingSignBlocks(AtmosphericBlocks.STRIPPED_MORADO_LOG, AtmosphericBlocks.MORADO_HANGING_SIGNS);
        this.woodworksBlocks(AtmosphericBlocks.MORADO_PLANKS, AtmosphericBlocks.MORADO_BOARDS, AtmosphericBlocks.MORADO_LADDER, AtmosphericBlocks.MORADO_BOOKSHELF, AtmosphericBlocks.MORADO_BEEHIVE, AtmosphericBlocks.MORADO_CHEST, AtmosphericBlocks.TRAPPED_MORADO_CHEST);
        this.chiseledBookshelfBlock(AtmosphericBlocks.CHISELED_MORADO_BOOKSHELF, ALTERNATE_BOOKSHELF_POSITIONS);
        this.leafPileBlock(AtmosphericBlocks.MORADO_LEAVES, AtmosphericBlocks.MORADO_LEAF_PILE);
        this.blockFamily(AtmosphericBlockFamilies.YUCCA_PLANKS_FAMILY);
        this.logBlocks(AtmosphericBlocks.YUCCA_LOG, AtmosphericBlocks.YUCCA_WOOD);
        this.logBlocks(AtmosphericBlocks.STRIPPED_YUCCA_LOG, AtmosphericBlocks.STRIPPED_YUCCA_WOOD);
        this.leavesBlock(AtmosphericBlocks.YUCCA_LEAVES);
        this.crossBlockWithPot(AtmosphericBlocks.YUCCA_SAPLING, AtmosphericBlocks.POTTED_YUCCA_SAPLING);
        this.hangingSignBlocks(AtmosphericBlocks.STRIPPED_YUCCA_LOG, AtmosphericBlocks.YUCCA_HANGING_SIGNS);
        this.woodworksBlocks(AtmosphericBlocks.YUCCA_PLANKS, AtmosphericBlocks.YUCCA_BOARDS, AtmosphericBlocks.YUCCA_LADDER, AtmosphericBlocks.YUCCA_BOOKSHELF, AtmosphericBlocks.YUCCA_BEEHIVE, AtmosphericBlocks.YUCCA_CHEST, AtmosphericBlocks.TRAPPED_YUCCA_CHEST);
        this.chiseledBookshelfBlock(AtmosphericBlocks.CHISELED_YUCCA_BOOKSHELF, DEFAULT_BOOKSHELF_POSITIONS);
        this.leafPileBlock(AtmosphericBlocks.YUCCA_LEAVES, AtmosphericBlocks.YUCCA_LEAF_PILE);
        this.directionalBlock(AtmosphericBlocks.YUCCA_CASK);
        this.directionalBlockSharedSide(AtmosphericBlocks.ROASTED_YUCCA_CASK, AtmosphericBlocks.YUCCA_CASK);
        this.flowerPotBlock(AtmosphericBlocks.POTTED_ALOE_VERA);
        this.brushableBlock(AtmosphericBlocks.SUSPICIOUS_ARID_SAND);
        this.brushableBlock(AtmosphericBlocks.SUSPICIOUS_RED_ARID_SAND);
        this.blockFamily(AtmosphericBlockFamilies.ASPEN_PLANKS_FAMILY);
        this.logBlocks(AtmosphericBlocks.ASPEN_LOG, AtmosphericBlocks.ASPEN_WOOD);
        this.logBlocks(AtmosphericBlocks.STRIPPED_ASPEN_LOG, AtmosphericBlocks.STRIPPED_ASPEN_WOOD);
        this.watchfulAspenLogBlocks(AtmosphericBlocks.ASPEN_LOG, AtmosphericBlocks.WATCHFUL_ASPEN_LOG, AtmosphericBlocks.WATCHFUL_ASPEN_WOOD);
        this.leavesBlock(AtmosphericBlocks.ASPEN_LEAVES);
        this.crossBlockWithPot(AtmosphericBlocks.ASPEN_SAPLING, AtmosphericBlocks.POTTED_ASPEN_SAPLING);
        this.hangingSignBlocks(AtmosphericBlocks.STRIPPED_ASPEN_LOG, AtmosphericBlocks.ASPEN_HANGING_SIGNS);
        this.woodworksBlocks(AtmosphericBlocks.ASPEN_PLANKS, AtmosphericBlocks.ASPEN_BOARDS, AtmosphericBlocks.ASPEN_LADDER, AtmosphericBlocks.ASPEN_BOOKSHELF, AtmosphericBlocks.ASPEN_BEEHIVE, AtmosphericBlocks.ASPEN_CHEST, AtmosphericBlocks.TRAPPED_ASPEN_CHEST);
        this.chiseledBookshelfBlock(AtmosphericBlocks.CHISELED_ASPEN_BOOKSHELF, ALTERNATE_BOOKSHELF_POSITIONS);
        this.leafPileBlock(AtmosphericBlocks.ASPEN_LEAVES, AtmosphericBlocks.ASPEN_LEAF_PILE);
        this.leavesBlock(AtmosphericBlocks.GREEN_ASPEN_LEAVES);
        this.crossBlockWithPot(AtmosphericBlocks.GREEN_ASPEN_SAPLING, AtmosphericBlocks.POTTED_GREEN_ASPEN_SAPLING);
        this.leafPileBlock(AtmosphericBlocks.GREEN_ASPEN_LEAVES, AtmosphericBlocks.GREEN_ASPEN_LEAF_PILE);
        this.crossBlockWithCustomPot(AtmosphericBlocks.AGAVE, AtmosphericBlocks.POTTED_AGAVE);
        this.crossBlockWithCustomPot(AtmosphericBlocks.GOLDEN_GROWTHS, AtmosphericBlocks.POTTED_GOLDEN_GROWTHS);
        this.blockFamily(AtmosphericBlockFamilies.LAUREL_PLANKS_FAMILY);
        this.logBlocks(AtmosphericBlocks.LAUREL_LOG, AtmosphericBlocks.LAUREL_WOOD);
        this.logBlocks(AtmosphericBlocks.STRIPPED_LAUREL_LOG, AtmosphericBlocks.STRIPPED_LAUREL_WOOD);
        this.leavesBlock(AtmosphericBlocks.LAUREL_LEAVES);
        this.crossBlockWithPot(AtmosphericBlocks.LAUREL_SAPLING, AtmosphericBlocks.POTTED_LAUREL_SAPLING);
        this.hangingSignBlocks(AtmosphericBlocks.STRIPPED_LAUREL_LOG, AtmosphericBlocks.LAUREL_HANGING_SIGNS);
        this.woodworksBlocks(AtmosphericBlocks.LAUREL_PLANKS, AtmosphericBlocks.LAUREL_BOARDS, AtmosphericBlocks.LAUREL_LADDER, AtmosphericBlocks.LAUREL_BOOKSHELF, AtmosphericBlocks.LAUREL_BEEHIVE, AtmosphericBlocks.LAUREL_CHEST, AtmosphericBlocks.TRAPPED_LAUREL_CHEST);
        this.chiseledBookshelfBlock(AtmosphericBlocks.CHISELED_LAUREL_BOOKSHELF);
        this.leafPileBlock(AtmosphericBlocks.LAUREL_LEAVES, AtmosphericBlocks.LAUREL_LEAF_PILE);
        this.leavesBlock(AtmosphericBlocks.DRY_LAUREL_LEAVES);
        this.crossBlockWithPot(AtmosphericBlocks.DRY_LAUREL_SAPLING, AtmosphericBlocks.POTTED_DRY_LAUREL_SAPLING);
        this.leafPileBlock(AtmosphericBlocks.DRY_LAUREL_LEAVES, AtmosphericBlocks.DRY_LAUREL_LEAF_PILE);
        this.orange(AtmosphericBlocks.ORANGE);
        this.orange(AtmosphericBlocks.BLOOD_ORANGE);
        this.directionalBlock(AtmosphericBlocks.ORANGE_CRATE);
        this.directionalBlock(AtmosphericBlocks.BLOOD_ORANGE_CRATE);
        this.blockFamily(AtmosphericBlockFamilies.KOUSA_PLANKS_FAMILY);
        this.logBlocks(AtmosphericBlocks.KOUSA_LOG, AtmosphericBlocks.KOUSA_WOOD);
        this.logBlocks(AtmosphericBlocks.STRIPPED_KOUSA_LOG, AtmosphericBlocks.STRIPPED_KOUSA_WOOD);
        this.leavesBlock(AtmosphericBlocks.KOUSA_LEAVES);
        this.crossBlockWithPot(AtmosphericBlocks.KOUSA_SAPLING, AtmosphericBlocks.POTTED_KOUSA_SAPLING);
        this.hangingSignBlocks(AtmosphericBlocks.STRIPPED_KOUSA_LOG, AtmosphericBlocks.KOUSA_HANGING_SIGNS);
        this.woodworksBlocks(AtmosphericBlocks.KOUSA_PLANKS, AtmosphericBlocks.KOUSA_BOARDS, AtmosphericBlocks.KOUSA_LADDER, AtmosphericBlocks.KOUSA_BOOKSHELF, AtmosphericBlocks.KOUSA_BEEHIVE, AtmosphericBlocks.KOUSA_CHEST, AtmosphericBlocks.TRAPPED_KOUSA_CHEST);
        this.chiseledBookshelfBlock(AtmosphericBlocks.CHISELED_KOUSA_BOOKSHELF, DEFAULT_BOOKSHELF_POSITIONS);
        this.leafPileBlock(AtmosphericBlocks.KOUSA_LEAVES, AtmosphericBlocks.KOUSA_LEAF_PILE);
        this.crossBlock(AtmosphericBlocks.HANGING_CURRANT);
        this.logBlock(AtmosphericBlocks.CURRANT_STALK_BUNDLE);
        this.leavesBlock(AtmosphericBlocks.CURRANT_LEAVES);
        this.crossBlockWithPot(AtmosphericBlocks.CURRANT_SEEDLING, AtmosphericBlocks.POTTED_CURRANT_SEEDLING);
        this.leafPileBlock(AtmosphericBlocks.CURRANT_LEAVES, AtmosphericBlocks.CURRANT_LEAF_PILE);
        this.directionalBlock(AtmosphericBlocks.CURRANT_CRATE);
        this.blockFamily(AtmosphericBlockFamilies.GRIMWOOD_PLANKS_FAMILY);
        this.logBlocks(AtmosphericBlocks.GRIMWOOD_LOG, AtmosphericBlocks.GRIMWOOD);
        this.logBlocks(AtmosphericBlocks.STRIPPED_GRIMWOOD_LOG, AtmosphericBlocks.STRIPPED_GRIMWOOD);
        this.leavesBlock(AtmosphericBlocks.GRIMWOOD_LEAVES);
        this.crossBlockWithPot(AtmosphericBlocks.GRIMWOOD_SAPLING, AtmosphericBlocks.POTTED_GRIMWOOD_SAPLING);
        this.hangingSignBlocks(AtmosphericBlocks.STRIPPED_GRIMWOOD_LOG, AtmosphericBlocks.GRIMWOOD_HANGING_SIGNS);
        this.woodworksBlocks(AtmosphericBlocks.GRIMWOOD_PLANKS, AtmosphericBlocks.GRIMWOOD_BOARDS, AtmosphericBlocks.GRIMWOOD_LADDER, AtmosphericBlocks.GRIMWOOD_BOOKSHELF, AtmosphericBlocks.GRIMWOOD_BEEHIVE, AtmosphericBlocks.GRIMWOOD_CHEST, AtmosphericBlocks.TRAPPED_GRIMWOOD_CHEST);
        this.chiseledBookshelfBlock(AtmosphericBlocks.CHISELED_GRIMWOOD_BOOKSHELF, ALTERNATE_BOOKSHELF_POSITIONS);
        this.leafPileBlock(AtmosphericBlocks.GRIMWOOD_LEAVES, AtmosphericBlocks.GRIMWOOD_LEAF_PILE);
        this.crossBlock(AtmosphericBlocks.GRIMWEB);
        this.directionalBlock(AtmosphericBlocks.CARMINE_BLOCK);
        this.blockFamily(AtmosphericBlockFamilies.CARMINE_SHINGLES_FAMILY);
        this.block((Block)AtmosphericBlocks.CHISELED_CARMINE_SHINGLES.get());
        this.blockFamily(AtmosphericBlockFamilies.CARMINE_PAVEMENT_FAMILY);
        this.crossBlockWithPot(AtmosphericBlocks.FIRETHORN, AtmosphericBlocks.POTTED_FIRETHORN);
        this.crossBlockWithPot(AtmosphericBlocks.FORSYTHIA, AtmosphericBlocks.POTTED_FORSYTHIA);
        this.directionalBlock(AtmosphericBlocks.DRAGON_FRUIT_CRATE);
        this.directionalBlockSharedSide(AtmosphericBlocks.GOLDEN_DRAGON_FRUIT_CRATE, AtmosphericBlocks.DRAGON_FRUIT_CRATE);
        this.dragonRoots(AtmosphericBlocks.DRAGON_ROOTS);
    }

    public void watchfulAspenLogBlocks(RegistryObject<Block> aspenLog, RegistryObject<Block> log, RegistryObject<Block> wood) {
        this.logBlock(log, this.blockTexture((Block)log.get()), AtmosphericBlockStateProvider.suffix((ResourceLocation)this.blockTexture((Block)aspenLog.get()), (String)"_top"));
        this.woodBlock(wood, log);
    }

    public void orange(RegistryObject<Block> block) {
        this.getVariantBuilder((Block)block.get()).forAllStatesExcept(state -> {
            boolean horizontal = Direction.Plane.HORIZONTAL.test((Direction)state.m_61143_((Property)BlockStateProperties.f_61372_));
            String addition = ((Integer)state.m_61143_((Property)OrangeBlock.ORANGES) == 2 ? "_double" : "") + (horizontal ? "_wall" : (state.m_61143_((Property)OrangeBlock.f_52588_) == Direction.DOWN ? "_ceiling" : ""));
            return ConfiguredModel.builder().modelFile((ModelFile)((BlockModelBuilder)((BlockModelBuilder)this.models().getBuilder(AtmosphericBlockStateProvider.name((Block)((Block)block.get())) + addition)).parent((ModelFile)new ModelFile.UncheckedModelFile(Atmospheric.location("block/template_orange" + addition)))).texture("orange", this.blockTexture((Block)block.get()))).rotationY(horizontal ? (int)((((Direction)state.m_61143_((Property)BlockStateProperties.f_61372_)).m_122435_() + 180.0f) % 360.0f) : 0).build();
        }, new Property[]{BlockStateProperties.f_61362_});
    }

    public void dragonRoots(RegistryObject<Block> block) {
        MultiPartBlockStateBuilder builder = this.getMultipartBuilder((Block)block.get());
        DragonRootsBlock.FACING.m_6908_().forEach(dir -> {
            int yRot = ((int)dir.m_122435_() + 180) % 360;
            for (DragonRootsStage stage : DragonRootsStage.values()) {
                if (stage == DragonRootsStage.NONE) continue;
                ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)new ModelFile.UncheckedModelFile(Atmospheric.location("block/dragon_roots_top"))).rotationY(yRot).addModel()).condition(DragonRootsBlock.TOP_STAGE, (Comparable[])new DragonRootsStage[]{stage}).condition((Property)DragonRootsBlock.FACING, (Comparable[])new Direction[]{dir});
                ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)new ModelFile.UncheckedModelFile(Atmospheric.location("block/dragon_roots_bottom"))).rotationY(yRot).addModel()).condition(DragonRootsBlock.BOTTOM_STAGE, (Comparable[])new DragonRootsStage[]{stage}).condition((Property)DragonRootsBlock.FACING, (Comparable[])new Direction[]{dir});
                if (stage == DragonRootsStage.ROOTS) continue;
                boolean flowering = stage == DragonRootsStage.FLOWERING || stage == DragonRootsStage.FLOWERING_ENDER;
                boolean ender = stage == DragonRootsStage.ENDER || stage == DragonRootsStage.FLOWERING_ENDER;
                String name = (flowering ? "flowering_" : "") + (ender ? "ender_" : "") + "dragon_fruit";
                String texture = Atmospheric.location("block/" + name).toString();
                String parent = "block/template_" + (flowering ? "flowering_" : "") + "dragon_fruit";
                ModelBuilder top = ((BlockModelBuilder)((BlockModelBuilder)this.models().getBuilder(Atmospheric.location(name) + "_top")).parent((ModelFile)new ModelFile.UncheckedModelFile(Atmospheric.location(parent + "_top")))).texture("fruit", texture);
                ModelBuilder bottom = ((BlockModelBuilder)((BlockModelBuilder)this.models().getBuilder(Atmospheric.location(name) + "_bottom")).parent((ModelFile)new ModelFile.UncheckedModelFile(Atmospheric.location(parent + "_bottom")))).texture("fruit", texture);
                if (flowering) {
                    ResourceLocation emissiveTexture = Atmospheric.location("block/flowering_dragon_fruit_emissive");
                    top = top.texture("overlay", emissiveTexture).renderType("translucent");
                    bottom = bottom.texture("overlay", emissiveTexture).renderType("translucent");
                }
                ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)top).rotationY(yRot).addModel()).condition(DragonRootsBlock.TOP_STAGE, (Comparable[])new DragonRootsStage[]{stage}).condition((Property)DragonRootsBlock.FACING, (Comparable[])new Direction[]{dir});
                ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)bottom).rotationY(yRot).addModel()).condition(DragonRootsBlock.BOTTOM_STAGE, (Comparable[])new DragonRootsStage[]{stage}).condition((Property)DragonRootsBlock.FACING, (Comparable[])new Direction[]{dir});
            }
        });
    }

    public void flowerPotBlock(RegistryObject<Block> flowerPot, ResourceLocation potTexture) {
        this.simpleBlock((Block)flowerPot.get(), (ModelFile)this.models().singleTexture(AtmosphericBlockStateProvider.name((Block)((Block)flowerPot.get())), new ResourceLocation("block/flower_pot_cross"), "plant", potTexture));
    }

    public void flowerPotBlock(RegistryObject<Block> flowerPot) {
        this.flowerPotBlock(flowerPot, this.blockTexture((Block)flowerPot.get()));
    }
}

