/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.atmospheric.common.entity.projectile;

import com.teamabnormals.atmospheric.common.block.DragonRootsBlock;
import com.teamabnormals.atmospheric.common.block.state.properties.DragonRootsStage;
import com.teamabnormals.atmospheric.core.registry.AtmosphericBlocks;
import com.teamabnormals.atmospheric.core.registry.AtmosphericEntityTypes;
import com.teamabnormals.atmospheric.core.registry.AtmosphericItems;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.network.PlayMessages;

public class DragonFruit
extends Entity {
    private static final EntityDataAccessor<Boolean> IS_FLOWERING = SynchedEntityData.m_135353_(DragonFruit.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> IS_ENDER = SynchedEntityData.m_135353_(DragonFruit.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private Direction rollingDirection;
    public int rollingTicks = 200;

    public DragonFruit(EntityType<?> entityType, Level level) {
        super(entityType, level);
        this.f_19850_ = true;
    }

    public DragonFruit(PlayMessages.SpawnEntity message, Level level) {
        this((EntityType)AtmosphericEntityTypes.DRAGON_FRUIT.get(), level);
    }

    public boolean m_6087_() {
        return true;
    }

    public boolean m_6094_() {
        return true;
    }

    public ItemStack m_142340_() {
        return this.getItem();
    }

    public ItemStack getItem() {
        return new ItemStack(this.isEnder() ? (ItemLike)AtmosphericItems.ENDER_DRAGON_FRUIT.get() : (ItemLike)AtmosphericItems.DRAGON_FRUIT.get());
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(IS_ENDER, (Object)false);
        this.f_19804_.m_135372_(IS_FLOWERING, (Object)false);
    }

    protected void m_7378_(CompoundTag tag) {
        tag.m_128405_("RollingTicks", this.rollingTicks);
        tag.m_128405_("RollingDirection", this.getRollingDirection().m_122411_());
    }

    protected void m_7380_(CompoundTag tag) {
        this.rollingTicks = tag.m_128451_("RollingTicks");
        this.rollingDirection = Direction.m_122376_((int)tag.m_128451_("RollingDirection"));
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.isInFluidType()) {
            this.showBreakingParticles();
            this.brokenByPlayer();
            this.m_6074_();
        }
        if (!this.m_20068_()) {
            this.m_20256_(this.m_20184_().m_82520_(0.0, -0.04, 0.0));
        }
        if (!this.m_20096_() || this.m_20184_().m_165925_() > (double)1.0E-5f || (this.f_19797_ + this.m_19879_()) % 4 == 0) {
            this.m_6478_(MoverType.SELF, this.m_20184_());
            float f1 = 0.98f;
            if (this.m_20096_()) {
                f1 = this.m_9236_().m_8055_(BlockPos.m_274561_((double)this.m_20185_(), (double)(this.m_20186_() - 1.0), (double)this.m_20189_())).getFriction((LevelReader)this.m_9236_(), BlockPos.m_274561_((double)this.m_20185_(), (double)(this.m_20186_() - 1.0), (double)this.m_20189_()), (Entity)this) * 0.98f;
            }
            this.m_20256_(this.m_20184_().m_82542_((double)f1, 0.98, (double)f1));
            if (this.m_20096_()) {
                Vec3 vec31 = this.m_20184_();
                if (vec31.f_82480_ < 0.0) {
                    this.m_20256_(vec31.m_82542_(1.0, -0.5, 1.0));
                }
            }
        }
        if (this.rollingTicks > 0) {
            --this.rollingTicks;
        } else {
            this.showBreakingParticles();
            this.brokenByPlayer();
            this.m_6074_();
        }
        if (this.f_19862_) {
            this.showBreakingParticles();
            this.brokenByPlayer();
            this.m_6074_();
        }
        if (this.getRollingDirection() != null && (this.f_19797_ + this.m_19879_()) % 4 == 0) {
            Vec3i direction = this.getRollingDirection().m_122436_();
            double speed = (double)this.rollingTicks / 1000.0;
            speed = Math.max(speed, 0.1);
            if (!this.m_20096_()) {
                speed *= 0.1;
            }
            this.m_5997_((double)direction.m_123341_() * speed, 0.0, (double)direction.m_123343_() * speed);
        }
    }

    public void setFlowering(boolean flowering) {
        this.f_19804_.m_135381_(IS_FLOWERING, (Object)flowering);
    }

    public boolean isFlowering() {
        return (Boolean)this.f_19804_.m_135370_(IS_FLOWERING);
    }

    public boolean attemptPlaceRoots() {
        if (this.isFlowering() && !this.m_9236_().m_5776_()) {
            BlockState rootsState = (BlockState)((BlockState)((BlockState)((Block)AtmosphericBlocks.DRAGON_ROOTS.get()).m_49966_().m_61124_(DragonRootsBlock.TOP_STAGE, (Comparable)((Object)DragonRootsStage.ROOTS))).m_61124_(DragonRootsBlock.BOTTOM_STAGE, (Comparable)((Object)DragonRootsStage.NONE))).m_61124_((Property)DragonRootsBlock.FACING, (Comparable)this.getRollingDirection().m_122424_());
            BlockPos pos = this.m_20183_();
            BlockState state = this.m_9236_().m_8055_(pos);
            for (int i = 0; i < 4; ++i) {
                if (i > 0) {
                    rootsState = (BlockState)rootsState.m_61122_((Property)DragonRootsBlock.FACING);
                }
                if (this.m_9236_().m_46859_(pos) && rootsState.m_60710_((LevelReader)this.m_9236_(), pos)) {
                    this.m_9236_().m_46597_(pos, rootsState);
                    return true;
                }
                if (!state.m_60713_((Block)AtmosphericBlocks.DRAGON_ROOTS.get()) || DragonRootsBlock.isDouble(state)) continue;
                if (state.m_61143_(DragonRootsBlock.TOP_STAGE) == DragonRootsStage.NONE) {
                    state = (BlockState)state.m_61124_(DragonRootsBlock.TOP_STAGE, (Comparable)((Object)DragonRootsStage.ROOTS));
                }
                if (state.m_61143_(DragonRootsBlock.BOTTOM_STAGE) == DragonRootsStage.NONE) {
                    state = (BlockState)state.m_61124_(DragonRootsBlock.BOTTOM_STAGE, (Comparable)((Object)DragonRootsStage.ROOTS));
                }
                this.m_9236_().m_46597_(pos, state);
                return true;
            }
            Block.m_49840_((Level)this.m_9236_(), (BlockPos)this.m_20183_(), (ItemStack)new ItemStack((ItemLike)AtmosphericBlocks.DRAGON_ROOTS.get()));
        }
        return false;
    }

    public void setEnder(boolean ender) {
        this.f_19804_.m_135381_(IS_ENDER, (Object)ender);
    }

    public boolean isEnder() {
        return (Boolean)this.f_19804_.m_135370_(IS_ENDER);
    }

    public boolean m_142389_() {
        return true;
    }

    public Direction getRollingDirection() {
        return this.rollingDirection;
    }

    public void setRollingDirection(Direction direction) {
        this.rollingDirection = direction;
    }

    public boolean m_6469_(DamageSource source, float damage) {
        if (!this.m_9236_().f_46443_ && !this.m_213877_()) {
            if (source.m_276093_(DamageTypes.f_268724_)) {
                this.m_6074_();
                return false;
            }
            if (!this.m_6673_(source)) {
                if (source.m_269533_(DamageTypeTags.f_268415_)) {
                    this.brokenByPlayer();
                    this.m_6074_();
                    return false;
                }
                boolean flag = source.m_7640_() instanceof AbstractArrow;
                boolean flag1 = flag && ((AbstractArrow)source.m_7640_()).m_36796_() > 0;
                boolean flag2 = "player".equals(source.m_19385_());
                if (!flag2 && !flag) {
                    return false;
                }
                if (source.m_7639_() instanceof Player && !((Player)source.m_7639_()).m_150110_().f_35938_) {
                    return false;
                }
                if (source.m_19390_()) {
                    this.playBrokenSound();
                    this.showBreakingParticles();
                    this.m_6074_();
                    return flag1;
                }
                this.brokenByPlayer();
                this.showBreakingParticles();
                this.m_6074_();
                return true;
            }
            return false;
        }
        return false;
    }

    private void brokenByPlayer() {
        Block.m_49840_((Level)this.m_9236_(), (BlockPos)this.m_20183_(), (ItemStack)this.getItem());
        if (!this.attemptPlaceRoots()) {
            this.playBrokenSound();
        }
    }

    private void showBreakingParticles() {
        Level level = this.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            serverLevel.m_8767_((ParticleOptions)new ItemParticleOption(ParticleTypes.f_123752_, this.getItem()), this.m_20185_(), this.m_20227_(0.6666666666666666), this.m_20189_(), 10, (double)(this.m_20205_() / 4.0f), (double)(this.m_20206_() / 4.0f), (double)(this.m_20205_() / 4.0f), 0.05);
        }
    }

    private void playBrokenSound() {
        this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_12455_, this.m_5720_(), 1.0f, 1.0f);
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

