/*
 * Decompiled with CFR 0.152.
 */
package com.kekecreations.arts_and_crafts_compatibility;

import com.kekecreations.arts_and_crafts_compatibility.ForgeArtsAndCraftsCompatibility;
import com.kekecreations.arts_and_crafts_compatibility.core.platform.Services;
import com.kekecreations.arts_and_crafts_compatibility.core.registry.ACCEntityTypes;
import com.kekecreations.arts_and_crafts_compatibility.core.registry.compat.EcologicsFlowerPots;
import java.nio.file.Path;
import net.minecraft.SharedConstants;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.NoopRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.PathPackResources;
import net.minecraft.server.packs.repository.Pack;
import net.minecraft.server.packs.repository.PackSource;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.event.AddPackFindersEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.forgespi.language.IModFileInfo;

@Mod.EventBusSubscriber(modid="arts_and_crafts_compat", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.MOD)
public class ForgeArtsAndCraftsCompatibilityClient {
    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public static void registerRenderers(EntityRenderersEvent.RegisterRenderers event) {
        event.registerEntityRenderer(ACCEntityTypes.ENTITY_FOR_SITTING.get(), NoopRenderer::new);
    }

    @SubscribeEvent
    public static void clientSetup(FMLClientSetupEvent event) {
        for (DyeColor colour : DyeColor.values()) {
            if (!ForgeArtsAndCraftsCompatibility.isModLoaded("ecologics")) continue;
            ItemBlockRenderTypes.setRenderLayer((Block)EcologicsFlowerPots.getDyedPottedWalnutSapling(colour), (RenderType)RenderType.m_110463_());
            ItemBlockRenderTypes.setRenderLayer((Block)EcologicsFlowerPots.getDyedPottedAzaleaFlower(colour), (RenderType)RenderType.m_110463_());
            ItemBlockRenderTypes.setRenderLayer((Block)EcologicsFlowerPots.getDyedPottedCoconutSeedling(colour), (RenderType)RenderType.m_110463_());
        }
    }

    @SubscribeEvent
    public static void addPackFinders(AddPackFindersEvent event) {
        if (event.getPackType() == PackType.SERVER_DATA) {
            if (Services.PLATFORM.isModLoaded("twigs")) {
                ForgeArtsAndCraftsCompatibilityClient.bpTwigs(event);
            }
            if (Services.PLATFORM.isModLoaded("built")) {
                ForgeArtsAndCraftsCompatibilityClient.bpBuilt(event);
            }
            if (Services.PLATFORM.isModLoaded("ecologics")) {
                ForgeArtsAndCraftsCompatibilityClient.bpEcologics(event);
            }
        }
    }

    private static void bpEcologics(AddPackFindersEvent event) {
        IModFileInfo mod = ModList.get().getModFileById("arts_and_crafts_compat");
        Path file = mod.getFile().findResource(new String[]{"resourcepacks/ecologics_datapack"});
        event.addRepositorySource(packConsumer -> packConsumer.accept(Pack.m_245512_((String)"ecologics_datapack", (Component)Component.m_237113_((String)"Ecologic Compatibility Data Pack"), (boolean)false, path -> new PathPackResources(path, file, true), (Pack.Info)new Pack.Info((Component)Component.m_237113_((String)"Arts & Crafts Compat features for Ecologics"), SharedConstants.m_183709_().m_264084_(PackType.SERVER_DATA), FeatureFlagSet.m_246902_()), (PackType)PackType.SERVER_DATA, (Pack.Position)Pack.Position.TOP, (boolean)true, (PackSource)PackSource.f_10528_)));
    }

    private static void bpTwigs(AddPackFindersEvent event) {
        IModFileInfo mod = ModList.get().getModFileById("arts_and_crafts_compat");
        Path file = mod.getFile().findResource(new String[]{"resourcepacks/twigs_datapack"});
        event.addRepositorySource(packConsumer -> packConsumer.accept(Pack.m_245512_((String)"twigs_datapack", (Component)Component.m_237113_((String)"Twigs Compatibility Data Pack"), (boolean)false, path -> new PathPackResources(path, file, true), (Pack.Info)new Pack.Info((Component)Component.m_237113_((String)"Arts & Crafts Compat features for Twigs"), SharedConstants.m_183709_().m_264084_(PackType.SERVER_DATA), FeatureFlagSet.m_246902_()), (PackType)PackType.SERVER_DATA, (Pack.Position)Pack.Position.TOP, (boolean)true, (PackSource)PackSource.f_10528_)));
    }

    private static void bpBuilt(AddPackFindersEvent event) {
        IModFileInfo mod = ModList.get().getModFileById("arts_and_crafts_compat");
        Path file = mod.getFile().findResource(new String[]{"resourcepacks/built_datapack"});
        event.addRepositorySource(packConsumer -> packConsumer.accept(Pack.m_245512_((String)"built_datapack", (Component)Component.m_237113_((String)"Built Compatibility Data Pack"), (boolean)false, path -> new PathPackResources(path, file, true), (Pack.Info)new Pack.Info((Component)Component.m_237113_((String)"Arts & Crafts Compat features for Built"), SharedConstants.m_183709_().m_264084_(PackType.SERVER_DATA), FeatureFlagSet.m_246902_()), (PackType)PackType.SERVER_DATA, (Pack.Position)Pack.Position.TOP, (boolean)true, (PackSource)PackSource.f_10528_)));
    }
}

