/*
 * Decompiled with CFR 0.152.
 */
package com.kekecreations.arts_and_crafts.forge;

import com.kekecreations.arts_and_crafts.ArtsAndCrafts;
import com.kekecreations.arts_and_crafts.common.item.palette.PaintbrushPalette;
import com.kekecreations.arts_and_crafts.common.util.CreativeCategoryUtils;
import com.kekecreations.arts_and_crafts.core.registry.ACBlocks;
import com.kekecreations.arts_and_crafts.core.registry.ACItems;
import com.kekecreations.arts_and_crafts.core.registry.ACRegistries;
import com.kekecreations.arts_and_crafts.core.registry.ACSpriteSources;
import com.kekecreations.arts_and_crafts.forge.common.ACCompostables;
import com.kekecreations.arts_and_crafts.forge.core.config.ForgeConfig;
import com.kekecreations.arts_and_crafts.forge.core.platform.ForgeRegistryHelper;
import com.kekecreations.arts_and_crafts.forge.core.registry.ACLootModifiers;
import com.kekecreations.arts_and_crafts.forge.datagen.client.ArtsAndCraftsBlockStateProvider;
import com.kekecreations.arts_and_crafts.forge.datagen.client.ArtsAndCraftsItemModelProvider;
import com.kekecreations.arts_and_crafts.forge.datagen.client.ArtsAndCraftsLangProvider;
import com.kekecreations.arts_and_crafts.forge.datagen.server.ArtsAndCraftsBiomeTagsProvider;
import com.kekecreations.arts_and_crafts.forge.datagen.server.ArtsAndCraftsBlockTagsProvider;
import com.kekecreations.arts_and_crafts.forge.datagen.server.ArtsAndCraftsItemTagsProvider;
import com.kekecreations.arts_and_crafts.forge.datagen.server.ArtsAndCraftsLootTableProvider;
import com.kekecreations.arts_and_crafts.forge.datagen.server.ArtsAndCraftsRecipeProvider;
import java.util.concurrent.CompletableFuture;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.event.BuildCreativeModeTabContentsEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLLoadCompleteEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.DataPackRegistryEvent;

@Mod(value="arts_and_crafts")
public class ArtsAndCraftsForge {
    public ArtsAndCraftsForge() {
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)ForgeConfig.SPEC, "arts-and-crafts.toml");
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> ACSpriteSources::register);
        ArtsAndCrafts.init();
        ForgeRegistryHelper.SOUNDS.register(modEventBus);
        ForgeRegistryHelper.PARTICLE_TYPES.register(modEventBus);
        ForgeRegistryHelper.BLOCKS.register(modEventBus);
        ForgeRegistryHelper.ITEMS.register(modEventBus);
        ACLootModifiers.register(modEventBus);
        modEventBus.addListener(this::creativeItemGroups);
        modEventBus.addListener(this::gatherData);
        modEventBus.addListener(this::datapackRegistry);
        modEventBus.addListener(this::loadCompleteEvent);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void gatherData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        PackOutput packOutput = generator.getPackOutput();
        ExistingFileHelper fileHelper = event.getExistingFileHelper();
        CompletableFuture lookupProvider = event.getLookupProvider();
        generator.addProvider(event.includeClient(), (DataProvider)new ArtsAndCraftsLangProvider(packOutput, "arts_and_crafts"));
        generator.addProvider(event.includeClient(), (DataProvider)new ArtsAndCraftsItemModelProvider(packOutput, "arts_and_crafts", fileHelper));
        generator.addProvider(event.includeClient(), (DataProvider)new ArtsAndCraftsBlockStateProvider(packOutput, "arts_and_crafts", fileHelper));
        generator.addProvider(event.includeServer(), (DataProvider)new ArtsAndCraftsRecipeProvider(packOutput));
        ArtsAndCraftsBlockTagsProvider blockTagProvider = new ArtsAndCraftsBlockTagsProvider(packOutput, lookupProvider, "arts_and_crafts", fileHelper);
        generator.addProvider(event.includeServer(), (DataProvider)blockTagProvider);
        generator.addProvider(event.includeServer(), (DataProvider)new ArtsAndCraftsItemTagsProvider(packOutput, lookupProvider, blockTagProvider.m_274426_(), "arts_and_crafts", fileHelper));
        generator.addProvider(event.includeServer(), (DataProvider)new ArtsAndCraftsLootTableProvider(packOutput));
        generator.addProvider(event.includeServer(), (DataProvider)new ArtsAndCraftsBiomeTagsProvider(packOutput, lookupProvider, "arts_and_crafts", fileHelper));
    }

    private void loadCompleteEvent(FMLLoadCompleteEvent event) {
        ACCompostables.register();
    }

    public void datapackRegistry(DataPackRegistryEvent.NewRegistry event) {
        event.dataPackRegistry(ACRegistries.PAINTBRUSH_PALETTE, PaintbrushPalette.CODEC);
    }

    private void addAfter(BuildCreativeModeTabContentsEvent event, Item beforeItem, Item item) {
        event.getEntries().putAfter((Object)beforeItem.m_7968_(), (Object)item.m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
    }

    private void addAfter(BuildCreativeModeTabContentsEvent event, Block beforeItem, Item item) {
        event.getEntries().putAfter((Object)beforeItem.m_5456_().m_7968_(), (Object)item.m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
    }

    private void addAfter(BuildCreativeModeTabContentsEvent event, Item beforeItem, Block item) {
        event.getEntries().putAfter((Object)beforeItem.m_7968_(), (Object)item.m_5456_().m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
    }

    private void addAfter(BuildCreativeModeTabContentsEvent event, Block beforeItem, Block item) {
        event.getEntries().putAfter((Object)beforeItem.m_5456_().m_7968_(), (Object)item.m_5456_().m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
    }

    private void addBefore(BuildCreativeModeTabContentsEvent event, Block beforeItem, Block item) {
        event.getEntries().putBefore((Object)beforeItem.m_5456_().m_7968_(), (Object)item.m_5456_().m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
    }

    private void addBefore(BuildCreativeModeTabContentsEvent event, Item beforeItem, Item item) {
        event.getEntries().putBefore((Object)beforeItem.m_7968_(), (Object)item.m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
    }

    public void creativeItemGroups(BuildCreativeModeTabContentsEvent event) {
        if (event.getTabKey() == CreativeModeTabs.f_256725_) {
            this.addAfter(event, Blocks.f_50532_, ACBlocks.TERRACOTTA_SHINGLES.get());
            this.addAfter(event, ACBlocks.TERRACOTTA_SHINGLES.get(), (Block)ACBlocks.TERRACOTTA_SHINGLE_STAIRS.get());
            this.addAfter(event, (Block)ACBlocks.TERRACOTTA_SHINGLE_STAIRS.get(), (Block)ACBlocks.TERRACOTTA_SHINGLE_SLAB.get());
            this.addAfter(event, (Block)ACBlocks.TERRACOTTA_SHINGLE_SLAB.get(), (Block)ACBlocks.TERRACOTTA_SHINGLE_WALL.get());
            this.addAfter(event, ACBlocks.getChalk(DyeColor.PINK.m_41060_()), ACBlocks.SOAPSTONE.get());
            this.addAfter(event, ACBlocks.SOAPSTONE.get(), (Block)ACBlocks.SOAPSTONE_STAIRS.get());
            this.addAfter(event, (Block)ACBlocks.SOAPSTONE_STAIRS.get(), (Block)ACBlocks.SOAPSTONE_SLAB.get());
            this.addAfter(event, (Block)ACBlocks.SOAPSTONE_SLAB.get(), (Block)ACBlocks.SOAPSTONE_WALL.get());
            this.addAfter(event, (Block)ACBlocks.SOAPSTONE_WALL.get(), ACBlocks.POLISHED_SOAPSTONE.get());
            this.addAfter(event, ACBlocks.POLISHED_SOAPSTONE.get(), (Block)ACBlocks.POLISHED_SOAPSTONE_STAIRS.get());
            this.addAfter(event, (Block)ACBlocks.POLISHED_SOAPSTONE_STAIRS.get(), (Block)ACBlocks.POLISHED_SOAPSTONE_SLAB.get());
            this.addAfter(event, (Block)ACBlocks.POLISHED_SOAPSTONE_SLAB.get(), (Block)ACBlocks.POLISHED_SOAPSTONE_WALL.get());
            this.addAfter(event, (Block)ACBlocks.POLISHED_SOAPSTONE_WALL.get(), ACBlocks.SOAPSTONE_BRICKS.get());
            this.addAfter(event, ACBlocks.SOAPSTONE_BRICKS.get(), (Block)ACBlocks.SOAPSTONE_BRICK_STAIRS.get());
            this.addAfter(event, (Block)ACBlocks.SOAPSTONE_BRICK_STAIRS.get(), (Block)ACBlocks.SOAPSTONE_BRICK_SLAB.get());
            this.addAfter(event, (Block)ACBlocks.SOAPSTONE_BRICK_SLAB.get(), (Block)ACBlocks.SOAPSTONE_BRICK_WALL.get());
            this.addAfter(event, Blocks.f_50362_, (Block)ACBlocks.PLASTER.get());
            this.addBefore(event, Blocks.f_50041_, ACBlocks.BLEACHED_WOOL.get());
            this.addBefore(event, Blocks.f_50336_, ACBlocks.BLEACHED_CARPET.get());
            this.addBefore(event, Blocks.f_50542_, ACBlocks.BLEACHED_CONCRETE.get());
            this.addBefore(event, Blocks.f_50506_, ACBlocks.BLEACHED_CONCRETE_POWDER.get());
            this.addBefore(event, Blocks.f_50526_, ACBlocks.GLAZED_TERRACOTTA.get());
            this.addBefore(event, Blocks.f_50066_, ACBlocks.BLEACHED_BED.get());
            for (DyeColor colours : CreativeCategoryUtils.colourOrder) {
                this.addAfter(event, Items.f_42666_, ACBlocks.getChalk(colours.m_41060_()));
                this.addAfter(event, Items.f_151072_, ACBlocks.getDyedFlowerPot(colours.m_41060_()));
                this.addAfter(event, ACBlocks.getDyedFlowerPot(DyeColor.PINK.m_41060_()), ACBlocks.getDyedDecoratedPot(colours.m_41060_()));
                this.addAfter(event, (Block)ACBlocks.TERRACOTTA_SHINGLE_WALL.get(), ACBlocks.getDyedTerracottaShingles(colours.m_41060_()));
                this.addAfter(event, ACBlocks.getDyedTerracottaShingles(colours.m_41060_()), ACBlocks.getDyedTerracottaShingleStairs(colours.m_41060_()));
                this.addAfter(event, ACBlocks.getDyedTerracottaShingleStairs(colours.m_41060_()), ACBlocks.getDyedTerracottaShingleSlab(colours.m_41060_()));
                this.addAfter(event, ACBlocks.getDyedTerracottaShingleSlab(colours.m_41060_()), ACBlocks.getDyedTerracottaShingleWall(colours.m_41060_()));
                this.addAfter(event, (Block)ACBlocks.SOAPSTONE_BRICK_WALL.get(), ACBlocks.getDyedSoapstone(colours.m_41060_()));
                this.addAfter(event, ACBlocks.getDyedSoapstone(colours.m_41060_()), ACBlocks.getDyedSoapstoneStairs(colours.m_41060_()));
                this.addAfter(event, ACBlocks.getDyedSoapstoneStairs(colours.m_41060_()), ACBlocks.getDyedSoapstoneSlab(colours.m_41060_()));
                this.addAfter(event, ACBlocks.getDyedSoapstoneSlab(colours.m_41060_()), ACBlocks.getDyedSoapstoneWall(colours.m_41060_()));
                this.addAfter(event, ACBlocks.getDyedSoapstoneWall(colours.m_41060_()), ACBlocks.getDyedPolishedSoapstone(colours.m_41060_()));
                this.addAfter(event, ACBlocks.getDyedPolishedSoapstone(colours.m_41060_()), ACBlocks.getDyedPolishedSoapstoneStairs(colours.m_41060_()));
                this.addAfter(event, ACBlocks.getDyedPolishedSoapstoneStairs(colours.m_41060_()), ACBlocks.getDyedPolishedSoapstoneSlab(colours.m_41060_()));
                this.addAfter(event, ACBlocks.getDyedPolishedSoapstoneSlab(colours.m_41060_()), ACBlocks.getDyedPolishedSoapstoneWall(colours.m_41060_()));
                this.addAfter(event, ACBlocks.getDyedPolishedSoapstoneWall(colours.m_41060_()), ACBlocks.getDyedSoapstoneBricks(colours.m_41060_()));
                this.addAfter(event, ACBlocks.getDyedSoapstoneBricks(colours.m_41060_()), ACBlocks.getDyedSoapstoneBrickStairs(colours.m_41060_()));
                this.addAfter(event, ACBlocks.getDyedSoapstoneBrickStairs(colours.m_41060_()), ACBlocks.getDyedSoapstoneBrickSlab(colours.m_41060_()));
                this.addAfter(event, ACBlocks.getDyedSoapstoneBrickSlab(colours.m_41060_()), ACBlocks.getDyedSoapstoneBrickWall(colours.m_41060_()));
                this.addAfter(event, ACBlocks.getDyedSoapstoneBrickWall(DyeColor.PINK.m_41060_()), ACBlocks.getDyedMudBricks(colours.m_41060_()));
                this.addAfter(event, ACBlocks.getDyedMudBricks(colours.m_41060_()), ACBlocks.getDyedMudBrickStairs(colours.m_41060_()));
                this.addAfter(event, ACBlocks.getDyedMudBrickStairs(colours.m_41060_()), ACBlocks.getDyedMudBrickSlab(colours.m_41060_()));
                this.addAfter(event, ACBlocks.getDyedMudBrickSlab(colours.m_41060_()), ACBlocks.getDyedMudBrickWall(colours.m_41060_()));
                this.addAfter(event, (Block)ACBlocks.PLASTER.get(), ACBlocks.getDyedPlaster(colours.m_41060_()));
            }
            this.addBefore(event, ACBlocks.getChalk(DyeColor.WHITE.m_41060_()), ACBlocks.BLEACHED_CHALK.get());
        }
        if (event.getTabKey() == CreativeModeTabs.f_256776_) {
            event.m_246326_((ItemLike)ACBlocks.getChalk(DyeColor.WHITE.m_41060_()));
            event.m_246326_((ItemLike)ACBlocks.SOAPSTONE.get());
            event.m_246326_((ItemLike)ACBlocks.GYPSUM.get());
            this.addAfter(event, Blocks.f_50003_, (Block)ACBlocks.CORK_LOG.get());
            this.addAfter(event, Blocks.f_50054_, (Block)ACBlocks.CORK_LEAVES.get());
            this.addAfter(event, Blocks.f_50750_, (Block)ACBlocks.CORK_SAPLING.get());
            this.addAfter(event, Items.f_42094_, ACItems.LOTUS_PISTILS.get());
        }
        if (event.getTabKey() == CreativeModeTabs.f_256869_) {
            for (DyeColor colours : CreativeCategoryUtils.colourOrder) {
                this.addAfter(event, Items.f_42693_, (Item)ACItems.getChalkStick(colours.m_41060_()));
                this.addAfter(event, Items.f_271356_, (Item)ACItems.getPaintBrush(colours.m_41060_()));
            }
            this.addBefore(event, ACItems.getChalkStick(DyeColor.WHITE.m_41060_()), ACItems.BLEACHED_CHALK_STICK.get());
            this.addBefore(event, ACItems.getPaintBrush(DyeColor.WHITE.m_41060_()), ACItems.BLEACHDEW_PAINTBRUSH.get());
            this.addAfter(event, Items.f_220202_, (Item)ACItems.CORK_BOAT.get());
            this.addAfter(event, (Item)ACItems.CORK_BOAT.get(), (Item)ACItems.CORK_CHEST_BOAT.get());
        }
        if (event.getTabKey() == CreativeModeTabs.f_256791_) {
            for (DyeColor colours : CreativeCategoryUtils.colourOrder) {
                this.addAfter(event, Items.f_42618_, ACBlocks.getDyedFlowerPot(colours.m_41060_()));
                this.addAfter(event, Items.f_271478_, ACBlocks.getDyedDecoratedPot(colours.m_41060_()));
            }
            this.addAfter(event, Items.f_244440_, (Item)ACItems.CORK_SIGN.get());
            this.addAfter(event, (Item)ACItems.CORK_SIGN.get(), (Item)ACItems.CORK_HANGING_SIGN.get());
        }
        if (event.getTabKey() == CreativeModeTabs.f_256788_) {
            this.addAfter(event, Blocks.f_50308_, (Block)ACBlocks.CORK_LOG.get());
            this.addAfter(event, (Block)ACBlocks.CORK_LOG.get(), (Block)ACBlocks.CORK_WOOD.get());
            this.addAfter(event, (Block)ACBlocks.CORK_WOOD.get(), (Block)ACBlocks.STRIPPED_CORK_LOG.get());
            this.addAfter(event, (Block)ACBlocks.STRIPPED_CORK_LOG.get(), (Block)ACBlocks.STRIPPED_CORK_WOOD.get());
            this.addAfter(event, (Block)ACBlocks.STRIPPED_CORK_WOOD.get(), (Block)ACBlocks.CORK.get());
            this.addAfter(event, (Block)ACBlocks.CORK.get(), (Block)ACBlocks.SMOOTH_CORK.get());
            this.addAfter(event, (Block)ACBlocks.SMOOTH_CORK.get(), (Block)ACBlocks.CORK_PLANKS.get());
            this.addAfter(event, (Block)ACBlocks.CORK_PLANKS.get(), (Block)ACBlocks.CORK_STAIRS.get());
            this.addAfter(event, (Block)ACBlocks.CORK_STAIRS.get(), (Block)ACBlocks.CORK_SLAB.get());
            this.addAfter(event, (Block)ACBlocks.CORK_SLAB.get(), (Block)ACBlocks.CORK_FENCE.get());
            this.addAfter(event, (Block)ACBlocks.CORK_FENCE.get(), (Block)ACBlocks.CORK_FENCE_GATE.get());
            this.addAfter(event, (Block)ACBlocks.CORK_FENCE_GATE.get(), (Block)ACBlocks.CORK_DOOR.get());
            this.addAfter(event, (Block)ACBlocks.CORK_DOOR.get(), (Block)ACBlocks.CORK_TRAPDOOR.get());
            this.addAfter(event, (Block)ACBlocks.CORK_TRAPDOOR.get(), (Block)ACBlocks.CORK_PRESSURE_PLATE.get());
            this.addAfter(event, (Block)ACBlocks.CORK_PRESSURE_PLATE.get(), (Block)ACBlocks.CORK_BUTTON.get());
            this.addAfter(event, Blocks.f_220854_, ACBlocks.GYPSUM.get());
            this.addAfter(event, ACBlocks.GYPSUM.get(), (Block)ACBlocks.GYPSUM_STAIRS.get());
            this.addAfter(event, (Block)ACBlocks.GYPSUM_STAIRS.get(), (Block)ACBlocks.GYPSUM_SLAB.get());
            this.addAfter(event, (Block)ACBlocks.GYPSUM_SLAB.get(), (Block)ACBlocks.GYPSUM_WALL.get());
            this.addAfter(event, (Block)ACBlocks.GYPSUM_WALL.get(), ACBlocks.POLISHED_GYPSUM.get());
            this.addAfter(event, ACBlocks.POLISHED_GYPSUM.get(), (Block)ACBlocks.POLISHED_GYPSUM_STAIRS.get());
            this.addAfter(event, (Block)ACBlocks.POLISHED_GYPSUM_STAIRS.get(), (Block)ACBlocks.POLISHED_GYPSUM_SLAB.get());
            this.addAfter(event, (Block)ACBlocks.POLISHED_GYPSUM_SLAB.get(), (Block)ACBlocks.POLISHED_GYPSUM_WALL.get());
            this.addAfter(event, (Block)ACBlocks.POLISHED_GYPSUM_WALL.get(), ACBlocks.GYPSUM_BRICKS.get());
            this.addAfter(event, ACBlocks.GYPSUM_BRICKS.get(), (Block)ACBlocks.GYPSUM_BRICK_STAIRS.get());
            this.addAfter(event, (Block)ACBlocks.GYPSUM_BRICK_STAIRS.get(), (Block)ACBlocks.GYPSUM_BRICK_SLAB.get());
            this.addAfter(event, (Block)ACBlocks.GYPSUM_BRICK_SLAB.get(), (Block)ACBlocks.GYPSUM_BRICK_WALL.get());
        }
        if (event.getTabKey() == CreativeModeTabs.f_256968_) {
            this.addAfter(event, Items.f_279528_, ACItems.ROLL_POTTERY_SHERD.get());
            this.addBefore(event, Items.f_279584_, ACItems.FINALE_POTTERY_SHERD.get());
            this.addAfter(event, Items.f_279584_, ACItems.GATEWAY_POTTERY_SHERD.get());
            this.addBefore(event, Items.f_279633_, ACItems.RUINED_POTTERY_SHERD.get());
            this.addBefore(event, ACItems.RUINED_POTTERY_SHERD.get(), ACItems.POTTERY_SHERD.get());
            this.addBefore(event, Items.f_42535_, ACItems.BLEACHDEW.get());
        }
    }
}

