/*
 * Decompiled with CFR 0.152.
 */
package com.kekecreations.arts_and_crafts.common.util;

import com.kekecreations.arts_and_crafts.common.entity.DyedDecoratedPotBlockEntity;
import com.kekecreations.arts_and_crafts.common.item.palette.PaintbrushPalette;
import com.kekecreations.arts_and_crafts.core.mixin.DecoratedPotBlockEntityAccessor;
import com.kekecreations.arts_and_crafts.core.registry.ACRegistries;
import com.kekecreations.arts_and_crafts.core.registry.ACSounds;
import java.util.Optional;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.DecoratedPotBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BedPart;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import org.jetbrains.annotations.Nullable;

public class PaintbrushUtils {
    public static void setPotDecorations(Level level, BlockPos pos, DecoratedPotBlockEntity.Decorations decorations) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof DyedDecoratedPotBlockEntity) {
            DyedDecoratedPotBlockEntity dyedPot = (DyedDecoratedPotBlockEntity)blockEntity;
            dyedPot.setDecoration(decorations);
        } else if (blockEntity instanceof DecoratedPotBlockEntityAccessor) {
            DecoratedPotBlockEntityAccessor decoratedPot = (DecoratedPotBlockEntityAccessor)blockEntity;
            decoratedPot.setDecorations(decorations);
        }
    }

    @Nullable
    public static Block getFinalBlock(RegistryAccess access, BlockState state, ItemStack stack) {
        Optional<PaintbrushPalette> optionalPalette = access.m_175515_(ACRegistries.PAINTBRUSH_PALETTE).m_123024_().filter(searchPalette -> searchPalette.blocks().m_203333_(state.m_222976_())).findFirst();
        if (optionalPalette.isEmpty()) {
            return null;
        }
        PaintbrushPalette palette = optionalPalette.get();
        Holder<Block> holder = palette.mappings().get(stack.m_220173_());
        if (holder.m_203543_().isEmpty()) {
            return null;
        }
        return (Block)access.m_175515_(Registries.f_256747_).m_123013_((ResourceKey)holder.m_203543_().get());
    }

    public static void damagePaintbrushWhenPainting(Level level, Player player, ItemStack itemStack, BlockState blockState, BlockPos pos, InteractionHand hand) {
        if (!player.m_150110_().f_35937_) {
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                CriteriaTriggers.f_10591_.m_285767_(serverPlayer, pos, itemStack);
            }
            blockState.m_60734_().m_6402_(level, pos, blockState, (LivingEntity)player, itemStack);
            itemStack.m_41622_(1, (LivingEntity)player, entity -> entity.m_21190_(hand));
            if (itemStack.m_41619_()) {
                ItemStack itemStack2 = new ItemStack((ItemLike)Items.f_271356_);
                itemStack2.m_41751_(itemStack.m_41783_());
                player.m_21008_(hand, itemStack2);
            }
        }
    }

    public static void paintbrushItemEvents(Level level, BlockState state, BlockPos pos, Player player, ItemStack itemStack, InteractionHand hand) {
        level.m_5594_(null, pos, ACSounds.PAINT_WITH_PAINTBRUSH.get(), SoundSource.BLOCKS, 0.5f, 1.0f);
        level.m_220407_(GameEvent.f_157797_, pos, GameEvent.Context.m_223719_((Entity)player, (BlockState)state));
        player.m_36246_(Stats.f_12982_.m_12902_((Object)itemStack.m_41720_()));
        PaintbrushUtils.damagePaintbrushWhenPainting(level, player, itemStack, state, pos, hand);
    }

    public static void paintBlock(Level level, BlockState blockStateToPlace, BlockPos pos, Player player, ItemStack itemStack, InteractionHand hand) {
        BlockState blockState = level.m_8055_(pos);
        level.m_46597_(pos, blockStateToPlace.m_60734_().m_152465_(blockState));
        PaintbrushUtils.paintbrushItemEvents(level, blockState, pos, player, itemStack, hand);
    }

    public static void paintBed(Level level, BlockState blockStateToPlace, BlockPos pos, Player player, ItemStack itemStack, InteractionHand hand) {
        BlockState blockState = level.m_8055_(pos);
        if (blockState.m_61143_((Property)BlockStateProperties.f_61391_) == BedPart.FOOT) {
            level.m_46597_(pos.m_121945_((Direction)blockState.m_61143_((Property)BlockStateProperties.f_61374_)), Blocks.f_50016_.m_49966_());
            level.m_46597_(pos, (BlockState)((BlockState)((BlockState)blockStateToPlace.m_61124_((Property)BlockStateProperties.f_61374_, (Comparable)((Direction)blockState.m_61143_((Property)BlockStateProperties.f_61374_)))).m_61124_((Property)BlockStateProperties.f_61391_, (Comparable)BedPart.FOOT)).m_61124_((Property)BlockStateProperties.f_61445_, (Comparable)((Boolean)blockState.m_61143_((Property)BlockStateProperties.f_61445_))));
            level.m_46597_(pos.m_121945_((Direction)blockState.m_61143_((Property)BlockStateProperties.f_61374_)), (BlockState)((BlockState)((BlockState)blockStateToPlace.m_61124_((Property)BlockStateProperties.f_61374_, (Comparable)((Direction)blockState.m_61143_((Property)BlockStateProperties.f_61374_)))).m_61124_((Property)BlockStateProperties.f_61391_, (Comparable)BedPart.HEAD)).m_61124_((Property)BlockStateProperties.f_61445_, (Comparable)((Boolean)blockState.m_61143_((Property)BlockStateProperties.f_61445_))));
        } else {
            level.m_46597_(pos, Blocks.f_50016_.m_49966_());
            level.m_46597_(pos, (BlockState)((BlockState)((BlockState)blockStateToPlace.m_61124_((Property)BlockStateProperties.f_61374_, (Comparable)((Direction)blockState.m_61143_((Property)BlockStateProperties.f_61374_)))).m_61124_((Property)BlockStateProperties.f_61391_, (Comparable)BedPart.HEAD)).m_61124_((Property)BlockStateProperties.f_61445_, (Comparable)((Boolean)blockState.m_61143_((Property)BlockStateProperties.f_61445_))));
            level.m_46597_(pos.m_5484_((Direction)blockState.m_61143_((Property)BlockStateProperties.f_61374_), -1), (BlockState)((BlockState)((BlockState)blockStateToPlace.m_61124_((Property)BlockStateProperties.f_61374_, (Comparable)((Direction)blockState.m_61143_((Property)BlockStateProperties.f_61374_)))).m_61124_((Property)BlockStateProperties.f_61391_, (Comparable)BedPart.FOOT)).m_61124_((Property)BlockStateProperties.f_61445_, (Comparable)((Boolean)blockState.m_61143_((Property)BlockStateProperties.f_61445_))));
        }
        itemStack.m_41622_(1, (LivingEntity)player, entity -> entity.m_21190_(hand));
        level.m_5594_(null, pos, SoundEvents.f_144153_, SoundSource.BLOCKS, 1.0f, 1.0f);
        level.m_220407_(GameEvent.f_157797_, pos, GameEvent.Context.m_223719_((Entity)player, (BlockState)blockState));
    }
}

