/*
 * Decompiled with CFR 0.152.
 */
package com.kekecreations.arts_and_crafts.common.entity;

import com.kekecreations.arts_and_crafts.common.block.Floatable;
import com.kekecreations.arts_and_crafts.common.block.FloatingBlock;
import com.kekecreations.arts_and_crafts.core.registry.ACBlocks;
import com.kekecreations.arts_and_crafts.core.registry.ACEntityTypes;
import com.mojang.logging.LogUtils;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.CrashReportCategory;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.AnvilBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public class FloatingBlockEntity
extends Entity {
    private static final Logger LOGGER = LogUtils.getLogger();
    private BlockState blockState = ACBlocks.CORK.get().m_49966_();
    public int time;
    public boolean dropItem = true;
    private boolean cancelDrop;
    private boolean hurtEntities;
    private int fallDamageMax = 40;
    private float fallDamagePerDistance;
    @Nullable
    public CompoundTag blockData;
    protected static final EntityDataAccessor<BlockPos> DATA_START_POS = SynchedEntityData.m_135353_(FloatingBlockEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135038_);

    public FloatingBlockEntity(EntityType<? extends FloatingBlockEntity> entityType, Level level) {
        super(entityType, level);
    }

    private FloatingBlockEntity(Level level, double d, double e, double f, BlockState blockState) {
        this(ACEntityTypes.FLOATING_BLOCK.get(), level);
        this.blockState = blockState;
        this.f_19850_ = true;
        this.m_6034_(d, e, f);
        this.m_20256_(Vec3.f_82478_);
        this.f_19854_ = d;
        this.f_19855_ = e;
        this.f_19856_ = f;
        this.setStartPos(this.m_20183_());
    }

    public static FloatingBlockEntity floating(Level level, BlockPos blockPos, BlockState blockState) {
        FloatingBlockEntity floatingBlockEntity = new FloatingBlockEntity(level, (double)blockPos.m_123341_() + 0.5, blockPos.m_123342_(), (double)blockPos.m_123343_() + 0.5, blockState.m_61138_((Property)BlockStateProperties.f_61362_) ? (BlockState)blockState.m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(false)) : blockState);
        level.m_7731_(blockPos, blockState.m_60819_().m_76188_(), 3);
        level.m_7967_((Entity)floatingBlockEntity);
        return floatingBlockEntity;
    }

    public static boolean canCollide(Entity entity) {
        return entity.m_5829_() || entity.m_6094_();
    }

    public boolean m_7337_(Entity entity) {
        return FloatingBlockEntity.canCollide(entity);
    }

    public boolean m_5829_() {
        return true;
    }

    private void moveCollidedEntities(List<Entity> pEntities) {
        for (Entity entity : pEntities) {
            entity.m_6478_(MoverType.PISTON, this.m_20184_().m_82520_(0.0, 0.3, 0.0));
        }
    }

    private void moveCollidedEntitiesToTheSurface(List<Entity> pEntities) {
        for (Entity entity : pEntities) {
            entity.m_6478_(MoverType.PISTON, this.m_20184_().m_82520_(0.0, 1.0, 0.0));
        }
    }

    public boolean m_6097_() {
        return false;
    }

    public void setStartPos(BlockPos blockPos) {
        this.f_19804_.m_135381_(DATA_START_POS, (Object)blockPos);
    }

    public BlockPos getStartPos() {
        return (BlockPos)this.f_19804_.m_135370_(DATA_START_POS);
    }

    protected Entity.MovementEmission m_142319_() {
        return Entity.MovementEmission.NONE;
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(DATA_START_POS, (Object)BlockPos.f_121853_);
    }

    public boolean m_6087_() {
        return !this.m_213877_();
    }

    public void m_8119_() {
        if (this.blockState.m_60795_()) {
            this.m_146870_();
            return;
        }
        Block block = this.blockState.m_60734_();
        this.m_6478_(MoverType.SELF, this.m_20184_());
        BlockPos blockPos = this.m_20183_();
        ++this.time;
        if (!this.m_9236_().f_46443_) {
            if (FloatingBlock.isInWater(this.m_9236_().m_8055_(blockPos.m_7494_())) && this.m_20184_().m_7098_() < 0.2) {
                this.m_20256_(this.m_20184_().m_82520_(0.0, 0.1, 0.0));
                this.moveCollidedEntities(this.m_9236_().m_6249_((Entity)this, this.m_20191_().m_82400_(0.1), EntitySelector.f_20406_));
            }
            if (FloatingBlock.isNotInWater(this.m_9236_().m_8055_(blockPos.m_7494_()))) {
                this.moveCollidedEntitiesToTheSurface(this.m_9236_().m_6249_((Entity)this, this.m_20191_().m_82400_(0.1), EntitySelector.f_20406_));
                this.m_20334_(0.0, 0.0, 0.0);
                this.m_9236_().m_7731_(blockPos, this.blockState, 3);
                this.m_146870_();
            }
        }
    }

    public boolean m_142535_(float f, float g, DamageSource damageSource) {
        DamageSource damageSource2;
        if (!this.hurtEntities) {
            return false;
        }
        int i = Mth.m_14167_((float)(f - 1.0f));
        if (i < 0) {
            return false;
        }
        Predicate predicate = EntitySelector.f_20406_.and(EntitySelector.f_20403_);
        Block block = this.blockState.m_60734_();
        if (block instanceof Floatable) {
            Floatable floatable = (Floatable)block;
            damageSource2 = floatable.getFallDamageSource(this);
        } else {
            damageSource2 = this.m_269291_().m_269564_((Entity)this);
        }
        DamageSource damageSource22 = damageSource2;
        float h = Math.min(Mth.m_14143_((float)((float)i * this.fallDamagePerDistance)), this.fallDamageMax);
        this.m_9236_().m_6249_((Entity)this, this.m_20191_(), predicate).forEach(entity -> entity.m_6469_(damageSource22, h));
        boolean bl = this.blockState.m_204336_(BlockTags.f_13033_);
        if (bl && h > 0.0f && this.f_19796_.m_188501_() < 0.05f + (float)i * 0.05f) {
            BlockState blockState = AnvilBlock.m_48824_((BlockState)this.blockState);
            if (blockState == null) {
                this.cancelDrop = true;
            } else {
                this.blockState = blockState;
            }
        }
        return false;
    }

    protected void m_7380_(CompoundTag compoundTag) {
        compoundTag.m_128365_("BlockState", (Tag)NbtUtils.m_129202_((BlockState)this.blockState));
        compoundTag.m_128405_("Time", this.time);
        compoundTag.m_128379_("DropItem", this.dropItem);
        compoundTag.m_128379_("HurtEntities", this.hurtEntities);
        compoundTag.m_128350_("FallHurtAmount", this.fallDamagePerDistance);
        compoundTag.m_128405_("FallHurtMax", this.fallDamageMax);
        if (this.blockData != null) {
            compoundTag.m_128365_("TileEntityData", (Tag)this.blockData);
        }
        compoundTag.m_128379_("CancelDrop", this.cancelDrop);
    }

    protected void m_7378_(CompoundTag compoundTag) {
        this.blockState = NbtUtils.m_247651_((HolderGetter)this.m_9236_().m_246945_(Registries.f_256747_), (CompoundTag)compoundTag.m_128469_("BlockState"));
        this.time = compoundTag.m_128451_("Time");
        if (compoundTag.m_128425_("HurtEntities", 99)) {
            this.hurtEntities = compoundTag.m_128471_("HurtEntities");
            this.fallDamagePerDistance = compoundTag.m_128457_("FallHurtAmount");
            this.fallDamageMax = compoundTag.m_128451_("FallHurtMax");
        } else if (this.blockState.m_204336_(BlockTags.f_13033_)) {
            this.hurtEntities = true;
        }
        if (compoundTag.m_128425_("DropItem", 99)) {
            this.dropItem = compoundTag.m_128471_("DropItem");
        }
        if (compoundTag.m_128425_("TileEntityData", 10)) {
            this.blockData = compoundTag.m_128469_("TileEntityData");
        }
        this.cancelDrop = compoundTag.m_128471_("CancelDrop");
        if (this.blockState.m_60795_()) {
            this.blockState = Blocks.f_49992_.m_49966_();
        }
    }

    public void setHurtsEntities(float f, int i) {
        this.hurtEntities = true;
        this.fallDamagePerDistance = f;
        this.fallDamageMax = i;
    }

    public void disableDrop() {
        this.cancelDrop = true;
    }

    public boolean m_6051_() {
        return false;
    }

    public void m_7976_(CrashReportCategory crashReportCategory) {
        super.m_7976_(crashReportCategory);
        crashReportCategory.m_128159_("Immitating BlockState", (Object)this.blockState.toString());
    }

    public BlockState getBlockState() {
        return this.blockState;
    }

    protected Component m_5677_() {
        return Component.m_237110_((String)"entity.minecraft.falling_block_type", (Object[])new Object[]{this.blockState.m_60734_().m_49954_()});
    }

    public boolean m_6127_() {
        return true;
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return new ClientboundAddEntityPacket((Entity)this, Block.m_49956_((BlockState)this.getBlockState()));
    }

    public void m_141965_(ClientboundAddEntityPacket clientboundAddEntityPacket) {
        super.m_141965_(clientboundAddEntityPacket);
        this.blockState = Block.m_49803_((int)clientboundAddEntityPacket.m_131509_());
        this.f_19850_ = true;
        double d = clientboundAddEntityPacket.m_131500_();
        double e = clientboundAddEntityPacket.m_131501_();
        double f = clientboundAddEntityPacket.m_131502_();
        this.m_6034_(d, e, f);
        this.setStartPos(this.m_20183_());
    }
}

