/*
 * Decompiled with CFR 0.152.
 */
package com.kekecreations.arts_and_crafts.common.block;

import com.kekecreations.arts_and_crafts.core.registry.ACBlocks;
import com.kekecreations.arts_and_crafts.core.registry.ACBuiltInLootTables;
import com.kekecreations.arts_and_crafts.core.registry.ACItems;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.WaterlilyBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.NotNull;

public class LotusFlowerBlock
extends WaterlilyBlock
implements BonemealableBlock {
    public static final IntegerProperty AGE = BlockStateProperties.f_61407_;
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;
    public static final BooleanProperty SHEARED = BooleanProperty.m_61465_((String)"sheared");

    public LotusFlowerBlock(BlockBehaviour.Properties $$0) {
        super($$0);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)this.getAgeProperty(), (Comparable)Integer.valueOf(0))).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)SHEARED, (Comparable)Boolean.valueOf(false)));
    }

    protected IntegerProperty getAgeProperty() {
        return AGE;
    }

    public int getMaxAge() {
        return 3;
    }

    public int getAge(BlockState p_52306_) {
        return (Integer)p_52306_.m_61143_((Property)this.getAgeProperty());
    }

    public BlockState getStateForAge(int $$0) {
        return (BlockState)this.m_49966_().m_61124_((Property)this.getAgeProperty(), (Comparable)Integer.valueOf($$0));
    }

    public final boolean isMaxAge(BlockState $$0) {
        return this.getAge($$0) >= this.getMaxAge();
    }

    protected static float getGrowthSpeed(ServerLevel level) {
        float growthSpeed = 0.5f;
        if (level.m_46468_() >= 13000L && level.m_46468_() <= 23000L) {
            growthSpeed = 1.0f;
        }
        return growthSpeed;
    }

    public void m_213898_(BlockState $$0, ServerLevel $$1, BlockPos $$2, RandomSource $$3) {
        float $$5;
        int $$4;
        if (!((Boolean)$$0.m_61143_((Property)SHEARED)).booleanValue() && ($$4 = this.getAge($$0)) < this.getMaxAge() && $$3.m_188503_((int)(25.0f / ($$5 = LotusFlowerBlock.getGrowthSpeed($$1))) + 1) == 0) {
            $$1.m_7731_($$2, (BlockState)this.getStateForAge($$4 + 1).m_61124_((Property)FACING, (Comparable)((Direction)$$0.m_61143_((Property)FACING))), 2);
        }
    }

    protected int getBonemealAgeIncrease(Level $$0) {
        return Mth.m_216271_((RandomSource)$$0.f_46441_, (int)0, (int)1);
    }

    public void growCrops(Level $$0, BlockPos $$1, BlockState $$2) {
        int $$4;
        int $$3 = this.getAge($$2) + this.getBonemealAgeIncrease($$0);
        if ($$3 > ($$4 = this.getMaxAge())) {
            $$3 = $$4;
        }
        $$0.m_7731_($$1, (BlockState)this.getStateForAge($$3).m_61124_((Property)FACING, (Comparable)((Direction)$$2.m_61143_((Property)FACING))), 2);
    }

    public boolean m_7370_(LevelReader levelReader, BlockPos blockPos, BlockState blockState, boolean b) {
        return (Boolean)blockState.m_61143_((Property)SHEARED) == false && !this.isMaxAge(blockState);
    }

    public boolean m_214167_(Level level, RandomSource randomSource, BlockPos blockPos, BlockState blockState) {
        return (Boolean)blockState.m_61143_((Property)SHEARED) == false && !this.isMaxAge(blockState);
    }

    public void m_214148_(ServerLevel serverLevel, RandomSource randomSource, BlockPos blockPos, BlockState blockState) {
        this.growCrops((Level)serverLevel, blockPos, blockState);
    }

    private void dropBleach(Level level, BlockPos pos) {
        ServerLevel serverLevel = (ServerLevel)level;
        LootTable lootTable = serverLevel.m_7654_().m_278653_().m_278676_(ACBuiltInLootTables.LOTUS_FLOWER_HARVEST);
        LootParams lootParams = new LootParams.Builder(serverLevel).m_287286_(LootContextParams.f_81460_, (Object)pos.m_252807_()).m_287286_(LootContextParams.f_81463_, (Object)ItemStack.f_41583_).m_287286_(LootContextParams.f_81461_, (Object)this.m_49966_()).m_287235_(LootContextParamSets.f_81421_);
        ObjectArrayList itemStackList = lootTable.m_287195_(lootParams);
        for (ItemStack itemStack : itemStackList) {
            LotusFlowerBlock.m_49840_((Level)level, (BlockPos)pos, (ItemStack)itemStack);
        }
        level.m_5594_(null, pos, SoundEvents.f_271330_, SoundSource.BLOCKS, 1.0f, 1.0f);
    }

    @NotNull
    public InteractionResult m_6227_(@NotNull BlockState blockState, Level level, @NotNull BlockPos blockPos, Player player, @NotNull InteractionHand interactionHand, @NotNull BlockHitResult blockHitResult) {
        ItemStack itemStack = player.m_21120_(interactionHand);
        if (!level.m_5776_() && !((Boolean)blockState.m_61143_((Property)SHEARED)).booleanValue()) {
            if (itemStack.m_150930_(Items.f_42574_)) {
                BlockState blockStateToPlace = ACBlocks.LOTUS_FLOWER.get().m_49966_();
                level.m_46597_(blockPos, (BlockState)((BlockState)((BlockState)blockStateToPlace.m_61124_((Property)SHEARED, (Comparable)Boolean.valueOf(true))).m_61124_((Property)BlockStateProperties.f_61407_, (Comparable)((Integer)blockState.m_61143_((Property)BlockStateProperties.f_61407_)))).m_61124_((Property)BlockStateProperties.f_61374_, (Comparable)((Direction)blockState.m_61143_((Property)BlockStateProperties.f_61374_))));
                if (!player.m_150110_().f_35937_) {
                    itemStack.m_41622_(1, (LivingEntity)player, entity -> entity.m_21190_(interactionHand));
                }
                return InteractionResult.SUCCESS;
            }
            if (this.isMaxAge(blockState)) {
                this.dropBleach(level, blockPos);
                BlockState blockStateToPlace = ACBlocks.LOTUS_FLOWER.get().m_49966_();
                level.m_46597_(blockPos, (BlockState)((BlockState)((BlockState)blockStateToPlace.m_61124_((Property)SHEARED, (Comparable)((Boolean)blockState.m_61143_((Property)SHEARED)))).m_61124_((Property)BlockStateProperties.f_61407_, (Comparable)Integer.valueOf(1))).m_61124_((Property)BlockStateProperties.f_61374_, (Comparable)((Direction)blockState.m_61143_((Property)BlockStateProperties.f_61374_))));
                return InteractionResult.SUCCESS;
            }
        }
        return InteractionResult.FAIL;
    }

    public ItemStack m_7397_(BlockGetter $$0, BlockPos $$1, BlockState $$2) {
        return ACItems.LOTUS_PISTILS.get().m_7968_();
    }

    public BlockState m_5573_(BlockPlaceContext blockPlaceContext) {
        return (BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)SHEARED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)AGE, (Comparable)Integer.valueOf(0))).m_61124_((Property)FACING, (Comparable)blockPlaceContext.m_8125_().m_122424_());
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> blockStateBuilder) {
        blockStateBuilder.m_61104_(new Property[]{AGE});
        blockStateBuilder.m_61104_(new Property[]{FACING});
        blockStateBuilder.m_61104_(new Property[]{SHEARED});
    }
}

