/*
 * Decompiled with CFR 0.152.
 */
package com.kekecreations.arts_and_crafts.common.block;

import com.kekecreations.arts_and_crafts.common.entity.DyedDecoratedPotBlockEntity;
import com.kekecreations.arts_and_crafts.core.platform.Services;
import com.kekecreations.arts_and_crafts.core.registry.ACBlocks;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DecoratedPotBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DyedDecoratedPotBlock
extends DecoratedPotBlock {
    private final DyeColor dyeColor;

    public DyedDecoratedPotBlock(DyeColor colour, BlockBehaviour.Properties properties) {
        super(properties);
        this.dyeColor = colour;
    }

    public boolean m_245993_(FeatureFlagSet $$0) {
        return Services.CONFIG.areDyedDecoratedPotsEnabled();
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos blockPos, BlockState blockState) {
        DyedDecoratedPotBlockEntity customDecoratedPotBlockEntity = new DyedDecoratedPotBlockEntity(blockPos, blockState);
        customDecoratedPotBlockEntity.setDyeColor(this.dyeColor.m_41060_());
        return customDecoratedPotBlockEntity;
    }

    @NotNull
    public List<ItemStack> m_49635_(@NotNull BlockState blockState, LootParams.Builder builder) {
        BlockEntity blockentity = (BlockEntity)builder.m_287159_(LootContextParams.f_81462_);
        if (blockentity instanceof DyedDecoratedPotBlockEntity) {
            DyedDecoratedPotBlockEntity dyedDecoratedPotBlockEntity = (DyedDecoratedPotBlockEntity)blockentity;
            builder.m_287145_(f_283767_, p_284876_ -> dyedDecoratedPotBlockEntity.getDecorations().m_284195_().map(Item::m_7968_).forEach(p_284876_));
        }
        return super.m_49635_(blockState, builder);
    }

    public static Block getBlockByColor(@Nullable DyeColor arg) {
        if (arg == null) {
            return Blocks.f_271197_;
        }
        return switch (arg) {
            default -> Blocks.f_271197_;
            case DyeColor.WHITE -> ACBlocks.getDyedDecoratedPot(DyeColor.WHITE.m_41060_());
            case DyeColor.ORANGE -> ACBlocks.getDyedDecoratedPot(DyeColor.ORANGE.m_41060_());
            case DyeColor.MAGENTA -> ACBlocks.getDyedDecoratedPot(DyeColor.MAGENTA.m_41060_());
            case DyeColor.LIGHT_BLUE -> ACBlocks.getDyedDecoratedPot(DyeColor.LIGHT_BLUE.m_41060_());
            case DyeColor.YELLOW -> ACBlocks.getDyedDecoratedPot(DyeColor.YELLOW.m_41060_());
            case DyeColor.LIME -> ACBlocks.getDyedDecoratedPot(DyeColor.LIME.m_41060_());
            case DyeColor.PINK -> ACBlocks.getDyedDecoratedPot(DyeColor.PINK.m_41060_());
            case DyeColor.GRAY -> ACBlocks.getDyedDecoratedPot(DyeColor.GRAY.m_41060_());
            case DyeColor.LIGHT_GRAY -> ACBlocks.getDyedDecoratedPot(DyeColor.LIGHT_GRAY.m_41060_());
            case DyeColor.CYAN -> ACBlocks.getDyedDecoratedPot(DyeColor.CYAN.m_41060_());
            case DyeColor.PURPLE -> ACBlocks.getDyedDecoratedPot(DyeColor.PURPLE.m_41060_());
            case DyeColor.BLUE -> ACBlocks.getDyedDecoratedPot(DyeColor.BLUE.m_41060_());
            case DyeColor.BROWN -> ACBlocks.getDyedDecoratedPot(DyeColor.BROWN.m_41060_());
            case DyeColor.GREEN -> ACBlocks.getDyedDecoratedPot(DyeColor.GREEN.m_41060_());
            case DyeColor.RED -> ACBlocks.getDyedDecoratedPot(DyeColor.RED.m_41060_());
            case DyeColor.BLACK -> ACBlocks.getDyedDecoratedPot(DyeColor.BLACK.m_41060_());
        };
    }

    public static ItemStack getColoredItemStack(@Nullable DyeColor arg) {
        return new ItemStack((ItemLike)DyedDecoratedPotBlock.getBlockByColor(arg));
    }
}

