/*
 * Decompiled with CFR 0.152.
 */
package com.kekecreations.arts_and_crafts.common.block;

import com.kekecreations.arts_and_crafts.common.item.ChalkStickItem;
import com.kekecreations.arts_and_crafts.common.misc.KekeBlockStateProperties;
import com.kekecreations.arts_and_crafts.core.platform.Services;
import com.kekecreations.arts_and_crafts.core.registry.ACItems;
import java.util.Arrays;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DirectionalBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;

public class ChalkDustBlock
extends DirectionalBlock {
    private static final VoxelShape UP_AABB = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)1.0, (double)16.0);
    private static final VoxelShape DOWN_AABB = Block.m_49796_((double)0.0, (double)15.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    private static final VoxelShape WEST_AABB = Block.m_49796_((double)15.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    private static final VoxelShape EAST_AABB = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)16.0, (double)16.0);
    private static final VoxelShape NORTH_AABB = Block.m_49796_((double)0.0, (double)0.0, (double)15.0, (double)16.0, (double)16.0, (double)16.0);
    private static final VoxelShape SOUTH_AABB = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)1.0);
    public static final BooleanProperty GLOW;
    private final Integer dyeColor;
    public static final int MAX_STATE = 32;
    public static final IntegerProperty CHALK_DUST_STATES;

    public int getDyeColor() {
        return this.dyeColor;
    }

    public ChalkDustBlock(Integer dyeColor, BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)this.getChalkDustProperty(), (Comparable)Integer.valueOf(0))).m_61124_((Property)f_52588_, (Comparable)Direction.SOUTH)).m_61124_((Property)GLOW, (Comparable)Boolean.valueOf(false)));
        this.dyeColor = dyeColor;
    }

    public boolean m_245993_(FeatureFlagSet $$0) {
        return Services.CONFIG.areChalkSticksEnabled();
    }

    protected IntegerProperty getChalkDustProperty() {
        return CHALK_DUST_STATES;
    }

    public int getMaxState() {
        return 32;
    }

    public InteractionResult m_6227_(BlockState blockState, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult blockHitResult) {
        ItemStack itemStack = player.m_21120_(hand);
        if (!level.m_5776_() && !((Boolean)blockState.m_61143_((Property)GLOW)).booleanValue() && itemStack.m_150930_(Items.f_151056_)) {
            level.m_46597_(pos, (BlockState)blockState.m_61124_((Property)GLOW, (Comparable)Boolean.valueOf(true)));
            level.m_5594_(null, pos, SoundEvents.f_144153_, SoundSource.BLOCKS, 1.0f, 1.0f);
            if (!player.m_7500_()) {
                itemStack.m_41764_(itemStack.m_41613_() - 1);
            }
            return InteractionResult.m_19078_((boolean)true);
        }
        return InteractionResult.FAIL;
    }

    public int getChalkDustStates(BlockState blockState) {
        return (Integer)blockState.m_61143_((Property)this.getChalkDustProperty());
    }

    public final boolean isMaxState(BlockState blockState) {
        return this.getChalkDustStates(blockState) >= this.getMaxState();
    }

    public ItemStack m_7397_(BlockGetter blockGetter, BlockPos blockPos, BlockState blockState) {
        Item item;
        ItemStack itemStack = new ItemStack((ItemLike)ACItems.getChalkStick(this.dyeColor));
        if (!Services.PLATFORM.isModLoaded("diet") && (item = itemStack.m_41720_()) instanceof ChalkStickItem) {
            ChalkStickItem chalkStickItem = (ChalkStickItem)item;
            if (Screen.m_96637_()) {
                chalkStickItem.setChalkPattern(itemStack, this.getChalkDustStates(blockState));
            }
        }
        return itemStack;
    }

    protected void m_7926_(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{CHALK_DUST_STATES});
        builder.m_61104_(new Property[]{f_52588_});
        builder.m_61104_(new Property[]{GLOW});
    }

    public VoxelShape m_5939_(@NotNull BlockState state, @NotNull BlockGetter world, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        return Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0);
    }

    public VoxelShape m_5940_(@NotNull BlockState state, @NotNull BlockGetter world, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        return this.getShape(state);
    }

    public static boolean canAttachTo(BlockGetter p_153830_, Direction p_153831_, BlockPos p_153832_, BlockState p_153833_) {
        return Block.m_49918_((VoxelShape)p_153833_.m_60816_(p_153830_, p_153832_), (Direction)p_153831_.m_122424_()) || Block.m_49918_((VoxelShape)p_153833_.m_60812_(p_153830_, p_153832_), (Direction)p_153831_.m_122424_());
    }

    public boolean m_7898_(BlockState state, @NotNull LevelReader level, BlockPos pos) {
        Direction direction = (Direction)state.m_61143_((Property)f_52588_);
        BlockPos blockpos = pos.m_121945_(direction);
        return ChalkDustBlock.canAttachTo((BlockGetter)level, direction, blockpos, level.m_8055_(blockpos));
    }

    public boolean isValidStateForPlacement(BlockGetter p_221572_, BlockState p_221573_, BlockPos p_221574_, Direction p_221575_) {
        if (!p_221573_.m_60713_((Block)this)) {
            BlockPos blockpos = p_221574_.m_121945_(p_221575_);
            return ChalkDustBlock.canAttachTo(p_221572_, p_221575_, blockpos, p_221572_.m_8055_(blockpos));
        }
        return false;
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext blockPlaceContext) {
        Level level = blockPlaceContext.m_43725_();
        BlockPos blockpos = blockPlaceContext.m_8083_();
        BlockState blockstate = level.m_8055_(blockpos);
        return Arrays.stream(blockPlaceContext.m_6232_()).map(p_153865_ -> this.getStateForPlacement(blockstate, (BlockGetter)level, blockpos, (Direction)p_153865_)).filter(Objects::nonNull).findFirst().orElse(null);
    }

    public BlockState getStateForPlacement(BlockState blockState, BlockGetter level, BlockPos blockPos, Direction direction) {
        if (!this.isValidStateForPlacement(level, blockState, blockPos, direction) || blockState.m_60713_((Block)this)) {
            return null;
        }
        return (BlockState)this.m_49966_().m_61124_((Property)f_52588_, (Comparable)direction.m_122424_());
    }

    public boolean m_6864_(BlockState p_153848_, BlockPlaceContext p_153849_) {
        return true;
    }

    public VoxelShape getShape(BlockState state) {
        Direction direction = (Direction)state.m_61143_((Property)f_52588_);
        return switch (direction) {
            default -> throw new IncompatibleClassChangeError();
            case Direction.NORTH -> NORTH_AABB;
            case Direction.SOUTH -> SOUTH_AABB;
            case Direction.EAST -> EAST_AABB;
            case Direction.WEST -> WEST_AABB;
            case Direction.DOWN -> DOWN_AABB;
            case Direction.UP -> UP_AABB;
        };
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState neighborState, LevelAccessor world, BlockPos pos, BlockPos neighborPos) {
        return direction == ((Direction)state.m_61143_((Property)f_52588_)).m_122424_() && !state.m_60710_((LevelReader)world, pos) ? Blocks.f_50016_.m_49966_() : super.m_7417_(state, direction, neighborState, world, pos, neighborPos);
    }

    static {
        CHALK_DUST_STATES = KekeBlockStateProperties.CHALK_PATTERN;
        GLOW = BooleanProperty.m_61465_((String)"glow");
    }
}

