/*
 * Decompiled with CFR 0.152.
 */
package hunternif.mc.impl.atlas.network.packet.c2s.play;

import dev.architectury.networking.NetworkManager;
import hunternif.mc.api.AtlasAPI;
import hunternif.mc.impl.atlas.AntiqueAtlasMod;
import hunternif.mc.impl.atlas.network.packet.c2s.C2SPacket;
import hunternif.mc.impl.atlas.util.Log;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;

public class PutBrowsingPositionC2SPacket
extends C2SPacket {
    public static final ResourceLocation ID = AntiqueAtlasMod.id("packet", "c2s", "browsing_position", "put");

    public PutBrowsingPositionC2SPacket(int atlasID, ResourceKey<Level> world, int x, int y, double zoom) {
        this.m_130130_(atlasID);
        this.m_130085_(world.m_135782_());
        this.m_130130_(x);
        this.m_130130_(y);
        this.writeDouble(zoom);
    }

    @Override
    public ResourceLocation getId() {
        return ID;
    }

    public static void apply(FriendlyByteBuf buf, NetworkManager.PacketContext context) {
        int atlasID = buf.m_130242_();
        ResourceKey world = ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)buf.m_130281_());
        int x = buf.m_130242_();
        int y = buf.m_130242_();
        double zoom = buf.readDouble();
        context.queue(() -> {
            if (AntiqueAtlasMod.CONFIG.itemNeeded && !AtlasAPI.getPlayerAtlases(context.getPlayer()).contains(atlasID)) {
                Log.warn("Player %s attempted to put position marker into someone else's Atlas #%d", context.getPlayer().m_20203_().m_81368_(), atlasID);
                return;
            }
            AntiqueAtlasMod.tileData.getData(atlasID, context.getPlayer().m_20193_()).getWorldData((ResourceKey<Level>)world).setBrowsingPosition(x, y, zoom);
        });
    }
}

