/*
 * Decompiled with CFR 0.152.
 */
package hunternif.mc.impl.atlas.item;

import hunternif.mc.impl.atlas.AntiqueAtlasMod;
import hunternif.mc.impl.atlas.core.AtlasData;
import hunternif.mc.impl.atlas.item.AntiqueAtlasItems;
import hunternif.mc.impl.atlas.item.AtlasItem;
import hunternif.mc.impl.atlas.marker.Marker;
import hunternif.mc.impl.atlas.marker.MarkersData;
import java.util.ArrayList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SimpleCraftingRecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class RecipeAtlasCombining
implements CraftingRecipe {
    public static final RecipeSerializer<RecipeAtlasCombining> SERIALIZER = new SimpleCraftingRecipeSerializer(RecipeAtlasCombining::new);
    private final ResourceLocation id;
    private final CraftingBookCategory category;

    public RecipeAtlasCombining(ResourceLocation id, CraftingBookCategory category) {
        this.id = id;
        this.category = category;
    }

    public String m_6076_() {
        return "antiqueatlas:atlas_combine";
    }

    public boolean matches(CraftingContainer inv, Level world) {
        return this.matches(inv);
    }

    private boolean matches(CraftingContainer inv) {
        int atlasesFound = 0;
        for (int i = 0; i < inv.m_6643_(); ++i) {
            ItemStack stack = inv.m_8020_(i);
            if (stack.m_41619_() || stack.m_41720_() != AntiqueAtlasItems.ATLAS.get()) continue;
            ++atlasesFound;
        }
        return atlasesFound > 1;
    }

    public ItemStack craft(CraftingContainer inv, RegistryAccess registryManager) {
        ItemStack firstAtlas = ItemStack.f_41583_;
        ArrayList<Integer> atlasIds = new ArrayList<Integer>(9);
        for (int i = 0; i < inv.m_6643_(); ++i) {
            ItemStack stack = inv.m_8020_(i);
            if (stack.m_41619_() || !(stack.m_41720_() instanceof AtlasItem)) continue;
            if (firstAtlas.m_41619_()) {
                firstAtlas = stack;
                continue;
            }
            atlasIds.add(AtlasItem.getAtlasID(stack));
        }
        return atlasIds.size() < 1 ? ItemStack.f_41583_ : firstAtlas.m_41777_();
    }

    public boolean m_8004_(int width, int height) {
        return true;
    }

    public ItemStack m_8043_(RegistryAccess registryManager) {
        return new ItemStack((ItemLike)AntiqueAtlasItems.ATLAS.get());
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public RecipeSerializer<?> m_7707_() {
        return SERIALIZER;
    }

    public RecipeType<?> m_6671_() {
        return RecipeType.f_44107_;
    }

    public CraftingBookCategory m_245232_() {
        return this.category;
    }

    public ItemStack onCrafted(Level world, Container inventory, ItemStack result) {
        if (world.f_46443_) {
            return result;
        }
        int atlasID = AntiqueAtlasMod.getAtlasIdData(world).getNextAtlasId();
        AtlasData destBiomes = AntiqueAtlasMod.tileData.getData(atlasID, world);
        destBiomes.m_77762_();
        MarkersData destMarkers = AntiqueAtlasMod.markersData.getMarkersData(atlasID, world);
        destMarkers.m_77762_();
        for (int i = 0; i < inventory.m_6643_(); ++i) {
            ItemStack stack = inventory.m_8020_(i);
            if (stack.m_41619_()) continue;
            AtlasData srcBiomes = AntiqueAtlasMod.tileData.getData(stack, world);
            if (destBiomes != null && srcBiomes != null && destBiomes != srcBiomes) {
                for (ResourceKey<Level> worldRegistryKey : srcBiomes.getVisitedWorlds()) {
                    destBiomes.getWorldData(worldRegistryKey).addData(srcBiomes.getWorldData(worldRegistryKey));
                }
            }
            MarkersData srcMarkers = AntiqueAtlasMod.markersData.getMarkersData(stack, world);
            if (destMarkers == null || srcMarkers == null || destMarkers == srcMarkers) continue;
            for (ResourceKey<Level> worldRegistryKey : srcMarkers.getVisitedDimensions()) {
                for (Marker marker : srcMarkers.getMarkersDataInWorld(worldRegistryKey).getAllMarkers()) {
                    destMarkers.createAndSaveMarker(marker.getType(), worldRegistryKey, marker.getX(), marker.getZ(), marker.isVisibleAhead(), marker.getLabel());
                }
            }
        }
        result.m_41784_().m_128405_("atlasID", atlasID);
        return result;
    }
}

