/*
 * Decompiled with CFR 0.152.
 */
package hunternif.mc.impl.atlas.client.gui;

import com.google.common.collect.ImmutableMap;
import hunternif.mc.impl.atlas.client.Textures;
import hunternif.mc.impl.atlas.client.gui.core.GuiComponent;
import hunternif.mc.impl.atlas.client.texture.ITexture;
import java.util.Collections;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;

public class GuiScaleBar
extends GuiComponent {
    private static final int WIDTH = 20;
    private static final int HEIGHT = 8;
    private static final Map<Double, ITexture> textureMap;
    private double mapScale = 1.0;

    GuiScaleBar() {
        this.setSize(20, 8);
    }

    void setMapScale(double scale) {
        this.mapScale = scale;
    }

    private ITexture getTexture() {
        return textureMap.get(this.mapScale);
    }

    @Override
    public void m_88315_(GuiGraphics context, int mouseX, int mouseY, float partialTick) {
        ITexture texture = this.getTexture();
        if (texture == null) {
            return;
        }
        texture.draw(context, this.getGuiX(), this.getGuiY());
        if (this.isMouseOver) {
            this.drawTooltip(Collections.singletonList(Component.m_237115_((String)"gui.antiqueatlas.scalebar")), Minecraft.m_91087_().f_91062_);
        }
    }

    static {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        builder.put((Object)0.0625, (Object)Textures.SCALEBAR_512);
        builder.put((Object)0.125, (Object)Textures.SCALEBAR_256);
        builder.put((Object)0.25, (Object)Textures.SCALEBAR_128);
        builder.put((Object)0.5, (Object)Textures.SCALEBAR_64);
        builder.put((Object)1.0, (Object)Textures.SCALEBAR_32);
        builder.put((Object)2.0, (Object)Textures.SCALEBAR_16);
        builder.put((Object)4.0, (Object)Textures.SCALEBAR_8);
        builder.put((Object)8.0, (Object)Textures.SCALEBAR_4);
        textureMap = builder.build();
    }
}

