/*
 * Decompiled with CFR 0.152.
 */
package com.starfish_studios.another_furniture.block;

import com.starfish_studios.another_furniture.block.SeatBlock;
import com.starfish_studios.another_furniture.block.properties.ModBlockStateProperties;
import com.starfish_studios.another_furniture.block.properties.SofaType;
import com.starfish_studios.another_furniture.util.block.ShapeUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class SofaBlock
extends SeatBlock
implements SimpleWaterloggedBlock {
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    public static final EnumProperty<SofaType> TYPE = ModBlockStateProperties.SOFA_TYPE;
    public static final VoxelShape SEAT_BASE = Block.m_49796_((double)0.0, (double)3.0, (double)0.0, (double)16.0, (double)7.0, (double)16.0);
    public static final VoxelShape SEAT_BACK_SINGLE = Block.m_49796_((double)2.0, (double)7.0, (double)12.0, (double)14.0, (double)16.0, (double)16.0);
    public static final VoxelShape SEAT_BACK_MIDDLE = Block.m_49796_((double)0.0, (double)7.0, (double)12.0, (double)16.0, (double)16.0, (double)16.0);
    public static final VoxelShape SEAT_BACK_LEFT = Block.m_49796_((double)0.0, (double)7.0, (double)12.0, (double)14.0, (double)16.0, (double)16.0);
    public static final VoxelShape SEAT_BACK_RIGHT = Block.m_49796_((double)2.0, (double)7.0, (double)12.0, (double)16.0, (double)16.0, (double)16.0);
    public static final VoxelShape LEG_BL = Block.m_49796_((double)14.0, (double)0.0, (double)14.0, (double)16.0, (double)3.0, (double)16.0);
    public static final VoxelShape LEG_BR = Block.m_49796_((double)0.0, (double)0.0, (double)14.0, (double)2.0, (double)3.0, (double)16.0);
    public static final VoxelShape LEG_FR = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)2.0, (double)3.0, (double)2.0);
    public static final VoxelShape LEG_FL = Block.m_49796_((double)14.0, (double)0.0, (double)0.0, (double)16.0, (double)3.0, (double)2.0);
    public static final VoxelShape ARM_L = Block.m_49796_((double)14.0, (double)7.0, (double)0.0, (double)16.0, (double)12.0, (double)16.0);
    public static final VoxelShape ARM_R = Block.m_49796_((double)0.0, (double)7.0, (double)0.0, (double)2.0, (double)12.0, (double)16.0);
    public static final VoxelShape SINGLE = Shapes.m_83124_((VoxelShape)SEAT_BASE, (VoxelShape[])new VoxelShape[]{SEAT_BACK_SINGLE, ARM_L, ARM_R, LEG_BL, LEG_BR, LEG_FL, LEG_FR});
    public static final VoxelShape SINGLE_EAST = ShapeUtil.rotateShape(SINGLE, Direction.EAST);
    public static final VoxelShape SINGLE_SOUTH = ShapeUtil.rotateShape(SINGLE, Direction.SOUTH);
    public static final VoxelShape SINGLE_WEST = ShapeUtil.rotateShape(SINGLE, Direction.WEST);
    public static final VoxelShape MIDDLE = Shapes.m_83110_((VoxelShape)SEAT_BASE, (VoxelShape)SEAT_BACK_MIDDLE);
    public static final VoxelShape MIDDLE_EAST = ShapeUtil.rotateShape(MIDDLE, Direction.EAST);
    public static final VoxelShape MIDDLE_SOUTH = ShapeUtil.rotateShape(MIDDLE, Direction.SOUTH);
    public static final VoxelShape MIDDLE_WEST = ShapeUtil.rotateShape(MIDDLE, Direction.WEST);
    public static final VoxelShape OUTER = Shapes.m_83124_((VoxelShape)SEAT_BASE, (VoxelShape[])new VoxelShape[]{LEG_BL, LEG_FR, Block.m_49796_((double)12.0, (double)6.0, (double)12.0, (double)16.0, (double)16.0, (double)16.0)});
    public static final VoxelShape OUTER_EAST = ShapeUtil.rotateShape(OUTER, Direction.EAST);
    public static final VoxelShape OUTER_SOUTH = ShapeUtil.rotateShape(OUTER, Direction.SOUTH);
    public static final VoxelShape OUTER_WEST = ShapeUtil.rotateShape(OUTER, Direction.WEST);
    public static final VoxelShape INNER = Shapes.m_83124_((VoxelShape)SEAT_BASE, (VoxelShape[])new VoxelShape[]{SEAT_BACK_MIDDLE, LEG_BL, LEG_FR, Block.m_49796_((double)12.0, (double)7.0, (double)0.0, (double)16.0, (double)16.0, (double)12.0)});
    public static final VoxelShape INNER_EAST = ShapeUtil.rotateShape(INNER, Direction.EAST);
    public static final VoxelShape INNER_SOUTH = ShapeUtil.rotateShape(INNER, Direction.SOUTH);
    public static final VoxelShape INNER_WEST = ShapeUtil.rotateShape(INNER, Direction.WEST);
    public static final VoxelShape RIGHT = Shapes.m_83124_((VoxelShape)SEAT_BASE, (VoxelShape[])new VoxelShape[]{SEAT_BACK_RIGHT, ARM_R, LEG_BR, LEG_FR});
    public static final VoxelShape RIGHT_EAST = ShapeUtil.rotateShape(RIGHT, Direction.EAST);
    public static final VoxelShape RIGHT_SOUTH = ShapeUtil.rotateShape(RIGHT, Direction.SOUTH);
    public static final VoxelShape RIGHT_WEST = ShapeUtil.rotateShape(RIGHT, Direction.WEST);
    public static final VoxelShape LEFT = Shapes.m_83124_((VoxelShape)SEAT_BASE, (VoxelShape[])new VoxelShape[]{SEAT_BACK_LEFT, ARM_L, LEG_BL, LEG_FL});
    public static final VoxelShape LEFT_EAST = ShapeUtil.rotateShape(LEFT, Direction.EAST);
    public static final VoxelShape LEFT_SOUTH = ShapeUtil.rotateShape(LEFT, Direction.SOUTH);
    public static final VoxelShape LEFT_WEST = ShapeUtil.rotateShape(LEFT, Direction.WEST);

    public SofaBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    public float seatHeight(BlockState state) {
        return 0.15f;
    }

    @Override
    public BlockPos primaryDismountLocation(Level level, BlockState state, BlockPos pos) {
        Direction facingRelative;
        Direction facing = (Direction)state.m_61143_((Property)FACING);
        BlockState stateRelative = level.m_8055_(pos.m_121945_(facing));
        if (stateRelative.m_60734_() instanceof SofaBlock && facing != (facingRelative = (Direction)stateRelative.m_61143_((Property)FACING))) {
            return pos.m_121945_(facing).m_121945_(facingRelative);
        }
        return pos.m_121945_(facing);
    }

    @Override
    public float setRiderRotation(BlockState state, Entity entity) {
        float corner = switch ((SofaType)((Object)state.m_61143_(TYPE))) {
            case SofaType.INNER_LEFT, SofaType.OUTER_LEFT -> -45.0f;
            case SofaType.INNER_RIGHT, SofaType.OUTER_RIGHT -> 45.0f;
            default -> 0.0f;
        };
        return ((Direction)state.m_61143_((Property)FACING)).m_122435_() + corner;
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        BlockPos blockPos = context.m_8083_();
        FluidState fluidState = context.m_43725_().m_6425_(blockPos);
        BlockState blockState = (BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)context.m_8125_().m_122424_())).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidState.m_76152_() == Fluids.f_76193_));
        return (BlockState)blockState.m_61124_(TYPE, (Comparable)((Object)SofaBlock.getConnection(blockState, context.m_43725_(), blockPos)));
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos currentPos, BlockPos neighborPos) {
        if (((Boolean)state.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            level.m_186469_(currentPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)level));
        }
        return direction.m_122434_().m_122479_() ? (BlockState)state.m_61124_(TYPE, (Comparable)((Object)SofaBlock.getConnection(state, (Level)level, currentPos))) : super.m_7417_(state, direction, neighborState, level, currentPos, neighborPos);
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        Direction facing = (Direction)state.m_61143_((Property)FACING);
        SofaType shape = (SofaType)((Object)state.m_61143_(TYPE));
        return switch (shape) {
            default -> throw new IncompatibleClassChangeError();
            case SofaType.SINGLE -> {
                switch (facing) {
                    case EAST: {
                        yield SINGLE_EAST;
                    }
                    case SOUTH: {
                        yield SINGLE_SOUTH;
                    }
                    case WEST: {
                        yield SINGLE_WEST;
                    }
                }
                yield SINGLE;
            }
            case SofaType.MIDDLE -> {
                switch (facing) {
                    case EAST: {
                        yield MIDDLE_EAST;
                    }
                    case SOUTH: {
                        yield MIDDLE_SOUTH;
                    }
                    case WEST: {
                        yield MIDDLE_WEST;
                    }
                }
                yield MIDDLE;
            }
            case SofaType.OUTER_LEFT -> {
                switch (facing) {
                    case EAST: {
                        yield OUTER_EAST;
                    }
                    case SOUTH: {
                        yield OUTER_SOUTH;
                    }
                    case WEST: {
                        yield OUTER_WEST;
                    }
                }
                yield OUTER;
            }
            case SofaType.OUTER_RIGHT -> {
                switch (facing) {
                    case EAST: {
                        yield OUTER_SOUTH;
                    }
                    case SOUTH: {
                        yield OUTER_WEST;
                    }
                    case WEST: {
                        yield OUTER;
                    }
                }
                yield OUTER_EAST;
            }
            case SofaType.LEFT -> {
                switch (facing) {
                    case EAST: {
                        yield LEFT_EAST;
                    }
                    case SOUTH: {
                        yield LEFT_SOUTH;
                    }
                    case WEST: {
                        yield LEFT_WEST;
                    }
                }
                yield LEFT;
            }
            case SofaType.RIGHT -> {
                switch (facing) {
                    case EAST: {
                        yield RIGHT_EAST;
                    }
                    case SOUTH: {
                        yield RIGHT_SOUTH;
                    }
                    case WEST: {
                        yield RIGHT_WEST;
                    }
                }
                yield RIGHT;
            }
            case SofaType.INNER_RIGHT -> {
                switch (facing) {
                    case EAST: {
                        yield INNER_SOUTH;
                    }
                    case SOUTH: {
                        yield INNER_WEST;
                    }
                    case WEST: {
                        yield INNER;
                    }
                }
                yield INNER_EAST;
            }
            case SofaType.INNER_LEFT -> {
                switch (facing) {
                    case EAST: {
                        yield INNER_EAST;
                    }
                    case SOUTH: {
                        yield INNER_SOUTH;
                    }
                    case WEST: {
                        yield INNER_WEST;
                    }
                }
                yield INNER;
            }
        };
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING, TYPE, WATERLOGGED});
    }

    public static SofaType getConnection(BlockState state, Level level, BlockPos pos) {
        Direction dir2;
        Direction dir1;
        Direction facing = (Direction)state.m_61143_((Property)FACING);
        BlockState state1 = level.m_8055_(pos.m_121945_(facing));
        if (state1.m_60734_() instanceof SofaBlock && (dir1 = (Direction)state1.m_61143_((Property)FACING)).m_122434_() != ((Direction)state.m_61143_((Property)FACING)).m_122434_() && SofaBlock.isDifferentOrientation(state, level, pos, dir1.m_122424_())) {
            if (dir1 == facing.m_122428_()) {
                return SofaType.INNER_LEFT;
            }
            return SofaType.INNER_RIGHT;
        }
        BlockState state2 = level.m_8055_(pos.m_121945_(facing.m_122424_()));
        if (state2.m_60734_() instanceof SofaBlock && (dir2 = (Direction)state2.m_61143_((Property)FACING)).m_122434_() != ((Direction)state.m_61143_((Property)FACING)).m_122434_() && SofaBlock.isDifferentOrientation(state, level, pos, dir2)) {
            if (dir2 == facing.m_122428_()) {
                return SofaType.OUTER_LEFT;
            }
            return SofaType.OUTER_RIGHT;
        }
        boolean left = SofaBlock.canConnect(level, pos, ((Direction)state.m_61143_((Property)FACING)).m_122428_());
        boolean right = SofaBlock.canConnect(level, pos, ((Direction)state.m_61143_((Property)FACING)).m_122427_());
        if (left && right) {
            return SofaType.MIDDLE;
        }
        if (left) {
            return SofaType.LEFT;
        }
        if (right) {
            return SofaType.RIGHT;
        }
        return SofaType.SINGLE;
    }

    public static boolean canConnect(Level level, BlockPos pos, Direction direction) {
        BlockState state = level.m_8055_(pos.m_121945_(direction));
        return state.m_60734_() instanceof SofaBlock;
    }

    public static boolean isDifferentOrientation(BlockState state, Level level, BlockPos pos, Direction dir) {
        BlockState blockState = level.m_8055_(pos.m_121945_(dir));
        return !(blockState.m_60734_() instanceof SofaBlock) || blockState.m_61143_((Property)FACING) != state.m_61143_((Property)FACING);
    }

    @Override
    public boolean m_7357_(BlockState state, BlockGetter level, BlockPos pos, PathComputationType type) {
        return false;
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    public BlockState m_6843_(BlockState state, Rotation rotation) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rotation.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        return state.m_60717_(mirror.m_54846_((Direction)state.m_61143_((Property)FACING)));
    }
}

