/*
 * Decompiled with CFR 0.152.
 */
package dev.isxander.yacl3.gui.controllers;

import dev.isxander.yacl3.api.Controller;
import dev.isxander.yacl3.api.Option;
import dev.isxander.yacl3.api.utils.Dimension;
import dev.isxander.yacl3.gui.AbstractWidget;
import dev.isxander.yacl3.gui.YACLScreen;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ComponentPath;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.MultiLineLabel;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.narration.NarratedElementType;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.navigation.FocusNavigationEvent;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.Style;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public class LabelController
implements Controller<Component> {
    private final Option<Component> option;

    public LabelController(Option<Component> option) {
        this.option = option;
    }

    @Override
    public Option<Component> option() {
        return this.option;
    }

    @Override
    public Component formatValue() {
        return this.option().pendingValue();
    }

    @Override
    public AbstractWidget provideWidget(YACLScreen screen, Dimension<Integer> widgetDimension) {
        return new LabelControllerElement(screen, widgetDimension);
    }

    public class LabelControllerElement
    extends AbstractWidget {
        private List<FormattedCharSequence> wrappedText;
        protected MultiLineLabel wrappedTooltip;
        protected boolean focused;
        protected final YACLScreen screen;

        public LabelControllerElement(YACLScreen screen, Dimension<Integer> dim) {
            super(dim);
            this.screen = screen;
            LabelController.this.option().addListener((opt, pending) -> this.updateTooltip());
            this.updateTooltip();
            this.updateText();
        }

        public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float delta) {
            Style style;
            this.updateText();
            int y = this.getDimension().y();
            for (FormattedCharSequence text : this.wrappedText) {
                graphics.m_280649_(this.textRenderer, text, this.getDimension().x() + this.getXPadding(), y + this.getYPadding(), LabelController.this.option().available() ? -1 : -6250336, true);
                Objects.requireNonNull(this.textRenderer);
                y += 9;
            }
            if (this.m_93696_()) {
                graphics.m_280509_(this.getDimension().x() - 1, this.getDimension().y() - 1, this.getDimension().xLimit() + 1, this.getDimension().y().intValue(), -1);
                graphics.m_280509_(this.getDimension().x() - 1, this.getDimension().y() - 1, this.getDimension().x().intValue(), this.getDimension().yLimit() + 1, -1);
                graphics.m_280509_(this.getDimension().x() - 1, this.getDimension().yLimit().intValue(), this.getDimension().xLimit() + 1, this.getDimension().yLimit() + 1, -1);
                graphics.m_280509_(this.getDimension().xLimit().intValue(), this.getDimension().y() - 1, this.getDimension().xLimit() + 1, this.getDimension().yLimit() + 1, -1);
            }
            graphics.m_280168_().m_85836_();
            graphics.m_280168_().m_252880_(0.0f, 0.0f, 100.0f);
            if (this.m_5953_(mouseX, mouseY) && (style = this.getStyle(mouseX, mouseY)) != null && style.m_131186_() != null) {
                HoverEvent hoverEvent = style.m_131186_();
                HoverEvent.ItemStackInfo itemStackContent = (HoverEvent.ItemStackInfo)hoverEvent.m_130823_(HoverEvent.Action.f_130832_);
                if (itemStackContent != null) {
                    ItemStack stack = itemStackContent.m_130898_();
                    graphics.m_280677_(this.textRenderer, Screen.m_280152_((Minecraft)this.client, (ItemStack)stack), stack.m_150921_(), mouseX, mouseY);
                } else {
                    HoverEvent.EntityTooltipInfo entityContent = (HoverEvent.EntityTooltipInfo)hoverEvent.m_130823_(HoverEvent.Action.f_130833_);
                    if (entityContent != null) {
                        if (this.client.f_91066_.f_92125_) {
                            graphics.m_280666_(this.textRenderer, entityContent.m_130884_(), mouseX, mouseY);
                        }
                    } else {
                        Component text = (Component)hoverEvent.m_130823_(HoverEvent.Action.f_130831_);
                        if (text != null) {
                            MultiLineLabel multilineText = MultiLineLabel.m_94341_((Font)this.textRenderer, (FormattedText)text, (int)this.getDimension().width());
                            YACLScreen.renderMultilineTooltip(graphics, this.textRenderer, multilineText, this.getDimension().centerX(), this.getDimension().y(), this.getDimension().yLimit(), this.screen.f_96543_, this.screen.f_96544_);
                        }
                    }
                }
            }
            graphics.m_280168_().m_85849_();
        }

        public boolean m_6375_(double mouseX, double mouseY, int button) {
            if (!this.m_5953_(mouseX, mouseY)) {
                return false;
            }
            Style style = this.getStyle((int)mouseX, (int)mouseY);
            return this.screen.m_5561_(style);
        }

        protected Style getStyle(int mouseX, int mouseY) {
            if (!this.getDimension().isPointInside(mouseX, mouseY)) {
                return null;
            }
            int x = mouseX - this.getDimension().x();
            int y = mouseY - this.getDimension().y() - this.getYPadding();
            Objects.requireNonNull(this.textRenderer);
            int line = y / 9;
            if (x < 0 || x > this.getDimension().xLimit()) {
                return null;
            }
            if (y < 0 || y > this.getDimension().yLimit()) {
                return null;
            }
            if (line < 0 || line >= this.wrappedText.size()) {
                return null;
            }
            return this.textRenderer.m_92865_().m_92338_(this.wrappedText.get(line), x);
        }

        private int getXPadding() {
            return 4;
        }

        private int getYPadding() {
            return 3;
        }

        private void updateText() {
            this.wrappedText = this.textRenderer.m_92923_((FormattedText)LabelController.this.formatValue(), this.getDimension().width() - this.getXPadding() * 2);
            Dimension<Integer> dimension = this.getDimension();
            int n = this.wrappedText.size();
            Objects.requireNonNull(this.textRenderer);
            this.setDimension(dimension.withHeight(n * 9 + this.getYPadding() * 2));
        }

        private void updateTooltip() {
            this.wrappedTooltip = MultiLineLabel.m_94341_((Font)this.textRenderer, (FormattedText)LabelController.this.option().tooltip(), (int)(this.screen.f_96543_ / 3 * 2 - 10));
        }

        @Override
        public boolean matchesSearch(String query) {
            return LabelController.this.formatValue().getString().toLowerCase().contains(query.toLowerCase());
        }

        @Nullable
        public ComponentPath m_264064_(FocusNavigationEvent focusNavigationEvent) {
            if (!LabelController.this.option().available()) {
                return null;
            }
            return !this.m_93696_() ? ComponentPath.m_264401_((GuiEventListener)this) : null;
        }

        public boolean m_93696_() {
            return this.focused;
        }

        public void m_93692_(boolean focused) {
            this.focused = focused;
        }

        @Override
        public void m_142291_(NarrationElementOutput builder) {
            builder.m_169146_(NarratedElementType.TITLE, LabelController.this.formatValue());
        }

        @Override
        public NarratableEntry.NarrationPriority m_142684_() {
            return NarratableEntry.NarrationPriority.FOCUSED;
        }
    }
}

