/*
 * Decompiled with CFR 0.152.
 */
package hal.studios.hpm.network;

import hal.studios.hpm.HpmMod;
import hal.studios.hpm.procedures.SailspeedupOnKeyPressedProcedure;
import hal.studios.hpm.procedures.SailspeedupOnKeyReleasedProcedure;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.network.NetworkEvent;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class SailspeedupMessage {
    int type;
    int pressedms;

    public SailspeedupMessage(int type, int pressedms) {
        this.type = type;
        this.pressedms = pressedms;
    }

    public SailspeedupMessage(FriendlyByteBuf buffer) {
        this.type = buffer.readInt();
        this.pressedms = buffer.readInt();
    }

    public static void buffer(SailspeedupMessage message, FriendlyByteBuf buffer) {
        buffer.writeInt(message.type);
        buffer.writeInt(message.pressedms);
    }

    public static void handler(SailspeedupMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> SailspeedupMessage.pressAction((Player)context.getSender(), message.type, message.pressedms));
        context.setPacketHandled(true);
    }

    public static void pressAction(Player entity, int type, int pressedms) {
        Level world = entity.m_9236_();
        double x = entity.m_20185_();
        double y = entity.m_20186_();
        double z = entity.m_20189_();
        if (!world.m_46805_(entity.m_20183_())) {
            return;
        }
        if (type == 0) {
            SailspeedupOnKeyPressedProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (type == 1) {
            SailspeedupOnKeyReleasedProcedure.execute((Entity)entity);
        }
    }

    @SubscribeEvent
    public static void registerMessage(FMLCommonSetupEvent event) {
        HpmMod.addNetworkMessage(SailspeedupMessage.class, SailspeedupMessage::buffer, SailspeedupMessage::new, SailspeedupMessage::handler);
    }
}

