/*
 * Decompiled with CFR 0.152.
 */
package com.github.exopandora.shouldersurfing.client;

import com.github.exopandora.shouldersurfing.api.client.ICameraEntityRenderer;
import com.github.exopandora.shouldersurfing.client.ShoulderSurfingCamera;
import com.github.exopandora.shouldersurfing.client.ShoulderSurfingImpl;
import com.github.exopandora.shouldersurfing.config.Config;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;

public class CameraEntityRenderer
implements ICameraEntityRenderer {
    private final ShoulderSurfingImpl instance;
    private float cameraEntityAlpha = 1.0f;

    public CameraEntityRenderer(ShoulderSurfingImpl instance) {
        this.instance = instance;
    }

    public boolean preRenderCameraEntity(Entity entity, float partialTick) {
        if (this.shouldSkipCameraEntityRendering(entity)) {
            return true;
        }
        if (this.shouldRenderCameraEntityTransparent(entity)) {
            Vec3 renderOffset = this.instance.getCamera().getRenderOffset();
            float xAlpha = (float)Mth.m_14008_((double)(Math.abs(renderOffset.m_7096_()) / ((double)entity.m_20205_() / 2.0)), (double)0.0, (double)1.0);
            float yAlpha = 0.0f;
            if (renderOffset.m_7098_() > 0.0) {
                yAlpha = (float)Mth.m_14008_((double)(renderOffset.m_7098_() / (double)(entity.m_20206_() - entity.m_20192_())), (double)0.0, (double)1.0);
            } else if (renderOffset.m_7098_() < 0.0) {
                yAlpha = (float)Mth.m_14008_((double)(-renderOffset.m_7098_() / (double)(-entity.m_20192_())), (double)0.0, (double)1.0);
            }
            this.cameraEntityAlpha = Mth.m_14036_((float)((float)Math.sqrt(xAlpha * xAlpha + yAlpha * yAlpha)), (float)0.15f, (float)1.0f);
        }
        return false;
    }

    public void postRenderCameraEntity(Entity entity, float partialTick) {
        this.cameraEntityAlpha = 1.0f;
    }

    private boolean shouldSkipCameraEntityRendering(Entity cameraEntity) {
        Player player;
        ShoulderSurfingCamera camera = this.instance.getCamera();
        return this.instance.isShoulderSurfing() && !cameraEntity.m_5833_() && (camera.getCameraDistance() < (double)cameraEntity.m_20205_() * Config.CLIENT.keepCameraOutOfHeadMultiplier() || (double)camera.getXRot() < Config.CLIENT.getHidePlayerWhenLookingUpAngle() - 90.0 || cameraEntity instanceof Player && (player = (Player)cameraEntity).m_150108_());
    }

    private boolean shouldRenderCameraEntityTransparent(Entity entity) {
        Vec3 renderOffset = this.instance.getCamera().getRenderOffset();
        return this.instance.isShoulderSurfing() && Config.CLIENT.isPlayerTransparencyEnabled() && !entity.m_5833_() && Math.abs(renderOffset.m_7096_()) < (double)entity.m_20205_() / 2.0 && (renderOffset.m_7098_() >= 0.0 && renderOffset.m_7098_() < (double)(entity.m_20206_() - entity.m_20192_()) || renderOffset.m_7098_() <= 0.0 && -renderOffset.m_7098_() < (double)entity.m_20192_());
    }

    @Override
    public float getCameraEntityAlpha() {
        return this.cameraEntityAlpha;
    }
}

