/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.quark.content.tools.client.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.util.List;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BeaconRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.level.block.entity.BeaconBlockEntity;
import org.joml.Matrix3f;
import org.joml.Matrix4f;
import org.violetmoon.quark.content.tools.module.BeaconRedirectionModule;

public class QuarkBeaconBlockEntityRenderer {
    public static boolean render(BeaconBlockEntity tileEntityIn, float partialTicks, PoseStack matrixStackIn, MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn) {
        if (!BeaconRedirectionModule.staticEnabled) {
            return false;
        }
        long i = tileEntityIn.m_58904_().m_46467_();
        List list = tileEntityIn.m_58702_();
        for (BeaconBlockEntity.BeaconBeamSection segment : list) {
            if (!(segment instanceof BeaconRedirectionModule.ExtendedBeamSegment)) {
                return false;
            }
            BeaconRedirectionModule.ExtendedBeamSegment extension = (BeaconRedirectionModule.ExtendedBeamSegment)segment;
            QuarkBeaconBlockEntityRenderer.renderBeamSegment(matrixStackIn, bufferIn, extension, partialTicks, i);
        }
        return true;
    }

    private static void renderBeamSegment(PoseStack matrixStackIn, MultiBufferSource bufferIn, BeaconRedirectionModule.ExtendedBeamSegment segment, float partialTicks, long totalWorldTime) {
        QuarkBeaconBlockEntityRenderer.renderBeamSegment(matrixStackIn, bufferIn, BeaconRenderer.f_112102_, segment, partialTicks, 1.0f, totalWorldTime, 0.2f, 0.25f);
    }

    public static void renderBeamSegment(PoseStack matrixStackIn, MultiBufferSource bufferIn, ResourceLocation textureLocation, BeaconRedirectionModule.ExtendedBeamSegment segment, float partialTicks, float textureScale, long totalWorldTime, float beamRadius, float glowRadius) {
        int height = segment.m_58723_();
        float[] colors = segment.m_58722_();
        float alpha = segment.alpha;
        matrixStackIn.m_85836_();
        matrixStackIn.m_85837_(0.5, 0.5, 0.5);
        matrixStackIn.m_252880_((float)segment.offset.m_123341_(), (float)segment.offset.m_123342_(), (float)segment.offset.m_123343_());
        matrixStackIn.m_252781_(segment.dir.m_253075_());
        float angle = (float)Math.floorMod(totalWorldTime, 40L) + partialTicks;
        float r = colors[0];
        float g = colors[1];
        float b = colors[2];
        matrixStackIn.m_85836_();
        matrixStackIn.m_252781_(Axis.f_252436_.m_252977_(angle * 2.25f - 45.0f));
        float renderTime = -((float)totalWorldTime + partialTicks);
        float partAngle = Mth.m_14187_((float)(renderTime * 0.2f - (float)Mth.m_14143_((float)(angle * 0.1f))));
        float v2 = -1.0f + partAngle;
        float v1 = (float)height * textureScale * (0.5f / beamRadius) + v2;
        QuarkBeaconBlockEntityRenderer.renderPart(matrixStackIn, bufferIn.m_6299_(RenderType.m_110460_((ResourceLocation)textureLocation, (alpha < 1.0f ? 1 : 0) != 0)), r, g, b, alpha, height, 0.0f, beamRadius, beamRadius, 0.0f, -beamRadius, 0.0f, 0.0f, -beamRadius, 0.0f, 1.0f, v1, v2);
        matrixStackIn.m_85849_();
        v1 = (float)height * textureScale + v2;
        QuarkBeaconBlockEntityRenderer.renderPart(matrixStackIn, bufferIn.m_6299_(RenderType.m_110460_((ResourceLocation)textureLocation, (boolean)true)), r, g, b, alpha * 0.125f, height, -glowRadius, -glowRadius, glowRadius, -glowRadius, -glowRadius, glowRadius, glowRadius, glowRadius, 0.0f, 1.0f, v1, v2);
        matrixStackIn.m_85849_();
    }

    private static void renderPart(PoseStack matrixStackIn, VertexConsumer bufferIn, float red, float green, float blue, float alpha, int height, float x1, float y1, float x2, float y2, float x3, float y3, float x4, float y4, float u1, float u2, float v1, float v2) {
        PoseStack.Pose pose = matrixStackIn.m_85850_();
        Matrix4f matrix4f = pose.m_252922_();
        Matrix3f matrix3f = pose.m_252943_();
        QuarkBeaconBlockEntityRenderer.addQuad(matrix4f, matrix3f, bufferIn, red, green, blue, alpha, 0, height, x1, y1, x2, y2, u1, u2, v1, v2);
        QuarkBeaconBlockEntityRenderer.addQuad(matrix4f, matrix3f, bufferIn, red, green, blue, alpha, 0, height, x4, y4, x3, y3, u1, u2, v1, v2);
        QuarkBeaconBlockEntityRenderer.addQuad(matrix4f, matrix3f, bufferIn, red, green, blue, alpha, 0, height, x2, y2, x4, y4, u1, u2, v1, v2);
        QuarkBeaconBlockEntityRenderer.addQuad(matrix4f, matrix3f, bufferIn, red, green, blue, alpha, 0, height, x3, y3, x1, y1, u1, u2, v1, v2);
    }

    private static void addQuad(Matrix4f matrixPos, Matrix3f matrixNormal, VertexConsumer bufferIn, float red, float green, float blue, float alpha, int yMin, int yMax, float x1, float z1, float x2, float z2, float u1, float u2, float v1, float v2) {
        QuarkBeaconBlockEntityRenderer.addVertex(matrixPos, matrixNormal, bufferIn, red, green, blue, alpha, yMax, x1, z1, u2, v1);
        QuarkBeaconBlockEntityRenderer.addVertex(matrixPos, matrixNormal, bufferIn, red, green, blue, alpha, yMin, x1, z1, u2, v2);
        QuarkBeaconBlockEntityRenderer.addVertex(matrixPos, matrixNormal, bufferIn, red, green, blue, alpha, yMin, x2, z2, u1, v2);
        QuarkBeaconBlockEntityRenderer.addVertex(matrixPos, matrixNormal, bufferIn, red, green, blue, alpha, yMax, x2, z2, u1, v1);
    }

    private static void addVertex(Matrix4f matrixPos, Matrix3f matrixNormal, VertexConsumer bufferIn, float red, float green, float blue, float alpha, int y, float x, float z, float texU, float texV) {
        bufferIn.m_252986_(matrixPos, x, (float)y, z).m_85950_(red, green, blue, alpha).m_7421_(texU, texV).m_86008_(OverlayTexture.f_118083_).m_85969_(0xF000F0).m_252939_(matrixNormal, 0.0f, 1.0f, 0.0f).m_5752_();
    }
}

