/*
 * Decompiled with CFR 0.152.
 */
package eu.ha3.presencefootsteps.sound.player;

import eu.ha3.presencefootsteps.PresenceFootsteps;
import eu.ha3.presencefootsteps.sound.Options;
import eu.ha3.presencefootsteps.sound.player.SoundPlayer;
import eu.ha3.presencefootsteps.util.MathUtil;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.class_1309;

public class DelayedSoundPlayer
implements SoundPlayer {
    private static final boolean USING_LATENESS = true;
    private static final boolean USING_EARLYNESS = true;
    private static final float LATENESS_THRESHOLD = 1.5f;
    private static final double EARLYNESS_THRESHOLD_POW = 0.75;
    private final List<PendingSound> pending = new ObjectArrayList();
    private final SoundPlayer immediate;
    private long nextPlayTime;
    private long currentTime;

    public DelayedSoundPlayer(SoundPlayer immediate) {
        this.immediate = immediate;
    }

    @Override
    public Random getRNG() {
        return this.immediate.getRNG();
    }

    @Override
    public void playSound(class_1309 location, String soundName, float volume, float pitch, Options options) {
        if (!options.containsKey("delay_min") || !options.containsKey("delay_max")) {
            this.immediate.playSound(location, soundName, volume, pitch, options);
            return;
        }
        this.pending.add(new PendingSound(location, soundName, volume, pitch, options));
    }

    @Override
    public void think() {
        this.currentTime = System.currentTimeMillis();
        if (this.pending.isEmpty() || this.currentTime < this.nextPlayTime) {
            return;
        }
        this.nextPlayTime = Long.MAX_VALUE;
        this.pending.removeIf(PendingSound::tick);
    }

    private class PendingSound {
        private final class_1309 location;
        private final String soundName;
        private final Options options;
        private final float volume;
        private final float pitch;
        private final long timeToPlay;
        private final long maximum;

        public PendingSound(class_1309 location, String soundName, float volume, float pitch, Options options) {
            this.location = location;
            this.soundName = soundName;
            this.volume = volume;
            this.pitch = pitch;
            this.options = options;
            this.maximum = options.containsKey("skippable") ? -1L : (long)options.get("delay_max");
            this.timeToPlay = System.currentTimeMillis() + Math.max(MathUtil.randAB(DelayedSoundPlayer.this.getRNG(), (long)options.get("delay_min"), (long)options.get("delay_max")), DelayedSoundPlayer.this.nextPlayTime);
        }

        public boolean tick() {
            switch (this.nextState(DelayedSoundPlayer.this.currentTime)) {
                case PLAYING: {
                    DelayedSoundPlayer.this.immediate.playSound(this.location, this.soundName, this.volume, this.pitch, this.options);
                    return false;
                }
                case SKIPPING: {
                    return true;
                }
            }
            DelayedSoundPlayer.this.nextPlayTime = this.timeToPlay;
            return false;
        }

        private State nextState(long time) {
            if (time >= this.timeToPlay || (double)time >= (double)this.timeToPlay - Math.pow(this.maximum, 0.75)) {
                if (time < this.timeToPlay) {
                    PresenceFootsteps.logger.debug("Playing early sound (early by " + (this.timeToPlay - time) + "ms, tolerence is " + Math.pow(this.maximum, 0.75));
                }
                long lateness = time - this.timeToPlay;
                if (this.maximum < 0L || (float)lateness <= (float)this.maximum / 1.5f) {
                    return State.PLAYING;
                }
                PresenceFootsteps.logger.debug("Skipped late sound (late by " + lateness + "ms, tolerence is " + (float)this.maximum / 1.5f + "ms)");
                return State.SKIPPING;
            }
            return State.PENDING;
        }
    }

    static enum State {
        PENDING,
        PLAYING,
        SKIPPING;

    }
}

