/*
 * Decompiled with CFR 0.152.
 */
package galena.oreganized.data.provider;

import com.teamabnormals.blueprint.core.data.client.BlueprintItemModelProvider;
import java.util.function.Supplier;
import net.minecraft.client.renderer.block.model.BlockModel;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.WallBlock;
import net.minecraftforge.client.model.generators.ItemModelBuilder;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.registries.ForgeRegistries;

public abstract class OItemModelProvider
extends BlueprintItemModelProvider {
    public OItemModelProvider(PackOutput output, ExistingFileHelper help) {
        super(output, "oreganized", help);
    }

    protected String blockName(Supplier<? extends Block> block) {
        return ForgeRegistries.BLOCKS.getKey((Object)block.get()).m_135815_();
    }

    private ResourceLocation texture(String name) {
        return this.modLoc("block/" + name);
    }

    public ItemModelBuilder block(Supplier<? extends Block> block) {
        return this.block(block, this.blockName(block));
    }

    public ItemModelBuilder block(Supplier<? extends Block> block, String name) {
        return (ItemModelBuilder)this.withExistingParent(this.blockName(block), this.modLoc("block/" + name));
    }

    public ItemModelBuilder blockFlat(Supplier<? extends Block> block) {
        return this.blockFlat(block, this.blockName(block));
    }

    public ItemModelBuilder blockFlat(Supplier<? extends Block> block, Supplier<? extends Block> fullBlock) {
        return this.blockFlat(block, this.blockName(fullBlock));
    }

    public ItemModelBuilder blockFlat(Supplier<? extends Block> block, String name) {
        return (ItemModelBuilder)((ItemModelBuilder)this.withExistingParent(this.blockName(block), this.mcLoc("item/generated"))).texture("layer0", this.modLoc("block/" + name));
    }

    public ItemModelBuilder blockFlatWithItemName(Supplier<? extends Block> block, String name) {
        return (ItemModelBuilder)((ItemModelBuilder)this.withExistingParent(this.blockName(block), this.mcLoc("item/generated"))).texture("layer0", this.modLoc("item/" + name));
    }

    public ItemModelBuilder normalItem(Supplier<? extends Item> item) {
        return (ItemModelBuilder)((ItemModelBuilder)this.withExistingParent(ForgeRegistries.ITEMS.getKey((Object)item.get()).m_135815_(), this.mcLoc("item/generated"))).texture("layer0", this.modLoc("item/" + ForgeRegistries.ITEMS.getKey((Object)item.get()).m_135815_()));
    }

    public ItemModelBuilder toolItem(Supplier<? extends Item> item) {
        return (ItemModelBuilder)((ItemModelBuilder)this.withExistingParent(ForgeRegistries.ITEMS.getKey((Object)item.get()).m_135815_(), this.mcLoc("item/handheld"))).texture("layer0", this.modLoc("item/" + ForgeRegistries.ITEMS.getKey((Object)item.get()).m_135815_()));
    }

    public ItemModelBuilder shieldItem(Supplier<? extends Item> item) {
        ResourceLocation texture = this.modLoc("item/" + ForgeRegistries.ITEMS.getKey((Object)item.get()).m_135815_());
        String name = ForgeRegistries.ITEMS.getKey((Object)item.get()).m_135815_();
        ItemModelBuilder blockingModel = (ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.withExistingParent(name + "_blocking", new ResourceLocation("shieldexp", "item/netherite_shield_blocking"))).guiLight(BlockModel.GuiLight.FRONT)).texture("1", texture)).texture("particle", texture);
        return ((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.withExistingParent(name, new ResourceLocation("shieldexp", "item/netherite_shield"))).guiLight(BlockModel.GuiLight.FRONT)).texture("1", texture)).texture("particle", texture)).override().predicate(new ResourceLocation("blocking"), 1.0f).model((ModelFile)blockingModel).end();
    }

    public ItemModelBuilder crossbowOverwrite(String name) {
        return (ItemModelBuilder)((ItemModelBuilder)this.withExistingParent(name, "item/crossbow")).texture("layer0", this.modLoc("item/" + name));
    }

    public ItemModelBuilder wall(Supplier<? extends WallBlock> wall, Supplier<? extends Block> fullBlock) {
        return (ItemModelBuilder)this.wallInventory(ForgeRegistries.BLOCKS.getKey((Object)((Block)wall.get())).m_135815_(), this.texture(this.blockName(fullBlock)));
    }

    public ItemModelBuilder twoLayered(String name, ResourceLocation texture, ResourceLocation overlayTexture) {
        this.existingFileHelper.trackGenerated(overlayTexture, (ExistingFileHelper.IResourceType)TEXTURE);
        return (ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.withExistingParent(name, "item/generated")).texture("layer0", texture)).texture("layer1", overlayTexture);
    }
}

