/*
 * Decompiled with CFR 0.152.
 */
package galena.oreganized.data.provider;

import galena.oreganized.Oreganized;
import galena.oreganized.compat.ColorCompat;
import galena.oreganized.content.block.BulbBlock;
import galena.oreganized.content.block.CrystalGlassBlock;
import galena.oreganized.content.block.CrystalGlassPaneBlock;
import galena.oreganized.content.block.GargoyleBlock;
import galena.oreganized.content.block.IMeltableBlock;
import galena.oreganized.content.block.LeadDoorBlock;
import galena.oreganized.content.block.MoltenLeadCauldronBlock;
import java.util.Arrays;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.core.Direction;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CrossCollisionBlock;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.IronBarsBlock;
import net.minecraft.world.level.block.PipeBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.WallBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DoorHingeSide;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.BlockStateProvider;
import net.minecraftforge.client.model.generators.ConfiguredModel;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.client.model.generators.MultiPartBlockStateBuilder;
import net.minecraftforge.client.model.generators.VariantBlockStateBuilder;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.registries.ForgeRegistries;

public abstract class OBlockStateProvider
extends BlockStateProvider {
    public OBlockStateProvider(PackOutput output, ExistingFileHelper help) {
        super(output, "oreganized", help);
    }

    protected ResourceLocation texture(String name) {
        return this.modLoc("block/" + name);
    }

    protected String name(Block block) {
        return ForgeRegistries.BLOCKS.getKey((Object)block).m_135815_();
    }

    protected String name(Supplier<? extends Block> block) {
        return this.name(block.get());
    }

    private String suffixByIndex(int index) {
        switch (index) {
            case 1: {
                return "_rot";
            }
            case 2: {
                return "_in";
            }
            case 3: {
                return "_out";
            }
        }
        return "";
    }

    public void simpleBlock(Supplier<? extends Block> block) {
        this.simpleBlock(block.get());
    }

    public void stairsBlock(Supplier<? extends StairBlock> block, Supplier<? extends Block> fullBlock) {
        this.stairsBlock(block.get(), this.texture(this.name(fullBlock)));
    }

    public void slabBlock(Supplier<? extends SlabBlock> block, Supplier<? extends Block> fullBlock) {
        this.slabBlock(block.get(), this.texture(this.name(fullBlock)), this.texture(this.name(fullBlock)));
    }

    public void wallBlock(Supplier<? extends WallBlock> wall, Supplier<? extends Block> fullBlock) {
        this.wallBlock(wall.get(), this.texture(this.name(fullBlock)));
    }

    public void waxedBlock(Supplier<? extends Block> block, Block origin) {
        this.simpleBlock(block.get(), this.cubeAll(origin));
    }

    public ModelFile cubeBottomTop(Supplier<? extends Block> block) {
        BlockModelBuilder model = (BlockModelBuilder)this.models().getBuilder(this.name(block));
        model.parent((ModelFile)this.models().getExistingFile(new ResourceLocation("minecraft", "block/cube_bottom_top")));
        model.texture("top", this.texture(this.name(block) + "_top"));
        model.texture("bottom", this.texture(this.name(block) + "_bottom"));
        model.texture("side", this.texture(this.name(block) + "_side"));
        return model;
    }

    public ModelFile directionalBlockModel(Supplier<? extends Block> block, String name, String side, String front, String back, String top) {
        return ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(name, "block/observer")).texture("bottom", this.texture(back))).texture("side", this.texture(side))).texture("top", this.texture(top))).texture("front", this.texture(front))).texture("particle", this.texture(front));
    }

    public ModelFile cauldronModel(Supplier<? extends Block> block, ResourceLocation texture, int age) {
        String name = this.name(block) + age;
        return ((BlockModelBuilder)this.models().withExistingParent(name, "block/template_cauldron_full")).texture("content", texture);
    }

    public ModelFile cauldronModel(Supplier<? extends Block> cauldron, Supplier<? extends Block> content, int age) {
        return this.cauldronModel(cauldron, this.texture(this.name(content)), age);
    }

    public void moltenCauldron(Supplier<? extends Block> cauldron, Supplier<? extends Block> content) {
        this.getVariantBuilder(cauldron.get()).forAllStates(state -> {
            int age = (Integer)state.m_61143_((Property)MoltenLeadCauldronBlock.AGE);
            if (age == 0) {
                return ConfiguredModel.builder().modelFile(this.cauldronModel(cauldron, content, age)).build();
            }
            ResourceLocation texture = age == 3 ? this.texture("molten_" + this.name(content)) : this.texture(this.name(content) + "2");
            return ConfiguredModel.builder().modelFile(this.cauldronModel(cauldron, texture, age)).build();
        });
    }

    public void crystalGlassBlock(Supplier<? extends Block> block) {
        ((VariantBlockStateBuilder)((VariantBlockStateBuilder)((VariantBlockStateBuilder)this.getVariantBuilder(block.get()).partialState().with((Property)CrystalGlassBlock.TYPE, (Comparable)Integer.valueOf(0)).modelForState().modelFile(this.cubeAll(block.get())).addModel()).partialState().with((Property)CrystalGlassBlock.TYPE, (Comparable)Integer.valueOf(1)).modelForState().modelFile((ModelFile)this.models().cubeAll(this.name(block) + "_rot", Oreganized.modLoc("block/" + this.name(block) + "_rot"))).addModel()).partialState().with((Property)CrystalGlassBlock.TYPE, (Comparable)Integer.valueOf(2)).modelForState().modelFile((ModelFile)this.models().cubeAll(this.name(block) + "_in", Oreganized.modLoc("block/" + this.name(block) + "_in"))).addModel()).partialState().with((Property)CrystalGlassBlock.TYPE, (Comparable)Integer.valueOf(3)).modelForState().modelFile((ModelFile)this.models().cubeAll(this.name(block) + "_out", Oreganized.modLoc("block/" + this.name(block) + "_out"))).addModel();
    }

    public void crystalGlassPaneBlock(DyeColor color, Supplier<? extends Block> pane, Supplier<? extends Block> fullBlock) {
        String baseName = this.name(fullBlock);
        String paneName = this.name(pane);
        MultiPartBlockStateBuilder builder = this.getMultipartBuilder(pane.get());
        int i = 0;
        while (i < 4) {
            int finalI = i++;
            PipeBlock.f_55154_.entrySet().forEach(e -> {
                Direction dir = (Direction)e.getKey();
                if (dir.m_122434_().m_122479_()) {
                    boolean alt = dir == Direction.SOUTH;
                    ResourceLocation topTexture = new ResourceLocation(ColorCompat.getNamespace(color), "block/" + color.m_7912_() + "_stained_glass_pane_top");
                    ((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)this.models().panePost(paneName + "_post" + this.suffixByIndex(finalI), Oreganized.modLoc("block/" + baseName + this.suffixByIndex(finalI)), topTexture)).addModel()).condition((Property)CrystalGlassPaneBlock.TYPE, (Comparable[])new Integer[]{finalI}).end().part().modelFile((ModelFile)(alt || dir == Direction.WEST ? this.models().paneSideAlt(paneName + "_side_alt" + this.suffixByIndex(finalI), Oreganized.modLoc("block/" + baseName + this.suffixByIndex(finalI)), topTexture) : this.models().paneSide(paneName + "_side" + this.suffixByIndex(finalI), Oreganized.modLoc("block/" + baseName + this.suffixByIndex(finalI)), topTexture))).rotationY(dir.m_122434_() == Direction.Axis.X ? 90 : 0).addModel()).condition((Property)e.getValue(), (Comparable[])new Boolean[]{true}).condition((Property)CrystalGlassPaneBlock.TYPE, (Comparable[])new Integer[]{finalI}).end().part().modelFile((ModelFile)(alt || dir == Direction.EAST ? this.models().paneNoSideAlt(paneName + "_noside_alt" + this.suffixByIndex(finalI), Oreganized.modLoc("block/" + baseName + this.suffixByIndex(finalI))) : this.models().paneNoSide(paneName + "_noside" + this.suffixByIndex(finalI), Oreganized.modLoc("block/" + baseName + this.suffixByIndex(finalI))))).rotationY(dir == Direction.WEST ? 270 : (dir == Direction.SOUTH ? 90 : 0)).addModel()).condition((Property)e.getValue(), (Comparable[])new Boolean[]{false}).condition((Property)CrystalGlassPaneBlock.TYPE, (Comparable[])new Integer[]{finalI});
                }
            });
        }
    }

    public ModelFile engravedFace(Block block, Boolean engraved) {
        BlockModelBuilder model = (BlockModelBuilder)this.models().getBuilder(this.name(block));
        ResourceLocation textureLoc = engraved != false ? this.texture("engraved/" + this.name(block)) : this.texture(this.name(block));
        model.parent((ModelFile)this.models().getExistingFile(new ResourceLocation("minecraft", "block/template_single_face")));
        model.texture("texture", textureLoc);
        return model;
    }

    public <T extends Block> void meltableBlock(Supplier<T> block, BiFunction<String, ResourceLocation, ModelFile> modelBuilder) {
        this.meltableBlock(block, modelBuilder, (s, it) -> it);
    }

    public <T extends Block> void meltableBlock(Supplier<T> block, BiFunction<String, ResourceLocation, ModelFile> modelBuilder, BiFunction<BlockState, ConfiguredModel.Builder<?>, ConfiguredModel.Builder<?>> modelModifier) {
        List<String> prefixes = List.of("", "goopy_", "red_hot_");
        BlockModelBuilder redHotModel = (BlockModelBuilder)this.models().cubeAll("red_hot_lead", this.modLoc("block/red_hot_lead"));
        this.getVariantBuilder((Block)block.get()).forAllStates(state -> {
            int goopyness = ((IMeltableBlock)((Block)block.get())).getGoopyness((BlockState)state);
            String name = (String)prefixes.get(goopyness) + this.name(block);
            ResourceLocation texture = this.texture(name);
            boolean isRedHot = goopyness == 2;
            ConfiguredModel.Builder model = ConfiguredModel.builder().modelFile((ModelFile)(isRedHot ? redHotModel : (ModelFile)modelBuilder.apply(name, texture)));
            if (isRedHot) {
                return model.build();
            }
            return ((ConfiguredModel.Builder)modelModifier.apply((BlockState)state, (ConfiguredModel.Builder<?>)model)).build();
        });
    }

    public <T extends Block> void bulb(Supplier<T> block) {
        List<String> prefixes = List.of("", "dimmer_", "goopy_", "red_hot_");
        BlockModelBuilder redHotModel = (BlockModelBuilder)this.models().cubeAll("red_hot_lead", this.modLoc("block/red_hot_lead"));
        this.getVariantBuilder((Block)block.get()).forAllStates(state -> {
            int goopyness = (Integer)state.m_61143_((Property)BulbBlock.GOOPYNESS_4);
            String name = (String)prefixes.get(goopyness) + this.name(block);
            ResourceLocation texture = this.texture(name);
            BlockModelBuilder model = goopyness < 3 ? (BlockModelBuilder)this.models().cubeAll(name, texture) : redHotModel;
            return ConfiguredModel.builder().modelFile((ModelFile)model).build();
        });
    }

    public <T extends RotatedPillarBlock> void meltablePillar(Supplier<T> block) {
        this.meltableBlock(block, (n, t) -> this.models().cubeColumn(n, t.m_266382_("_side"), t.m_266382_("_top")), (s, it) -> switch ((Direction.Axis)s.m_61143_((Property)RotatedPillarBlock.f_55923_)) {
            default -> throw new IncompatibleClassChangeError();
            case Direction.Axis.X -> it.rotationX(90).rotationY(90);
            case Direction.Axis.Y -> it;
            case Direction.Axis.Z -> it.rotationX(90);
        });
    }

    public <T extends TrapDoorBlock> void meltableTrapdoor(Supplier<T> block) {
        String baseName = this.name(block);
        List<String> prefixes = List.of("", "goopy_", "red_hot_");
        this.getVariantBuilder((Block)block.get()).forAllStatesExcept(state -> {
            int goopyness = ((IMeltableBlock)((TrapDoorBlock)block.get())).getGoopyness((BlockState)state);
            String name = (String)prefixes.get(goopyness) + baseName;
            ResourceLocation texture = this.texture((String)(goopyness < 2 ? name : "red_hot_lead"));
            BlockModelBuilder bottom = (BlockModelBuilder)this.models().trapdoorOrientableBottom(name + "_bottom", texture);
            BlockModelBuilder top = (BlockModelBuilder)this.models().trapdoorOrientableTop(name + "_top", texture);
            BlockModelBuilder open = (BlockModelBuilder)this.models().trapdoorOrientableOpen(name + "_open", texture);
            int xRot = 0;
            int yRot = (int)((Direction)state.m_61143_((Property)TrapDoorBlock.f_54117_)).m_122435_() + 180;
            boolean isOpen = (Boolean)state.m_61143_((Property)TrapDoorBlock.f_57514_);
            if (isOpen && state.m_61143_((Property)TrapDoorBlock.f_57515_) == Half.TOP) {
                xRot += 180;
                yRot += 180;
            }
            return ConfiguredModel.builder().modelFile((ModelFile)(isOpen ? open : (state.m_61143_((Property)TrapDoorBlock.f_57515_) == Half.TOP ? top : bottom))).rotationX(xRot).rotationY(yRot %= 360).build();
        }, new Property[]{TrapDoorBlock.f_57516_, TrapDoorBlock.f_57517_});
    }

    public <T extends DoorBlock> void meltableDoor(Supplier<T> block) {
        String baseName = this.name(block);
        List<String> prefixes = List.of("", "goopy_", "red_hot_");
        this.getVariantBuilder((Block)block.get()).forAllStatesExcept(state -> {
            boolean animated = state.m_61138_((Property)LeadDoorBlock.ANIMATED) && (Boolean)state.m_61143_((Property)LeadDoorBlock.ANIMATED) != false;
            boolean right = state.m_61143_((Property)DoorBlock.f_52728_) == DoorHingeSide.RIGHT;
            boolean open = (Boolean)state.m_61143_((Property)DoorBlock.f_52727_);
            boolean lower = state.m_61143_((Property)DoorBlock.f_52730_) == DoubleBlockHalf.LOWER;
            int goopyness = ((IMeltableBlock)((DoorBlock)block.get())).getGoopyness((BlockState)state);
            String name = (String)prefixes.get(goopyness) + baseName;
            String textureSuffix = open ? (animated ? "_closing" : "_open") : (animated ? "_opening" : "");
            ResourceLocation bottom = this.texture((String)(goopyness < 2 ? name + "_bottom" + textureSuffix : "red_hot_lead"));
            ResourceLocation top = this.texture((String)(goopyness < 2 ? name + "_top" + textureSuffix : "red_hot_lead"));
            BlockModelBuilder bottomLeft = (BlockModelBuilder)this.models().doorBottomLeft(name + "_bottom_left" + textureSuffix, bottom, top);
            BlockModelBuilder bottomRight = (BlockModelBuilder)this.models().doorBottomRight(name + "_bottom_right" + textureSuffix, bottom, top);
            BlockModelBuilder topLeft = (BlockModelBuilder)this.models().doorTopLeft(name + "_top_left" + textureSuffix, bottom, top);
            BlockModelBuilder topRight = (BlockModelBuilder)this.models().doorTopRight(name + "_top_right" + textureSuffix, bottom, top);
            int yRot = (int)((Direction)state.m_61143_((Property)DoorBlock.f_52726_)).m_122435_() + 90;
            if (open) {
                yRot += 90;
            }
            if (right && open) {
                yRot += 180;
            }
            BlockModelBuilder model = null;
            model = lower ? (right ? bottomRight : bottomLeft) : (right ? topRight : topLeft);
            return ConfiguredModel.builder().modelFile((ModelFile)model).rotationY(yRot %= 360).build();
        }, new Property[]{DoorBlock.f_52729_});
    }

    public <T extends IronBarsBlock> void meltableBars(Supplier<T> block) {
        String baseName = this.name(block);
        List<String> prefixes = List.of("", "goopy_", "red_hot_");
        MultiPartBlockStateBuilder builder = this.getMultipartBuilder((Block)block.get());
        IntegerProperty property = ((IMeltableBlock)((IronBarsBlock)block.get())).getGoopynessProperty();
        property.m_6908_().forEach(goopyness -> {
            String name = (String)prefixes.get((int)goopyness) + baseName;
            ResourceLocation texture = this.texture(name);
            Function<String, ModelFile> createModel = suffix -> ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(name + suffix, this.mcLoc("block/iron_bars" + suffix))).texture("bars", texture)).texture("edge", texture)).texture("particle", texture);
            ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile(createModel.apply("_post_ends")).addModel()).condition((Property)property, (Comparable[])new Integer[]{goopyness});
            ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile(createModel.apply("_post")).addModel()).condition((Property)property, (Comparable[])new Integer[]{goopyness}).condition((Property)IronBarsBlock.f_52309_, (Comparable[])new Boolean[]{false}).condition((Property)IronBarsBlock.f_52310_, (Comparable[])new Boolean[]{false}).condition((Property)IronBarsBlock.f_52311_, (Comparable[])new Boolean[]{false}).condition((Property)IronBarsBlock.f_52312_, (Comparable[])new Boolean[]{false});
            Arrays.stream(Direction.values()).filter(it -> it.m_122434_().m_122479_()).forEach(direction -> {
                String suffix = switch (direction) {
                    case Direction.SOUTH, Direction.WEST -> "_alt";
                    default -> "";
                };
                int yRotation = switch (direction) {
                    case Direction.WEST, Direction.EAST -> 90;
                    default -> 0;
                };
                ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)createModel.apply("_cap" + suffix)).rotationY(yRotation).addModel()).condition((Property)property, (Comparable[])new Integer[]{goopyness}).condition((Property)CrossCollisionBlock.f_52309_, (Comparable[])new Boolean[]{direction == Direction.NORTH}).condition((Property)CrossCollisionBlock.f_52310_, (Comparable[])new Boolean[]{direction == Direction.EAST}).condition((Property)CrossCollisionBlock.f_52311_, (Comparable[])new Boolean[]{direction == Direction.SOUTH}).condition((Property)CrossCollisionBlock.f_52312_, (Comparable[])new Boolean[]{direction == Direction.WEST});
                ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)createModel.apply("_side" + suffix)).rotationY(yRotation).addModel()).condition((Property)property, (Comparable[])new Integer[]{goopyness}).condition((Property)PipeBlock.f_55154_.get(direction), (Comparable[])new Boolean[]{true});
            });
        });
    }

    public void gargoyleBlock(Supplier<? extends Block> block) {
        String name = this.name(block);
        ModelFile.ExistingModelFile floorModel = this.models().getExistingFile(this.texture(name));
        ModelFile.ExistingModelFile wallModel = this.models().getExistingFile(this.texture(name + "_side"));
        this.getVariantBuilder(block.get()).forAllStatesExcept(state -> {
            Direction facing = (Direction)state.m_61143_((Property)BlockStateProperties.f_61374_);
            GargoyleBlock.AttachmentType attachment = (GargoyleBlock.AttachmentType)((Object)((Object)state.m_61143_(GargoyleBlock.ATTACHMENT)));
            return ConfiguredModel.builder().rotationY((int)(facing.m_122435_() % 360.0f)).modelFile((ModelFile)(attachment == GargoyleBlock.AttachmentType.WALL ? wallModel : floorModel)).build();
        }, new Property[0]);
    }

    public void crate(Supplier<? extends Block> block) {
        String name = this.name(block);
        this.simpleBlock(block.get(), (ModelFile)this.models().cubeBottomTop(name, this.texture(name).m_266382_("_side"), this.texture(name).m_266382_("_bottom"), this.texture(name).m_266382_("_top")));
    }
}

