/*
 * Decompiled with CFR 0.152.
 */
package galena.oreganized.content.block;

import galena.oreganized.OreganizedConfig;
import galena.oreganized.index.OCriteriaTriggers;
import galena.oreganized.index.OEffects;
import galena.oreganized.index.OItems;
import galena.oreganized.index.OParticleTypes;
import galena.oreganized.index.OTags;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AreaEffectCloud;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="oreganized")
public class LeadOreBlock {
    private static Stream<MobEffectInstance> getEffects(int durationMultiplier) {
        if (((Boolean)OreganizedConfig.COMMON.poisonInsteadOfStunning.get()).booleanValue()) {
            return Stream.of(new MobEffectInstance(MobEffects.f_19614_, 150 * durationMultiplier));
        }
        return Stream.of(new MobEffectInstance((MobEffect)OEffects.STUNNING.get(), 600 * durationMultiplier), new MobEffectInstance(MobEffects.f_19614_, 40));
    }

    public static void trySpawnLeadCloud(BlockState state, Level level, BlockPos pos, ItemStack held) {
        if (LeadOreBlock.shouldSpawnCloud(state, (LevelAccessor)level, pos, held)) {
            LeadOreBlock.spawnCloud(level, pos, 2.0f);
        }
    }

    @SubscribeEvent
    public static void onBreak(BlockEvent.BreakEvent event) {
        BlockState state = event.getState();
        BlockPos pos = event.getPos();
        LevelAccessor levelAccessor = event.getLevel();
        if (!(levelAccessor instanceof Level)) {
            return;
        }
        Level level = (Level)levelAccessor;
        Player player = event.getPlayer();
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player2 = (ServerPlayer)player;
        ItemStack held = player2.m_21205_();
        if (LeadOreBlock.shouldSpawnCloud(state, (LevelAccessor)level, pos, held)) {
            OCriteriaTriggers.IN_LEAD_CLOUD.trigger(player2);
        }
    }

    private static boolean shouldSpawnCloud(BlockState state, LevelAccessor level, BlockPos pos, ItemStack stack) {
        if (!((Boolean)OreganizedConfig.COMMON.leadDustCloud.get()).booleanValue()) {
            return false;
        }
        if (stack.m_150930_((Item)OItems.SCRIBE.get()) || EnchantmentHelper.m_272262_((ItemStack)stack)) {
            return false;
        }
        if (!state.m_204336_(OTags.Blocks.CREATES_LEAD_CLOUD)) {
            return false;
        }
        for (Direction direction : Direction.values()) {
            BlockState adjacentState = level.m_8055_(pos.m_121945_(direction));
            if (!adjacentState.m_204336_(OTags.Blocks.PREVENTS_LEAD_CLOUD)) continue;
            return false;
        }
        return true;
    }

    public static AreaEffectCloud spawnCloud(Level level, BlockPos pos, float size) {
        Vec3 vec = Vec3.m_82512_((Vec3i)pos);
        AreaEffectCloud cloud = new AreaEffectCloud(level, vec.f_82479_, vec.f_82480_, vec.f_82481_);
        LeadOreBlock.getEffects(Math.max(1, (int)size)).forEach(arg_0 -> ((AreaEffectCloud)cloud).m_19716_(arg_0));
        cloud.m_19724_((ParticleOptions)OParticleTypes.LEAD_CLOUD.get());
        cloud.m_19712_(1.5f * size);
        cloud.m_19738_(-0.02f);
        cloud.m_19734_((int)(120.0f * size));
        level.m_7967_((Entity)cloud);
        return cloud;
    }

    public static void blowParticles(LevelAccessor level, BlockPos pos, Direction facing, int maxDistance) {
        double speed = 0.5;
        maxDistance = Math.min(maxDistance, 8);
        for (int distance = 1; distance < maxDistance; ++distance) {
            BlockPos frontPos = pos.m_5484_(facing, distance);
            BlockState frontState = level.m_8055_(frontPos);
            if (!frontState.m_204336_(OTags.Blocks.BLOWS_LEAD_CLOUD)) continue;
            Vec3 vec = Vec3.m_82512_((Vec3i)frontPos);
            level.m_7106_((ParticleOptions)OParticleTypes.LEAD_BLOW.get(), vec.f_82479_, vec.f_82480_, vec.f_82481_, (double)facing.m_122429_() * speed, (double)facing.m_122430_() * speed, (double)facing.m_122431_() * speed);
            List targets = level.m_45976_(LivingEntity.class, new AABB(frontPos, pos.m_5484_(facing, maxDistance)).m_82363_(1.0, 1.0, 1.0));
            targets.forEach(target -> LeadOreBlock.getEffects(1).filter(it -> !target.m_21023_(it.m_19544_())).forEach(arg_0 -> ((LivingEntity)target).m_7292_(arg_0)));
            return;
        }
    }
}

