/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.mysticaloaktree.client.dialogues.types;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import net.mehvahdjukaar.mysticaloaktree.client.dialogues.ITreeDialogue;
import net.mehvahdjukaar.mysticaloaktree.client.dialogues.TreeDialogueTypes;

public record TalkedTo(int trust, List<String> text, List<Boolean> requiresInteraction) implements ITreeDialogue
{
    public static final Codec<TalkedTo> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.intRange((int)0, (int)100).fieldOf("trust_required").forGetter(t -> t.trust), (App)Codec.STRING.listOf().fieldOf("text").forGetter(t -> t.text), (App)Codec.BOOL.listOf().optionalFieldOf("require_interaction", List.of()).forGetter(t -> t.requiresInteraction)).apply((Applicative)instance, TalkedTo::new));

    public ITreeDialogue.Type<TalkedTo> getType() {
        return TreeDialogueTypes.TALKED_TO;
    }

    @Override
    public int getRequiredTrust() {
        return this.trust;
    }

    @Override
    public ITreeDialogue.Status getLine(int lineIndex, boolean hasBeenInteractedWith) {
        if (lineIndex < this.text.size()) {
            String s = this.text.get(lineIndex);
            if (lineIndex > 0 && lineIndex - 1 < this.requiresInteraction.size() && this.requiresInteraction.get(lineIndex - 1).booleanValue() && !hasBeenInteractedWith) {
                return ITreeDialogue.Status.WAITING;
            }
            return new ITreeDialogue.Status(s);
        }
        return ITreeDialogue.Status.DONE;
    }
}

