/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.mysticaloaktree.client.dialogues;

import net.mehvahdjukaar.mysticaloaktree.client.TreeLoreManager;
import net.mehvahdjukaar.mysticaloaktree.client.dialogues.ITreeDialogue;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;

public class DialogueInstance {
    private static final int TIME_PER_LINE = 51;
    private static final int WAIT_TIME = 40;
    private static final int MAX_DISTANCE_SQ = 36;
    private final ITreeDialogue dialogue;
    private int timeUntilNextLine = 0;
    private int lineIndex = 0;
    private boolean waiting = false;

    DialogueInstance(ITreeDialogue dialogue) {
        this.dialogue = dialogue;
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean tick(BlockPos pos) {
        if (this.timeUntilNextLine != 0) {
            --this.timeUntilNextLine;
            return true;
        }
        if (this.waiting) {
            return true;
        }
        ITreeDialogue.Status status = this.dialogue.getLine(this.lineIndex, false);
        if (status == ITreeDialogue.Status.WAITING) {
            this.timeUntilNextLine = 40;
            this.waiting = true;
            return true;
        }
        if (status == ITreeDialogue.Status.DONE) {
            return false;
        }
        this.talk(status.text(), pos);
        return true;
    }

    public boolean interact(BlockPos pos) {
        ITreeDialogue.Status status;
        if (this.waiting && (status = this.dialogue.getLine(this.lineIndex, true)) != ITreeDialogue.Status.WAITING && status != ITreeDialogue.Status.DONE) {
            this.talk(status.text(), pos);
            return true;
        }
        return false;
    }

    private void talk(String text, BlockPos pos) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player != null && pos.m_203193_((Position)player.m_20182_()) < 36.0) {
            player.m_5661_((Component)TreeLoreManager.formatText(text, (Player)player), true);
        }
        this.timeUntilNextLine = 51;
        ++this.lineIndex;
        this.waiting = false;
    }
}

