/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbquests.quest.task;

import dev.ftb.mods.ftblibrary.config.ConfigGroup;
import dev.ftb.mods.ftblibrary.config.NameMap;
import dev.ftb.mods.ftblibrary.icon.Icon;
import dev.ftb.mods.ftblibrary.icon.ItemIcon;
import dev.ftb.mods.ftblibrary.util.KnownServerRegistries;
import dev.ftb.mods.ftbquests.quest.Quest;
import dev.ftb.mods.ftbquests.quest.TeamData;
import dev.ftb.mods.ftbquests.quest.task.AbstractBooleanTask;
import dev.ftb.mods.ftbquests.quest.task.TaskType;
import dev.ftb.mods.ftbquests.quest.task.TaskTypes;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementProgress;
import net.minecraft.advancements.CriterionProgress;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class AdvancementTask
extends AbstractBooleanTask {
    private ResourceLocation advancement = new ResourceLocation("minecraft:story/root");
    private String criterion = "";

    public AdvancementTask(long id, Quest quest) {
        super(id, quest);
    }

    @Override
    public TaskType getType() {
        return TaskTypes.ADVANCEMENT;
    }

    @Override
    public void writeData(CompoundTag nbt) {
        super.writeData(nbt);
        nbt.m_128359_("advancement", this.advancement.toString());
        nbt.m_128359_("criterion", this.criterion);
    }

    @Override
    public void readData(CompoundTag nbt) {
        super.readData(nbt);
        this.advancement = new ResourceLocation(nbt.m_128461_("advancement"));
        this.criterion = nbt.m_128461_("criterion");
    }

    @Override
    public void writeNetData(FriendlyByteBuf buffer) {
        super.writeNetData(buffer);
        buffer.m_130085_(this.advancement);
        buffer.m_130072_(this.criterion, Short.MAX_VALUE);
    }

    @Override
    public void readNetData(FriendlyByteBuf buffer) {
        super.readNetData(buffer);
        this.advancement = buffer.m_130281_();
        this.criterion = buffer.m_130136_(Short.MAX_VALUE);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void fillConfigGroup(ConfigGroup config) {
        super.fillConfigGroup(config);
        if (KnownServerRegistries.client != null && !KnownServerRegistries.client.advancements.isEmpty()) {
            Map advancements = KnownServerRegistries.client.advancements;
            KnownServerRegistries.AdvancementInfo def = (KnownServerRegistries.AdvancementInfo)advancements.values().iterator().next();
            config.addEnum("advancement", (Object)this.advancement, v -> {
                this.advancement = v;
            }, NameMap.of((Object)def.id, (Object[])advancements.keySet().toArray(new ResourceLocation[0])).icon(id -> ItemIcon.getItemIcon((ItemStack)KnownServerRegistries.client.advancements.getOrDefault((Object)id, def).icon)).name(id -> KnownServerRegistries.client.advancements.getOrDefault((Object)id, def).name).create()).setNameKey("ftbquests.task.ftbquests.advancement");
        } else {
            config.addString("advancement", this.advancement.toString(), v -> {
                this.advancement = new ResourceLocation(v);
            }, "minecraft:story/root").setNameKey("ftbquests.task.ftbquests.advancement");
        }
        config.addString("criterion", this.criterion, v -> {
            this.criterion = v;
        }, "");
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public Component getAltTitle() {
        KnownServerRegistries.AdvancementInfo info;
        KnownServerRegistries.AdvancementInfo advancementInfo = info = KnownServerRegistries.client == null ? null : (KnownServerRegistries.AdvancementInfo)KnownServerRegistries.client.advancements.get(this.advancement);
        if (info != null && info.name.m_214077_() != ComponentContents.f_237124_) {
            return Component.m_237115_((String)"ftbquests.task.ftbquests.advancement").m_130946_(": ").m_7220_((Component)Component.m_237113_((String)"").m_7220_(info.name).m_130940_(ChatFormatting.YELLOW));
        }
        return super.getAltTitle();
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public Icon getAltIcon() {
        KnownServerRegistries.AdvancementInfo info;
        KnownServerRegistries.AdvancementInfo advancementInfo = info = KnownServerRegistries.client == null ? null : (KnownServerRegistries.AdvancementInfo)KnownServerRegistries.client.advancements.get(this.advancement);
        if (info != null && !info.icon.m_41619_()) {
            return ItemIcon.getItemIcon((ItemStack)info.icon);
        }
        return super.getAltIcon();
    }

    @Override
    public int autoSubmitOnPlayerTick() {
        return 5;
    }

    @Override
    public boolean canSubmit(TeamData teamData, ServerPlayer player) {
        Advancement a = player.f_8924_.m_129889_().m_136041_(this.advancement);
        if (a == null) {
            return false;
        }
        AdvancementProgress progress = player.m_8960_().m_135996_(a);
        if (this.criterion.isEmpty()) {
            return progress.m_8193_();
        }
        CriterionProgress criterionProgress = progress.m_8214_(this.criterion);
        return criterionProgress != null && criterionProgress.m_12911_();
    }
}

