/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.common.worldgen.feature.misc;

import biomesoplenty.api.block.BOPBlocks;
import biomesoplenty.common.util.SimpleBlockPredicate;
import biomesoplenty.init.ModTags;
import com.mojang.serialization.Codec;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.LevelWriter;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.TreeFeature;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;

public class BoneSpineFeature
extends Feature<NoneFeatureConfiguration> {
    protected SimpleBlockPredicate placeOn = (world, pos) -> world.m_8055_(pos).m_204336_(ModTags.Blocks.FLESH) || world.m_8055_(pos).m_60734_() == Blocks.f_50440_;
    protected SimpleBlockPredicate replace = (world, pos) -> BoneSpineFeature.isAir((LevelSimulatedReader)world, pos) || TreeFeature.m_67267_((LevelSimulatedReader)world, (BlockPos)pos) || world.m_8055_(pos).m_278721_() || world.m_8055_(pos).m_60734_() == BOPBlocks.PUS_BUBBLE.get() || world.m_8055_(pos).m_60734_() == BOPBlocks.HAIR.get();
    private int maxHeight = 3;

    public BoneSpineFeature(Codec<NoneFeatureConfiguration> deserializer) {
        super(deserializer);
    }

    public boolean m_142674_(FeaturePlaceContext<NoneFeatureConfiguration> featurePlaceContext) {
        WorldGenLevel world = featurePlaceContext.m_159774_();
        ChunkGenerator chunkGenerator = featurePlaceContext.m_159775_();
        RandomSource rand = featurePlaceContext.m_225041_();
        BlockPos startPos = featurePlaceContext.m_159777_();
        NoneFeatureConfiguration config = (NoneFeatureConfiguration)featurePlaceContext.m_159778_();
        while (startPos.m_123342_() >= world.m_141937_() + 1 && this.replace.matches(world, startPos)) {
            startPos = startPos.m_7495_();
        }
        if (!this.placeOn.matches(world, startPos)) {
            return false;
        }
        if (!this.checkSpace(world, startPos.m_7494_())) {
            return false;
        }
        BlockPos pos = startPos.m_7494_();
        int height = 1 + rand.m_188503_(this.maxHeight - 1);
        for (int y = 0; y <= height; ++y) {
            this.setBlock(world, pos.m_7918_(0, y, 0), Blocks.f_50453_.m_49966_());
        }
        return true;
    }

    public boolean setBlock(WorldGenLevel world, BlockPos pos, BlockState state) {
        if (this.replace.matches(world, pos)) {
            super.m_5974_((LevelWriter)world, pos, state);
            return true;
        }
        return false;
    }

    public boolean checkSpace(WorldGenLevel world, BlockPos pos) {
        for (int y = 0; y <= this.maxHeight + 1; ++y) {
            for (int x = -2; x <= 2; ++x) {
                for (int z = -2; z <= 2; ++z) {
                    BlockPos pos1 = pos.m_7918_(x, y, z);
                    if (pos1.m_123342_() < 255 && this.replace.matches(world, pos1)) continue;
                    return false;
                }
            }
        }
        return true;
    }

    public static boolean isAir(LevelSimulatedReader level, BlockPos pos) {
        return level.m_7433_(pos, BlockBehaviour.BlockStateBase::m_60795_);
    }
}

