/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.client.handler;

import biomesoplenty.api.block.BOPBlockEntities;
import biomesoplenty.api.entity.BOPEntities;
import biomesoplenty.client.renderer.BoatRendererBOP;
import biomesoplenty.common.entity.BoatBOP;
import net.minecraft.client.model.BoatModel;
import net.minecraft.client.model.ChestBoatModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.renderer.blockentity.HangingSignRenderer;
import net.minecraft.client.renderer.blockentity.SignRenderer;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="biomesoplenty", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.MOD)
public class EntityRendererHandler {
    @SubscribeEvent
    public static void onRegisterRenderers(EntityRenderersEvent.RegisterRenderers event) {
        LayerDefinition boatLayerDefinition = BoatModel.m_246613_();
        LayerDefinition chestBoatLayerDefinition = ChestBoatModel.m_247175_();
        for (BoatBOP.ModelType type : BoatBOP.ModelType.values()) {
            ForgeHooksClient.registerLayerDefinition((ModelLayerLocation)BoatRendererBOP.createBoatModelName(type), () -> boatLayerDefinition);
            ForgeHooksClient.registerLayerDefinition((ModelLayerLocation)BoatRendererBOP.createChestBoatModelName(type), () -> chestBoatLayerDefinition);
        }
        event.registerBlockEntityRenderer((BlockEntityType)BOPBlockEntities.SIGN.get(), SignRenderer::new);
        event.registerBlockEntityRenderer((BlockEntityType)BOPBlockEntities.HANGING_SIGN.get(), HangingSignRenderer::new);
        event.registerEntityRenderer((EntityType)BOPEntities.BOAT.get(), context -> new BoatRendererBOP(context, false));
        event.registerEntityRenderer((EntityType)BOPEntities.CHEST_BOAT.get(), context -> new BoatRendererBOP(context, true));
    }
}

