/*
 * Decompiled with CFR 0.152.
 */
package com.soytutta.mynethersdelight.common.block;

import com.soytutta.mynethersdelight.common.registry.MNDBlocks;
import com.soytutta.mynethersdelight.common.tag.MNDTags;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.NetherWartBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.IPlantable;

public class LetiosCompostBlock
extends Block {
    public static IntegerProperty FORGOTING = IntegerProperty.m_61631_((String)"forgoting", (int)0, (int)9);

    public LetiosCompostBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)super.m_49966_().m_61124_((Property)FORGOTING, (Comparable)Integer.valueOf(0)));
    }

    public boolean m_6724_(BlockState state) {
        return true;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FORGOTING});
        super.m_7926_(builder);
    }

    public int getMaxForgotingStage() {
        return 9;
    }

    public void m_213898_(BlockState state, ServerLevel worldIn, BlockPos pos, RandomSource random) {
        if (!worldIn.f_46443_) {
            float chance = 0.0f;
            boolean hasLava = false;
            boolean isSoulBiome = false;
            for (BlockPos neighborPos : BlockPos.m_121940_((BlockPos)pos.m_7918_(-1, -1, -1), (BlockPos)pos.m_7918_(1, 1, 1))) {
                BlockState neighborState = worldIn.m_8055_(neighborPos);
                if (neighborState.m_204336_(MNDTags.LETIOS_ACTIVATORS)) {
                    chance += 0.02f;
                }
                if (neighborState.m_204336_(MNDTags.LETIOS_FLAMES) && (!neighborState.m_61138_((Property)BlockStateProperties.f_61443_) || neighborState.m_61138_((Property)BlockStateProperties.f_61443_) && ((Boolean)neighborState.m_61143_((Property)BlockStateProperties.f_61443_)).booleanValue())) {
                    chance += 0.02f;
                }
                if (neighborState.m_60819_().m_205070_(FluidTags.f_13132_)) {
                    hasLava = true;
                }
                if (!worldIn.m_204166_(pos).m_203565_(Biomes.f_48199_)) continue;
                isSoulBiome = true;
            }
            chance += hasLava ? 0.3f : 0.0f;
            chance += isSoulBiome ? 0.3f : 0.0f;
            if (worldIn.m_213780_().m_188501_() <= chance && worldIn.m_6042_().f_63857_()) {
                if (((Integer)state.m_61143_((Property)FORGOTING)).intValue() == this.getMaxForgotingStage()) {
                    worldIn.m_7731_(pos, ((Block)MNDBlocks.RESURGENT_SOIL.get()).m_49966_(), 3);
                } else {
                    worldIn.m_7731_(pos, (BlockState)state.m_61124_((Property)FORGOTING, (Comparable)Integer.valueOf((Integer)state.m_61143_((Property)FORGOTING) + 1)), 3);
                }
            }
        }
    }

    public boolean isFlammable(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
        return false;
    }

    public boolean m_7278_(BlockState state) {
        return true;
    }

    public int m_6782_(BlockState blockState, Level worldIn, BlockPos pos) {
        return this.getMaxForgotingStage() + 1 - (Integer)blockState.m_61143_((Property)FORGOTING);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_214162_(BlockState state, Level level, BlockPos pos, RandomSource random) {
        super.m_214162_(state, level, pos, random);
        if (random.m_188503_(10) == 0 && level.m_6042_().f_63857_()) {
            level.m_7106_((ParticleOptions)ParticleTypes.f_123746_, (double)pos.m_123341_() + (double)random.m_188501_(), (double)pos.m_123342_() + 1.1, (double)pos.m_123343_() + (double)random.m_188501_(), 0.0, 0.0, 0.0);
        }
    }

    public boolean canSustainPlant(BlockState state, BlockGetter world, BlockPos pos, Direction facing, IPlantable plantable) {
        if (plantable instanceof NetherWartBlock && facing == Direction.UP) {
            return true;
        }
        return super.canSustainPlant(state, world, pos, facing, plantable);
    }
}

