/*
 * Decompiled with CFR 0.152.
 */
package dev.muon.medievalorigins.power;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.muon.medievalorigins.entity.ISummon;
import io.github.apace100.apoli.data.ApoliDataTypes;
import io.github.apace100.apoli.power.Power;
import io.github.apace100.apoli.power.PowerType;
import io.github.apace100.apoli.util.AttributedEntityAttributeModifier;
import io.github.apace100.calio.data.SerializableDataTypes;
import io.github.edwinmindcraft.apoli.api.IDynamicFeatureConfiguration;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;

public class OwnerAttributeTransferPower
extends Power
implements IDynamicFeatureConfiguration {
    private final List<AttributedEntityAttributeModifier> modifiers;
    private final int tickRate;
    private final boolean updateHealth;
    private final Attribute ownerAttribute;
    public static final Codec<OwnerAttributeTransferPower> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)SerializableDataTypes.INT.fieldOf("tick_rate").forGetter(power -> power.tickRate), (App)SerializableDataTypes.BOOLEAN.fieldOf("update_health").forGetter(power -> power.updateHealth), (App)SerializableDataTypes.ATTRIBUTE.fieldOf("owner_attribute").forGetter(power -> power.ownerAttribute), (App)ApoliDataTypes.ATTRIBUTED_ATTRIBUTE_MODIFIERS.listOf().optionalFieldOf("modifiers", new LinkedList()).forGetter(power -> Collections.singletonList(power.modifiers))).apply((Applicative)instance, (tickRate, updateHealth, ownerAttribute, modifiers) -> new OwnerAttributeTransferPower(null, null, (int)tickRate, (boolean)updateHealth, (Attribute)ownerAttribute, (List)modifiers.get(0))));

    public OwnerAttributeTransferPower(PowerType<?> type, LivingEntity entity, int tickRate, boolean updateHealth, Attribute ownerAttribute, List<AttributedEntityAttributeModifier> modifiers) {
        super(type, entity);
        this.setTicking(true);
        this.tickRate = tickRate;
        this.updateHealth = updateHealth;
        this.ownerAttribute = ownerAttribute;
        this.modifiers = modifiers != null ? modifiers : new LinkedList();
    }

    public void tick() {
        if (this.entity.f_19797_ % this.tickRate == 0) {
            if (this.isActive()) {
                this.applyModifiers();
            } else {
                this.removeModifiers();
            }
        }
    }

    public void onRemoved() {
        this.removeModifiers();
    }

    private void applyModifiers() {
        if (this.entity instanceof ISummon) {
            double previousMaxHealth = this.entity.m_21233_();
            double previousHealthPercent = (double)this.entity.m_21223_() / previousMaxHealth;
            LivingEntity owner = ((ISummon)this.entity).m_269323_();
            if (owner != null && this.ownerAttribute != null) {
                AttributeInstance ownerAttributeInstance = owner.m_21051_(this.ownerAttribute);
                if (ownerAttributeInstance != null) {
                    double ownerAttributeValue = ownerAttributeInstance.m_22135_();
                    this.modifiers.forEach(mod -> {
                        AttributeInstance summonAttributeInstance = this.entity.m_21051_(mod.getAttribute());
                        if (summonAttributeInstance != null) {
                            double finalModifierAmount = ownerAttributeValue * mod.getModifier().m_22218_();
                            AttributeModifier newModifier = new AttributeModifier(mod.getModifier().m_22209_(), mod.getModifier().m_22214_(), finalModifierAmount, mod.getModifier().m_22217_());
                            if (!summonAttributeInstance.m_22109_(newModifier)) {
                                summonAttributeInstance.m_22118_(newModifier);
                            }
                        }
                    });
                }
                if (this.updateHealth) {
                    double afterMaxHealth = this.entity.m_21233_();
                    this.entity.m_21153_((float)(afterMaxHealth * previousHealthPercent));
                }
            }
        }
    }

    private void removeModifiers() {
        if (this.entity instanceof ISummon) {
            double previousMaxHealth = this.entity.m_21233_();
            double previousHealthPercent = (double)this.entity.m_21223_() / previousMaxHealth;
            this.modifiers.forEach(mod -> {
                AttributeInstance summonAttributeInstance = this.entity.m_21051_(mod.getAttribute());
                if (summonAttributeInstance != null) {
                    summonAttributeInstance.m_22130_(mod.getModifier());
                }
            });
            if (this.updateHealth) {
                double afterMaxHealth = this.entity.m_21233_();
                this.entity.m_21153_((float)(afterMaxHealth * previousHealthPercent));
            }
        }
    }
}

