/*
 * Decompiled with CFR 0.152.
 */
package dev.muon.medievalorigins.condition;

import dev.muon.medievalorigins.enchantment.ModEnchantments;
import io.github.edwinmindcraft.apoli.api.power.factory.BiEntityCondition;
import io.github.edwinmindcraft.apoli.api.power.factory.BlockCondition;
import io.github.edwinmindcraft.apoli.api.power.factory.DamageCondition;
import io.github.edwinmindcraft.apoli.api.power.factory.EntityCondition;
import io.github.edwinmindcraft.apoli.api.power.factory.ItemCondition;
import io.github.edwinmindcraft.apoli.api.registry.ApoliRegistries;
import io.github.edwinmindcraft.apoli.common.condition.bientity.SimpleBiEntityCondition;
import io.github.edwinmindcraft.apoli.common.condition.block.SimpleBlockCondition;
import io.github.edwinmindcraft.apoli.common.condition.damage.InTagCondition;
import io.github.edwinmindcraft.apoli.common.condition.entity.SimpleEntityCondition;
import io.github.edwinmindcraft.apoli.common.condition.item.SimpleItemCondition;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.DiggerItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.TieredItem;
import net.minecraft.world.item.TridentItem;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;

public class ModConditions {
    public static final DeferredRegister<EntityCondition<?>> ENTITY_CONDITIONS = DeferredRegister.create((ResourceKey)ApoliRegistries.ENTITY_CONDITION_KEY, (String)"medievalorigins");
    public static final DeferredRegister<BiEntityCondition<?>> BIENTITY_CONDITIONS = DeferredRegister.create((ResourceKey)ApoliRegistries.BIENTITY_CONDITION_KEY, (String)"medievalorigins");
    public static final DeferredRegister<BlockCondition<?>> BLOCK_CONDITIONS = DeferredRegister.create((ResourceKey)ApoliRegistries.BLOCK_CONDITION_KEY, (String)"medievalorigins");
    public static final DeferredRegister<DamageCondition<?>> DAMAGE_CONDITIONS = DeferredRegister.create((ResourceKey)ApoliRegistries.DAMAGE_CONDITION_KEY, (String)"medievalorigins");
    public static final DeferredRegister<ItemCondition<?>> ITEM_CONDITIONS = DeferredRegister.create((ResourceKey)ApoliRegistries.ITEM_CONDITION_KEY, (String)"medievalorigins");
    public static final RegistryObject<SimpleEntityCondition> IS_ARROW = ENTITY_CONDITIONS.register("is_arrow", () -> new SimpleEntityCondition(entity -> entity instanceof AbstractArrow));
    public static final RegistryObject<SimpleEntityCondition> CREATIVE_MODE = ENTITY_CONDITIONS.register("creative_mode", () -> new SimpleEntityCondition(entity -> {
        if (!(entity instanceof Player)) return false;
        Player player = (Player)entity;
        if (!player.m_150110_().f_35937_) return false;
        return true;
    }));
    public static final RegistryObject<SimpleBiEntityCondition> IS_ALLIED = BIENTITY_CONDITIONS.register("allied", () -> new SimpleBiEntityCondition((actor, target) -> actor.m_7307_(target)));
    public static final RegistryObject<SimpleItemCondition> IS_MELEE_WEAPON = ITEM_CONDITIONS.register("is_melee_weapon", () -> new SimpleItemCondition(stack -> Enchantments.f_44977_.m_6081_(stack) || stack.m_41720_() instanceof DiggerItem && ((DiggerItem)stack.m_41720_()).m_41008_() > 0.0f));
    public static final RegistryObject<SimpleItemCondition> IS_BOW = ITEM_CONDITIONS.register("is_bow", () -> new SimpleItemCondition(stack -> stack.m_41720_() instanceof BowItem));
    public static final RegistryObject<SimpleItemCondition> IS_DAGGER = ITEM_CONDITIONS.register("is_dagger", () -> new SimpleItemCondition(stack -> {
        String itemName = ForgeRegistries.ITEMS.getKey((Object)stack.m_41720_()).m_135815_();
        return !(!(stack.m_41720_() instanceof SwordItem) && !Enchantments.f_44977_.m_6081_(stack) || !itemName.contains("dagger") && !itemName.contains("knife") && !itemName.contains("sai") && !itemName.contains("athame"));
    }));
    public static final RegistryObject<SimpleItemCondition> IS_VALKYRIE_WEAPON = ITEM_CONDITIONS.register("is_valkyrie_weapon", () -> new SimpleItemCondition(stack -> {
        String itemName = ForgeRegistries.ITEMS.getKey((Object)stack.m_41720_()).m_135815_();
        return !(!(stack.m_41720_() instanceof SwordItem) && !(stack.m_41720_() instanceof TridentItem) && !Enchantments.f_44977_.m_6081_(stack) && !Enchantments.f_44961_.m_6081_(stack) || !itemName.contains("glaive") && !itemName.contains("spear") && !itemName.contains("lance") && !itemName.contains("halberd"));
    }));
    public static final RegistryObject<SimpleItemCondition> IS_FIST_WEAPON = ITEM_CONDITIONS.register("is_fist_weapon", () -> new SimpleItemCondition(stack -> {
        String itemName = ForgeRegistries.ITEMS.getKey((Object)stack.m_41720_()).m_135815_();
        return !(!(stack.m_41720_() instanceof SwordItem) && !Enchantments.f_44977_.m_6081_(stack) || !itemName.contains("fist") && !itemName.contains("claw") && !itemName.contains("gauntlet"));
    }));
    public static final RegistryObject<SimpleItemCondition> IS_TOOL = ITEM_CONDITIONS.register("is_tool", () -> new SimpleItemCondition(stack -> stack.m_41720_() instanceof DiggerItem || Enchantments.f_44984_.m_6081_(stack)));
    public static final RegistryObject<SimpleItemCondition> IS_HEAVY_ARMOR = ITEM_CONDITIONS.register("is_heavy_armor", () -> new SimpleItemCondition(stack -> {
        Item patt5797$temp = stack.m_41720_();
        if (patt5797$temp instanceof ArmorItem) {
            ArmorItem armorItem = (ArmorItem)patt5797$temp;
            int featherweightLevel = EnchantmentHelper.m_44843_((Enchantment)((Enchantment)ModEnchantments.FEATHERWEIGHT.get()), (ItemStack)stack);
            return armorItem.m_40405_() > 0.0f && featherweightLevel == 0;
        }
        return false;
    }));
    public static final RegistryObject<SimpleItemCondition> IS_GOLDEN_ARMOR = ITEM_CONDITIONS.register("is_golden_armor", () -> new SimpleItemCondition(stack -> {
        String itemName = ForgeRegistries.ITEMS.getKey((Object)stack.m_41720_()).m_135815_();
        return stack.m_41720_() instanceof ArmorItem && (itemName.contains("gold") || itemName.contains("gilded"));
    }));
    public static final RegistryObject<SimpleItemCondition> IS_SILVER_ARMOR = ITEM_CONDITIONS.register("is_silver_armor", () -> new SimpleItemCondition(stack -> {
        String itemName = ForgeRegistries.ITEMS.getKey((Object)stack.m_41720_()).m_135815_();
        return stack.m_41720_() instanceof ArmorItem && (itemName.contains("silver") || itemName.contains("iron"));
    }));
    public static final RegistryObject<SimpleItemCondition> IS_GOLDEN_WEAPON = ITEM_CONDITIONS.register("is_golden_weapon", () -> new SimpleItemCondition(stack -> {
        String itemName = ForgeRegistries.ITEMS.getKey((Object)stack.m_41720_()).m_135815_();
        return Enchantments.f_44977_.m_6081_(stack) && (itemName.contains("gold") || itemName.contains("gilded"));
    }));
    public static final RegistryObject<SimpleItemCondition> IS_GOLDEN_TOOL = ITEM_CONDITIONS.register("is_golden_tool", () -> new SimpleItemCondition(stack -> {
        String itemName = ForgeRegistries.ITEMS.getKey((Object)stack.m_41720_()).m_135815_();
        return stack.m_41720_() instanceof DiggerItem && (itemName.contains("gold") || itemName.contains("gilded"));
    }));
    public static final RegistryObject<SimpleItemCondition> IS_SUMMON_WEAPON = ITEM_CONDITIONS.register("is_summon_weapon", () -> new SimpleItemCondition(stack -> stack.m_41720_() == Items.f_42411_ || stack.m_41720_() instanceof DiggerItem || stack.m_41720_() instanceof SwordItem));
    public static final RegistryObject<SimpleItemCondition> IS_AXE = ITEM_CONDITIONS.register("is_axe", () -> new SimpleItemCondition(stack -> {
        String itemName = ForgeRegistries.ITEMS.getKey((Object)stack.m_41720_()).m_135815_();
        return stack.m_41720_() instanceof AxeItem || stack.m_41720_() instanceof TieredItem && itemName.contains("axe") && !itemName.contains("pickaxe");
    }));
    public static final RegistryObject<SimpleItemCondition> IS_SILVER_WEAPON = ITEM_CONDITIONS.register("is_silver_weapon", () -> new SimpleItemCondition(stack -> {
        String itemName = ForgeRegistries.ITEMS.getKey((Object)stack.m_41720_()).m_135815_();
        return Enchantments.f_44977_.m_6081_(stack) && (itemName.contains("silver") || itemName.contains("iron"));
    }));
    public static final RegistryObject<SimpleItemCondition> IS_SILVER_TOOL = ITEM_CONDITIONS.register("is_silver_tool", () -> new SimpleItemCondition(stack -> {
        String itemName = ForgeRegistries.ITEMS.getKey((Object)stack.m_41720_()).m_135815_();
        return stack.m_41720_() instanceof DiggerItem && (itemName.contains("silver") || itemName.contains("iron"));
    }));
    public static final RegistryObject<SimpleItemCondition> IS_CURSED = ITEM_CONDITIONS.register("is_cursed", () -> new SimpleItemCondition(stack -> {
        for (Enchantment enchantment : stack.m_41785_().stream().map(tag -> Enchantment.m_44697_((int)tag.m_7060_())).toList()) {
            if (enchantment == null || !enchantment.m_6589_()) continue;
            return true;
        }
        return false;
    }));
    public static final RegistryObject<SimpleBlockCondition> HARVESTABLE_CROPS = BLOCK_CONDITIONS.register("harvestable_crops", () -> new SimpleBlockCondition((level, pos, stateSuppplier) -> {
        BlockState state = (BlockState)stateSuppplier.get();
        Block patt10166$temp = state.m_60734_();
        if (patt10166$temp instanceof CropBlock) {
            CropBlock crop = (CropBlock)patt10166$temp;
            return crop.m_52307_(state);
        }
        return false;
    }));
    public static final RegistryObject<DamageCondition> IN_TAG = DAMAGE_CONDITIONS.register("in_tag", InTagCondition::new);

    public static void register(IEventBus eventBus) {
        ENTITY_CONDITIONS.register(eventBus);
        BIENTITY_CONDITIONS.register(eventBus);
        BLOCK_CONDITIONS.register(eventBus);
        DAMAGE_CONDITIONS.register(eventBus);
        ITEM_CONDITIONS.register(eventBus);
    }
}

