/*
 * Decompiled with CFR 0.152.
 */
package dev.muon.medievalorigins.action;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.muon.medievalorigins.MedievalOrigins;
import io.github.apace100.calio.data.SerializableDataTypes;
import io.github.edwinmindcraft.apoli.api.IDynamicFeatureConfiguration;
import io.github.edwinmindcraft.apoli.api.power.factory.EntityAction;
import io.redspace.ironsspellbooks.api.events.ChangeManaEvent;
import io.redspace.ironsspellbooks.api.events.SpellPreCastEvent;
import io.redspace.ironsspellbooks.api.magic.MagicData;
import io.redspace.ironsspellbooks.api.registry.SpellRegistry;
import io.redspace.ironsspellbooks.api.spells.AbstractSpell;
import io.redspace.ironsspellbooks.api.spells.CastResult;
import io.redspace.ironsspellbooks.api.spells.CastSource;
import io.redspace.ironsspellbooks.api.util.Utils;
import io.redspace.ironsspellbooks.network.ClientboundCastErrorMessage;
import io.redspace.ironsspellbooks.network.ClientboundUpdateCastingState;
import io.redspace.ironsspellbooks.network.spell.ClientboundOnCastStarted;
import io.redspace.ironsspellbooks.setup.Messages;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetActionBarTextPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;

public class CastSpellAction
extends EntityAction<Configuration> {
    private static final Map<UUID, ContinuousCastData> CONTINUOUS_CASTS = new HashMap<UUID, ContinuousCastData>();

    public CastSpellAction() {
        super(Configuration.CODEC);
    }

    public void execute(Configuration configuration, Entity entity) {
        AbstractSpell spell;
        if (!(entity instanceof LivingEntity)) {
            MedievalOrigins.LOGGER.info("Entity is not a LivingEntity: " + entity);
            return;
        }
        String spellStr = configuration.spell().toString();
        ResourceLocation spellResourceLocation = new ResourceLocation(spellStr);
        if ("minecraft".equals(spellResourceLocation.m_135827_())) {
            spellResourceLocation = new ResourceLocation("irons_spellbooks", spellResourceLocation.m_135815_());
        }
        if ((spell = SpellRegistry.getSpell((ResourceLocation)spellResourceLocation)) == null || "none".equals(spell.getSpellName())) {
            MedievalOrigins.LOGGER.info("No valid spell found for resource location " + spellResourceLocation);
            return;
        }
        Level world = entity.m_9236_();
        if (world.f_46443_) {
            return;
        }
        int powerLevel = configuration.powerLevel();
        Optional<Integer> castTimeOpt = configuration.castTime();
        Optional<Integer> manaCostOpt = configuration.manaCost();
        if (entity instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)entity;
            MagicData magicData = MagicData.getPlayerMagicData((LivingEntity)serverPlayer);
            if (!magicData.isCasting()) {
                int manaCost;
                CastResult castResult = spell.canBeCastedBy(powerLevel, CastSource.COMMAND, magicData, (Player)serverPlayer);
                if (castResult.message != null) {
                    serverPlayer.f_8906_.m_9829_((Packet)new ClientboundSetActionBarTextPacket(castResult.message));
                }
                if (!castResult.isSuccess() || !spell.checkPreCastConditions(world, powerLevel, (LivingEntity)serverPlayer, magicData) || MinecraftForge.EVENT_BUS.post((Event)new SpellPreCastEvent((Player)serverPlayer, spell.getSpellId(), powerLevel, spell.getSchoolType(), CastSource.COMMAND))) {
                    return;
                }
                if (serverPlayer.m_6117_()) {
                    serverPlayer.m_5810_();
                }
                int effectiveCastTime = spell.getEffectiveCastTime(powerLevel, (LivingEntity)serverPlayer);
                if (castTimeOpt.isPresent()) {
                    int castTime;
                    effectiveCastTime = castTime = castTimeOpt.get().intValue();
                }
                if (manaCostOpt.isPresent()) {
                    manaCost = manaCostOpt.get();
                    if (!serverPlayer.m_150110_().f_35937_ && magicData.getMana() < (float)manaCost) {
                        Messages.sendToPlayer((Object)new ClientboundCastErrorMessage(ClientboundCastErrorMessage.ErrorType.MANA, spell), (ServerPlayer)serverPlayer);
                        return;
                    }
                    if (!serverPlayer.m_150110_().f_35937_) {
                        CastSpellAction.setManaWithEvent(serverPlayer, magicData, magicData.getMana() - (float)manaCost);
                    }
                }
                if (configuration.continuousCost() && manaCostOpt.isPresent() && !serverPlayer.m_150110_().f_35937_) {
                    manaCost = manaCostOpt.get();
                    int costInterval = configuration.costInterval();
                    CONTINUOUS_CASTS.put(serverPlayer.m_20148_(), new ContinuousCastData(manaCost, costInterval, 0));
                }
                magicData.initiateCast(spell, powerLevel, effectiveCastTime, CastSource.COMMAND, "command");
                magicData.setPlayerCastingItem(serverPlayer.m_21120_(InteractionHand.MAIN_HAND));
                spell.onServerPreCast(world, powerLevel, (LivingEntity)serverPlayer, magicData);
                Messages.sendToPlayer((Object)new ClientboundUpdateCastingState(spell.getSpellId(), powerLevel, effectiveCastTime, CastSource.COMMAND, "command"), (ServerPlayer)serverPlayer);
                Messages.sendToPlayersTrackingEntity((Object)new ClientboundOnCastStarted(serverPlayer.m_20148_(), spell.getSpellId(), powerLevel), (Entity)serverPlayer, (boolean)true);
            } else {
                Utils.serverSideCancelCast((ServerPlayer)serverPlayer);
            }
        } else {
            MedievalOrigins.LOGGER.info("Entity is not a valid caster (currently only players can cast spells with this entity action): " + entity);
        }
    }

    public static void onSpellTick(ServerPlayer player, MagicData magicData) {
        UUID playerId = player.m_20148_();
        ContinuousCastData data = CONTINUOUS_CASTS.get(playerId);
        if (data != null) {
            ++data.ticksElapsed;
            if (data.ticksElapsed >= data.costInterval) {
                data.ticksElapsed = 0;
                if (magicData.getMana() >= (float)data.manaCost) {
                    CastSpellAction.setManaWithEvent(player, magicData, magicData.getMana() - (float)data.manaCost);
                    MedievalOrigins.LOGGER.info("Draining mana: " + data.manaCost + ". Remaining mana: " + magicData.getMana());
                } else {
                    Utils.serverSideCancelCast((ServerPlayer)player);
                    CONTINUOUS_CASTS.remove(playerId);
                }
            }
        }
    }

    private static void setManaWithEvent(ServerPlayer player, MagicData magicData, float newMana) {
        ChangeManaEvent event = new ChangeManaEvent((Player)player, magicData, magicData.getMana(), newMana);
        if (!MinecraftForge.EVENT_BUS.post((Event)event)) {
            magicData.setMana(event.getNewMana());
        }
    }

    public static void onSpellEnd(ServerPlayer player) {
        CONTINUOUS_CASTS.remove(player.m_20148_());
    }

    public static class Configuration
    implements IDynamicFeatureConfiguration {
        public static final Codec<Configuration> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)SerializableDataTypes.IDENTIFIER.fieldOf("spell").forGetter(Configuration::spell), (App)Codec.INT.optionalFieldOf("power_level", (Object)1).forGetter(Configuration::powerLevel), (App)Codec.INT.optionalFieldOf("cast_time").forGetter(Configuration::castTime), (App)Codec.INT.optionalFieldOf("mana_cost").forGetter(Configuration::manaCost), (App)Codec.BOOL.optionalFieldOf("continuous_cost", (Object)false).forGetter(Configuration::continuousCost), (App)Codec.INT.optionalFieldOf("cost_interval", (Object)20).forGetter(Configuration::costInterval)).apply((Applicative)instance, Configuration::new));
        private final ResourceLocation spell;
        private final int powerLevel;
        private final Optional<Integer> castTime;
        private final Optional<Integer> manaCost;
        private final boolean continuousCost;
        private final int costInterval;

        public Configuration(ResourceLocation spell, int powerLevel, Optional<Integer> castTime, Optional<Integer> manaCost, boolean continuousCost, int costInterval) {
            this.spell = spell;
            this.powerLevel = powerLevel;
            this.castTime = castTime;
            this.manaCost = manaCost;
            this.continuousCost = continuousCost;
            this.costInterval = costInterval;
        }

        public ResourceLocation spell() {
            return this.spell;
        }

        public int powerLevel() {
            return this.powerLevel;
        }

        public Optional<Integer> castTime() {
            return this.castTime;
        }

        public Optional<Integer> manaCost() {
            return this.manaCost;
        }

        public boolean continuousCost() {
            return this.continuousCost;
        }

        public int costInterval() {
            return this.costInterval;
        }
    }

    private static class ContinuousCastData {
        final int manaCost;
        final int costInterval;
        int ticksElapsed;

        ContinuousCastData(int manaCost, int costInterval, int ticksElapsed) {
            this.manaCost = manaCost;
            this.costInterval = costInterval;
            this.ticksElapsed = ticksElapsed;
        }
    }
}

