/*
 * Decompiled with CFR 0.152.
 */
package net.merchantpug.apugli.util;

import io.github.apace100.apoli.util.Space;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.util.Tuple;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector3f;

public class RaycastUtil {
    public static BlockHitResult raycastBlock(Entity actor, double dis) {
        return RaycastUtil.raycastBlock(actor, dis, null, Space.WORLD);
    }

    public static BlockHitResult raycastBlock(Entity actor, double dis, Vec3 direction, Space space) {
        Vec3 rayDir;
        Vec3 rayStart = actor.m_20299_(0.0f);
        if (direction == null) {
            rayDir = actor.m_20252_(0.0f).m_82490_(dis);
        } else {
            Vector3f vector3f = new Vector3f((float)direction.m_7096_(), (float)direction.m_7098_(), (float)direction.m_7094_()).normalize();
            space.toGlobal(vector3f, actor);
            rayDir = new Vec3((double)vector3f.x(), (double)vector3f.y(), (double)vector3f.z()).m_82490_(dis);
        }
        Vec3 rayEnd = rayStart.m_82549_(rayDir);
        ClipContext context = new ClipContext(rayStart, rayEnd, ClipContext.Block.OUTLINE, ClipContext.Fluid.NONE, actor);
        return actor.m_9236_().m_45547_(context);
    }

    public static EntityHitResult raycastEntity(BlockHitResult blockHitResult, Entity actor, double dis) {
        return RaycastUtil.raycastEntity(blockHitResult, actor, dis, null, Space.WORLD, null);
    }

    public static EntityHitResult raycastEntity(BlockHitResult blockHitResult, Entity actor, double dis, Vec3 direction, Space space, Predicate<Tuple<Entity, Entity>> predicate) {
        Vec3 rayDir;
        Vec3 rayStart = actor.m_20299_(0.0f);
        if (direction == null) {
            rayDir = actor.m_20252_(0.0f).m_82490_(dis);
        } else {
            Vector3f vector3f = new Vector3f((float)direction.m_7096_(), (float)direction.m_7098_(), (float)direction.m_7094_()).normalize();
            space.toGlobal(vector3f, actor);
            rayDir = new Vec3((double)vector3f.x(), (double)vector3f.y(), (double)vector3f.z()).m_82490_(dis);
        }
        Vec3 rayEnd = rayStart.m_82549_(rayDir);
        AABB entityBox = actor.m_20191_().m_82369_(rayDir).m_82400_(1.0);
        double blockHitDisSqr = blockHitResult != null ? blockHitResult.m_82425_().m_203202_(rayStart.f_82479_, rayStart.f_82480_, rayStart.f_82481_) : dis * dis;
        double disSqr = Math.min(blockHitDisSqr, dis * dis);
        return ProjectileUtil.m_37287_((Entity)actor, (Vec3)rayStart, (Vec3)rayEnd, (AABB)entityBox, traceEntity -> !traceEntity.m_5833_() && traceEntity.m_6087_() && (predicate == null || predicate.test(new Tuple((Object)actor, traceEntity))), (double)disSqr);
    }

    public static List<EntityHitResult> raycastEntities(Entity actor, Predicate<Entity> predicate, double dis, Vec3 direction, Space space) {
        Vec3 rayDir;
        Vec3 rayStart = actor.m_20299_(0.0f);
        if (direction == null) {
            rayDir = actor.m_20252_(0.0f).m_82490_(dis);
        } else {
            Vector3f vector3f = new Vector3f((float)direction.m_7096_(), (float)direction.m_7098_(), (float)direction.m_7094_()).normalize();
            space.toGlobal(vector3f, actor);
            rayDir = new Vec3((double)vector3f.x(), (double)vector3f.y(), (double)vector3f.z()).m_82490_(dis);
        }
        Vec3 rayEnd = rayStart.m_82549_(rayDir);
        AABB entityBox = actor.m_20191_().m_82369_(rayDir).m_82400_(1.0);
        ArrayList<EntityHitResult> results = new ArrayList<EntityHitResult>();
        Level level = actor.m_9236_();
        for (Entity target : level.m_6249_(actor, entityBox, predicate)) {
            double targetDis;
            AABB targetBB = target.m_20191_().m_82400_((double)target.m_6143_());
            Optional intersection = targetBB.m_82371_(rayStart, rayEnd);
            if (targetBB.m_82390_(rayStart)) {
                if (!(dis >= 0.0)) continue;
                results.add(new EntityHitResult(target, intersection.orElse(rayStart)));
                continue;
            }
            if (!intersection.isPresent() || !((targetDis = rayStart.m_82557_((Vec3)intersection.get())) < dis) && dis != 0.0) continue;
            if (target.m_20201_() == actor.m_20201_()) {
                if (dis != 0.0) continue;
                results.add(new EntityHitResult(target, (Vec3)intersection.get()));
                continue;
            }
            dis = targetDis;
            results.add(new EntityHitResult(target, (Vec3)intersection.get()));
        }
        return results;
    }
}

