/*
 * Decompiled with CFR 0.152.
 */
package net.merchantpug.apugli.util;

import net.minecraftforge.common.ForgeConfigSpec;
import org.apache.commons.lang3.tuple.Pair;

public class ApugliConfigs {
    public static final ForgeConfigSpec CLIENT_SPECS;
    public static final ForgeConfigSpec SERVER_SPECS;
    public static final Client CLIENT;
    public static final Server SERVER;

    static {
        Pair common = new ForgeConfigSpec.Builder().configure(Client::new);
        Pair server = new ForgeConfigSpec.Builder().configure(Server::new);
        CLIENT_SPECS = (ForgeConfigSpec)common.getRight();
        SERVER_SPECS = (ForgeConfigSpec)server.getRight();
        CLIENT = (Client)common.getLeft();
        SERVER = (Server)server.getLeft();
    }

    public static class Client {
        public final FileDownloadOptions fileDownloadOptions;

        public Client(ForgeConfigSpec.Builder builder) {
            builder.push("fileDownload");
            this.fileDownloadOptions = new FileDownloadOptions(builder);
            builder.pop();
        }

        public static class FileDownloadOptions {
            private final ForgeConfigSpec.ConfigValue<String> fileSizeLimit;
            private final ForgeConfigSpec.IntValue fileConnectionTimeout;

            public FileDownloadOptions(ForgeConfigSpec.Builder builder) {
                this.fileSizeLimit = builder.translation("apugli.config.fileSizeLimit").define("fileSizeLimit", (Object)"1MB");
                this.fileConnectionTimeout = builder.translation("apugli.config.fileConnectionTimeout").defineInRange("fileConnectionTimeout", 30000, 1, Integer.MAX_VALUE);
            }

            public String getFileSizeLimit() {
                return (String)this.fileSizeLimit.get();
            }

            public int getFileConnectionTimeout() {
                return (Integer)this.fileConnectionTimeout.get();
            }
        }
    }

    public static class Server {
        public final HitsOnTargetOptions hitsOnTargetOptions;

        public Server(ForgeConfigSpec.Builder builder) {
            builder.push("hitsOnTarget");
            this.hitsOnTargetOptions = new HitsOnTargetOptions(builder);
            builder.pop();
        }

        public static class HitsOnTargetOptions {
            private final ForgeConfigSpec.IntValue resetTimerTicks;

            public HitsOnTargetOptions(ForgeConfigSpec.Builder builder) {
                this.resetTimerTicks = builder.translation("apugli.config.resetTimerTicks").defineInRange("resetTimerTicks", 100, 0, Integer.MAX_VALUE);
            }

            public int getResetTimerTicks() {
                return (Integer)this.resetTimerTicks.get();
            }
        }
    }
}

