/*
 * Decompiled with CFR 0.152.
 */
package net.merchantpug.apugli.power.factory;

import io.github.apace100.calio.data.SerializableData;
import io.github.apace100.calio.data.SerializableDataTypes;
import net.merchantpug.apugli.platform.Services;
import net.merchantpug.apugli.power.factory.CooldownPowerFactory;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.Projectile;

public interface ProjectileHitActionPowerFactory<P>
extends CooldownPowerFactory<P> {
    public static SerializableData getSerializableData() {
        return CooldownPowerFactory.getSerializableData().add("bientity_action", Services.ACTION.biEntityDataType(), null).add("bientity_condition", Services.CONDITION.biEntityDataType(), null).add("owner_bientity_action", Services.ACTION.biEntityDataType(), null).add("owner_bientity_condition", Services.CONDITION.biEntityDataType(), null).add("stop_after", SerializableDataTypes.INT, (Object)1);
    }

    default public void execute(P power, LivingEntity powerHolder, Entity attacker, Entity target, Projectile projectile, int amountHit) {
        SerializableData.Instance data = this.getDataFromPower(power);
        if (this.canUse(power, (Entity)powerHolder) && Services.CONDITION.checkBiEntity(data, "bientity_condition", (Entity)projectile, target) && Services.CONDITION.checkBiEntity(data, "owner_bientity_condition", attacker, target)) {
            Services.ACTION.executeBiEntity(data, "bientity_action", (Entity)projectile, target);
            Services.ACTION.executeBiEntity(data, "owner_bientity_action", attacker, target);
            if (amountHit >= data.getInt("stop_after")) {
                this.use(power, (Entity)powerHolder);
            }
        }
    }
}

