/*
 * Decompiled with CFR 0.152.
 */
package net.merchantpug.apugli.power.factory;

import io.github.apace100.calio.data.SerializableData;
import io.github.apace100.calio.data.SerializableDataTypes;
import net.merchantpug.apugli.mixin.xplatform.client.accessor.GameRendererAccessor;
import net.merchantpug.apugli.platform.Services;
import net.merchantpug.apugli.power.factory.ValueModifyingPowerFactory;
import net.merchantpug.apugli.registry.power.ApugliPowers;
import net.merchantpug.apugli.util.FOVUtil;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;

public interface ModifyFovPowerFactory<P>
extends ValueModifyingPowerFactory<P> {
    public static SerializableData getSerializableData() {
        return ValueModifyingPowerFactory.getSerializableData().add("change_divisor", SerializableDataTypes.FLOAT, (Object)Float.valueOf(1.0f));
    }

    default public double getFov(double originalFov, Camera activeRenderInfo, LivingEntity living) {
        double d = Mth.m_14179_((float)Minecraft.m_91087_().m_91296_(), (float)((GameRendererAccessor)Minecraft.m_91087_().f_91063_).apugli$getOldFov(), (float)((GameRendererAccessor)Minecraft.m_91087_().f_91063_).apugli$getFov());
        if (Services.POWER.hasPower(living, this)) {
            if (!Minecraft.m_91087_().m_91104_()) {
                float changeDivisor = Services.POWER.getPowers(living, this).stream().map(p -> Float.valueOf(this.getDataFromPower(p).getFloat("change_divisor"))).reduce((a, b) -> Float.valueOf(a.floatValue() * b.floatValue())).get().floatValue();
                this.setPartialTicks(this.getPartialTicks() + (double)Minecraft.m_91087_().m_91297_() * (this.getCurrentFovMultiplier() / this.getPreviousFovMultiplier() + 1.0) / (double)changeDivisor);
                this.setPreviousChangeDivisor(changeDivisor);
            }
            if (!this.hasPreviousValue() || this.getPreviousFovEffectScale() != ((Double)Minecraft.m_91087_().f_91066_.m_231925_().m_231551_()).doubleValue()) {
                double currentFov = Services.PLATFORM.applyModifiers(living, this, originalFov) / d / (double)((Integer)Minecraft.m_91087_().f_91066_.m_231837_().m_231551_()).intValue();
                this.setPreviousFovMultiplier(originalFov / d / (double)((Integer)Minecraft.m_91087_().f_91066_.m_231837_().m_231551_()).intValue());
                this.setCurrentFovMultiplier(currentFov);
                this.setPartialTicks(0.0);
                this.setPreviousFovEffectScale((Double)Minecraft.m_91087_().f_91066_.m_231925_().m_231551_());
            } else if (this.getPartialTicks() >= 1.0) {
                double currentFov = Services.PLATFORM.applyModifiers(living, this, originalFov) / d / (double)((Integer)Minecraft.m_91087_().f_91066_.m_231837_().m_231551_()).intValue();
                this.setPreviousFovMultiplier(this.getCurrentFovMultiplier());
                this.setCurrentFovMultiplier(currentFov);
                this.setPartialTicks(0.0);
            }
            double lerpedFovMultiplier = ApugliPowers.MODIFY_FOV.get().getLerpedFovMultiplier();
            this.setHadPowerPreviously(true);
            this.setHasResetPreviousValue(false);
            return FOVUtil.redoModifications(originalFov, activeRenderInfo, this.getPartialTicks()) * Mth.m_14139_((double)((Double)Minecraft.m_91087_().f_91066_.m_231925_().m_231551_()), (double)1.0, (double)Mth.m_14008_((double)lerpedFovMultiplier, (double)0.1, (double)1.5));
        }
        if (!Services.POWER.hasPower(living, this) && this.hadPowerPreviously()) {
            if (!Minecraft.m_91087_().m_91104_()) {
                this.setPartialTicks(this.getPartialTicks() + (double)Minecraft.m_91087_().m_91297_() * (1.0 / this.getPreviousFovMultiplier() + 1.0) / (double)this.getPreviousChangeDivisor());
            }
            if (!this.hasResetPreviousValue()) {
                this.setPreviousFovMultiplier(this.getLerpedFovMultiplier());
                this.setPartialTicks(0.0);
                this.setHasResetPreviousValue(true);
            }
            double lerpedFovMultiplier = Mth.m_14139_((double)Mth.m_14008_((double)this.getPartialTicks(), (double)0.0, (double)1.0), (double)this.getPreviousFovMultiplier(), (double)1.0);
            if (this.getPartialTicks() > 1.0) {
                this.setHadPowerPreviously(false);
                this.setPreviousFovMultiplier(Double.NaN);
                this.setPartialTicks(0.0);
            }
            return FOVUtil.redoModifications(originalFov, activeRenderInfo, this.getPartialTicks()) * Mth.m_14139_((double)((Double)Minecraft.m_91087_().f_91066_.m_231925_().m_231551_()), (double)1.0, (double)Mth.m_14008_((double)lerpedFovMultiplier, (double)0.1, (double)1.5));
        }
        return originalFov;
    }

    default public boolean hasPreviousValue() {
        return !Double.isNaN(this.getPreviousFovMultiplier());
    }

    default public double getLerpedFovMultiplier() {
        return Mth.m_14139_((double)Mth.m_14008_((double)this.getPartialTicks(), (double)0.0, (double)1.0), (double)this.getPreviousFovMultiplier(), (double)this.getCurrentFovMultiplier());
    }

    public boolean hasResetPreviousValue();

    public void setHasResetPreviousValue(boolean var1);

    public boolean hadPowerPreviously();

    public void setHadPowerPreviously(boolean var1);

    public double getPreviousFovMultiplier();

    public void setPreviousFovMultiplier(double var1);

    public double getCurrentFovMultiplier();

    public void setCurrentFovMultiplier(double var1);

    public double getPartialTicks();

    public void setPartialTicks(double var1);

    public float getPreviousChangeDivisor();

    public void setPreviousChangeDivisor(float var1);

    public double getPreviousFovEffectScale();

    public void setPreviousFovEffectScale(double var1);
}

