/*
 * Decompiled with CFR 0.152.
 */
package net.merchantpug.apugli.power.factory;

import io.github.apace100.calio.data.SerializableData;
import io.github.apace100.calio.data.SerializableDataTypes;
import java.util.List;
import net.merchantpug.apugli.platform.Services;
import net.merchantpug.apugli.power.factory.ValueModifyingPowerFactory;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;

public interface ModifyEnchantmentDamagePowerFactory<P>
extends ValueModifyingPowerFactory<P> {
    public static SerializableData getSerializableData() {
        return ValueModifyingPowerFactory.getSerializableData().add("enchantment", SerializableDataTypes.ENCHANTMENT).add("base_value", SerializableDataTypes.FLOAT).add("damage_condition", Services.CONDITION.damageDataType(), null).add("bientity_condition", Services.CONDITION.biEntityDataType(), null).add("bientity_action", Services.ACTION.biEntityDataType(), null);
    }

    default public boolean doesApply(P power, DamageSource source, float damageAmount, LivingEntity attacker, LivingEntity target) {
        SerializableData.Instance data = this.getDataFromPower(power);
        return Services.CONDITION.checkDamage(data, "damage_condition", source, damageAmount) && Services.CONDITION.checkBiEntity(data, "bientity_condition", (Entity)attacker, (Entity)target) && EnchantmentHelper.m_44843_((Enchantment)((Enchantment)data.get("enchantment")), (ItemStack)attacker.m_6844_(EquipmentSlot.MAINHAND)) != 0;
    }

    default public float applyModifiers(LivingEntity powerHolder, DamageSource source, float originalAmount, LivingEntity attacker, LivingEntity target) {
        float additionalValue = 0.0f;
        List<Object> modifyingPowers = Services.POWER.getPowers(powerHolder, this).stream().filter(p -> this.doesApply(p, source, originalAmount, attacker, target)).toList();
        for (Object power : modifyingPowers) {
            SerializableData.Instance data = this.getDataFromPower(power);
            if (EnchantmentHelper.m_44843_((Enchantment)((Enchantment)data.get("enchantment")), (ItemStack)attacker.m_6844_(EquipmentSlot.MAINHAND)) == 0) continue;
            additionalValue += data.getFloat("base_value");
            for (int i = 0; i < Math.max(0, EnchantmentHelper.m_44843_((Enchantment)((Enchantment)data.get("enchantment")), (ItemStack)attacker.m_6844_(EquipmentSlot.MAINHAND)) - 1); ++i) {
                additionalValue = (float)Services.PLATFORM.applyModifiers(powerHolder, this, (double)additionalValue);
                Services.ACTION.executeBiEntity(data, "bientity_action", (Entity)attacker, (Entity)target);
            }
        }
        return additionalValue;
    }
}

