/*
 * Decompiled with CFR 0.152.
 */
package net.merchantpug.apugli.power.factory;

import io.github.apace100.apoli.data.ApoliDataTypes;
import io.github.apace100.apoli.util.Comparison;
import io.github.apace100.calio.data.SerializableData;
import io.github.apace100.calio.data.SerializableDataType;
import io.github.apace100.calio.data.SerializableDataTypes;
import java.util.Map;
import net.merchantpug.apugli.data.ApugliDataTypes;
import net.merchantpug.apugli.platform.Services;
import net.merchantpug.apugli.power.factory.ValueModifyingPowerFactory;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public interface ModifyDurabilityChangePowerFactory<P>
extends ValueModifyingPowerFactory<P> {
    public static SerializableData getSerializableData() {
        return ValueModifyingPowerFactory.getSerializableData().add("item_condition", Services.CONDITION.itemDataType(), null).add("comparison", ApoliDataTypes.COMPARISON, (Object)Comparison.GREATER_THAN_OR_EQUAL).add("compare_to", SerializableDataTypes.INT, (Object)Integer.MIN_VALUE).add("comparisons", ApugliDataTypes.comparisonMap(SerializableDataTypes.INT), Map.of()).add("function", SerializableDataType.enumValue(Function.class), (Object)Function.FLOOR);
    }

    default public int postFunction(P power, double value) {
        SerializableData.Instance data = this.getDataFromPower(power);
        int retVal = switch ((Function)((Object)data.get("function"))) {
            case Function.CEILING -> Mth.m_14040_((int)Mth.m_14165_((double)value));
            case Function.ROUND -> (int)Mth.m_14154_((float)Math.round(value));
            default -> Mth.m_14040_((int)Mth.m_14107_((double)value));
        };
        if (value < 0.0) {
            retVal = -retVal;
        }
        return retVal;
    }

    default public boolean doesApply(P power, Level level, ItemStack stack, int durabilityChange) {
        SerializableData.Instance data = this.getDataFromPower(power);
        return Services.CONDITION.checkItem(data, "item_condition", level, stack) && this.checkComparisons(data, durabilityChange);
    }

    default public boolean checkComparisons(SerializableData.Instance data, int durabilityChange) {
        for (Map.Entry entry : ((Map)data.get("comparisons")).entrySet()) {
            if (((Comparison)entry.getKey()).compare((double)durabilityChange, (double)((Integer)entry.getValue()).intValue())) continue;
            return false;
        }
        return ((Comparison)data.get("comparison")).compare((double)durabilityChange, (double)data.getInt("compare_to"));
    }

    public static enum Function {
        FLOOR,
        ROUND,
        CEILING;

    }
}

