/*
 * Decompiled with CFR 0.152.
 */
package net.merchantpug.apugli.power.factory;

import io.github.apace100.calio.data.SerializableData;
import io.github.apace100.calio.data.SerializableDataTypes;
import java.util.ArrayList;
import java.util.List;
import net.merchantpug.apugli.platform.Services;
import net.merchantpug.apugli.power.factory.CooldownPowerFactory;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public interface DamageNearbyPowerFactory<P>
extends CooldownPowerFactory<P> {
    public static SerializableData getSerializableData() {
        return CooldownPowerFactory.getSerializableData().add("damage_condition", Services.CONDITION.damageDataType(), null).add("damage_type", SerializableDataTypes.DAMAGE_TYPE, null).add("source", Services.PLATFORM.damageSourceDescriptionDataType(), null).add("modifier", Services.PLATFORM.getModifierDataType(), null).add("modifiers", Services.PLATFORM.getModifiersDataType(), null).add("radius", SerializableDataTypes.FLOAT, (Object)Float.valueOf(16.0f));
    }

    default public void execute(P power, LivingEntity powerHolder, DamageSource damageSource, float damageAmount, @Nullable Entity attacker, LivingEntity target, String attackerName, String targetName, boolean damagerIsAttacker) {
        SerializableData.Instance data = this.getDataFromPower(power);
        if (this.canUse(power, (Entity)powerHolder) && (!data.isPresent("damage_condition") || Services.CONDITION.checkDamage(data, "damage_condition", damageSource, damageAmount)) && (!data.isPresent(attackerName + "_" + targetName + "_bientity_condition") || attacker != null && Services.CONDITION.checkBiEntity(data, attackerName + "_" + targetName + "_bientity_condition", attacker, (Entity)target))) {
            float radius = data.getFloat("radius");
            List<Object> modifiers = new ArrayList();
            if (data.isPresent("modifiers")) {
                modifiers = (List)data.get("modifiers");
            }
            if (data.isPresent("modifier")) {
                modifiers.add(data.get("modifier"));
            }
            for (LivingEntity nearby : target.m_9236_().m_45976_(LivingEntity.class, AABB.m_165882_((Vec3)target.m_20318_(1.0f), (double)radius, (double)radius, (double)radius))) {
                if (nearby == attacker || nearby == target || (attacker != null || data.isPresent(attackerName + "_" + targetName + "_bientity_condition")) && !Services.CONDITION.checkBiEntity(data, attackerName + "_nearby_bientity_condition", attacker, (Entity)nearby) || !Services.CONDITION.checkBiEntity(data, targetName + "_nearby_bientity_condition", (Entity)target, (Entity)nearby)) continue;
                if (attacker != null) {
                    nearby.m_6469_(Services.PLATFORM.createDamageSource(target.m_269291_(), data, (Entity)(damagerIsAttacker ? attacker : powerHolder), "damage_type", "source"), (float)Services.PLATFORM.applyModifiers((Entity)powerHolder, modifiers, (double)damageAmount));
                    if (data.isPresent(attackerName + "_" + targetName + "_bientity_action")) {
                        Services.ACTION.executeBiEntity(data, attackerName + "_" + targetName + "_bientity_action", attacker, (Entity)target);
                    }
                    if (data.isPresent(attackerName + "_nearby_bientity_action")) {
                        Services.ACTION.executeBiEntity(data, attackerName + "_nearby_bientity_action", (Entity)target, (Entity)nearby);
                    }
                } else {
                    nearby.m_6469_(Services.PLATFORM.createDamageSource(target.m_269291_(), data, "damage_type", "source"), (float)Services.PLATFORM.applyModifiers((Entity)powerHolder, modifiers, (double)damageAmount));
                }
                if (!data.isPresent(targetName + "_nearby_bientity_action")) continue;
                Services.ACTION.executeBiEntity(data, targetName + "_nearby_bientity_action", (Entity)target, (Entity)nearby);
            }
            this.use(power, (Entity)powerHolder);
        }
    }
}

