/*
 * Decompiled with CFR 0.152.
 */
package net.merchantpug.apugli.power.factory;

import io.github.apace100.calio.data.SerializableData;
import io.github.apace100.calio.data.SerializableDataTypes;
import net.merchantpug.apugli.platform.Services;
import net.merchantpug.apugli.power.factory.ResourcePowerFactory;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.Vec3;

public interface BunnyHopPowerFactory<P>
extends ResourcePowerFactory<P> {
    public static SerializableData getSerializableData() {
        return ResourcePowerFactory.getSerializableData().add("increase_per_tick", SerializableDataTypes.FLOAT, (Object)Float.valueOf(3.75E-4f)).add("tick_rate", SerializableDataTypes.INT, (Object)10);
    }

    default public void reset(P power, LivingEntity entity) {
        if (this.getValue(power, (Entity)entity) != 0) {
            this.assign(power, (Entity)entity, 0);
            this.sync(entity, power);
        }
    }

    default public void onTravel(LivingEntity entity, Vec3 movementInput) {
        if (!this.canGainResource(entity)) {
            return;
        }
        Services.POWER.getPowers(entity, this).forEach(power -> {
            SerializableData.Instance data = this.getDataFromPower(power);
            int tickRate = Math.max(1, data.getInt("tick_rate"));
            if (!entity.m_9236_().f_46443_ && entity.f_19797_ % tickRate == 0) {
                int value = this.getValue(power, (Entity)entity);
                if (this.increment(power, (Entity)entity) != value) {
                    this.sync(entity, power);
                }
            }
            entity.m_19920_(data.getFloat("increase_per_tick") * (float)this.getValue(power, (Entity)entity), movementInput);
        });
    }

    default public boolean canGainResource(LivingEntity entity) {
        return !entity.m_20096_() && !entity.m_20069_() && !entity.m_20077_() && !entity.m_20159_() && !entity.m_21255_();
    }
}

