/*
 * Decompiled with CFR 0.152.
 */
package net.merchantpug.apugli.power;

import io.github.apace100.apoli.power.Power;
import io.github.apace100.apoli.power.PowerType;
import io.github.apace100.calio.data.SerializableData;
import io.github.apace100.calio.data.SerializableDataType;
import io.github.apace100.calio.data.SerializableDataTypes;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.merchantpug.apugli.platform.Services;
import net.merchantpug.apugli.power.factory.SimplePowerFactory;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.util.Tuple;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import org.apache.commons.lang3.tuple.Triple;

public class ModifyBlockPlacedPower
extends Power {
    private final List<BlockState> blockStates = new ArrayList<BlockState>();
    public final Predicate<Tuple<Level, ItemStack>> itemCondition;
    private final Consumer<Triple<Level, BlockPos, Direction>> blockAction;
    private int seed = (int)(Math.random() * 2.147483647E9);

    public ModifyBlockPlacedPower(PowerType<?> type, LivingEntity entity, Predicate<Tuple<Level, ItemStack>> itemCondition, Consumer<Triple<Level, BlockPos, Direction>> blockAction) {
        super(type, entity);
        this.itemCondition = itemCondition;
        this.blockAction = blockAction;
    }

    public void fromTag(Tag tag) {
        if (!(tag instanceof CompoundTag)) {
            return;
        }
        this.seed = ((CompoundTag)tag).m_128451_("Seed");
    }

    public Tag toTag() {
        CompoundTag nbt = new CompoundTag();
        nbt.m_128405_("Seed", this.seed);
        return nbt;
    }

    public int getSeed() {
        return this.seed;
    }

    public void generateSeed() {
        if (!(this.entity instanceof Player)) {
            return;
        }
        if (!this.entity.m_9236_().m_5776_()) {
            this.seed = (int)(Math.random() * 2.147483647E9);
            Services.POWER.syncPower(this.entity, this.getType());
        }
    }

    public void executeAction(Optional<BlockPos> placedBlockPos) {
        if (placedBlockPos.isEmpty() || this.blockAction == null) {
            return;
        }
        this.blockAction.accept((Triple<Level, BlockPos, Direction>)Triple.of((Object)this.entity.m_9236_(), (Object)placedBlockPos.get(), (Object)Direction.UP));
    }

    public void addBlockState(BlockState blockState) {
        this.blockStates.add(blockState);
    }

    public List<BlockState> getBlockStates() {
        return this.blockStates;
    }

    public static class Factory
    extends SimplePowerFactory<ModifyBlockPlacedPower> {
        public Factory() {
            super("modify_block_placed", new SerializableData().add("block", SerializableDataTypes.BLOCK, null).add("block_state", SerializableDataTypes.BLOCK_STATE, null).add("blocks", SerializableDataType.list((SerializableDataType)SerializableDataTypes.BLOCK), null).add("block_states", SerializableDataType.list((SerializableDataType)SerializableDataTypes.BLOCK_STATE), null).add("block_action", Services.ACTION.blockDataType(), null).add("item_condition", Services.CONDITION.itemDataType()), data -> (type, entity) -> {
                ModifyBlockPlacedPower power = new ModifyBlockPlacedPower((PowerType<?>)type, (LivingEntity)entity, Services.CONDITION.itemPredicate((SerializableData.Instance)data, "item_condition"), Services.ACTION.blockConsumer((SerializableData.Instance)data, "block_action"));
                data.ifPresent("block", block -> power.addBlockState(block.m_49966_()));
                data.ifPresent("block_state", power::addBlockState);
                data.ifPresent("blocks", blocks -> blocks.forEach(block -> power.addBlockState(block.m_49966_())));
                data.ifPresent("block_states", states -> states.forEach(power::addBlockState));
                return power;
            });
            this.allowCondition();
        }

        @Override
        public Class<ModifyBlockPlacedPower> getPowerClass() {
            return ModifyBlockPlacedPower.class;
        }
    }
}

