/*
 * Decompiled with CFR 0.152.
 */
package net.merchantpug.apugli.power;

import com.google.auto.service.AutoService;
import com.mojang.serialization.Codec;
import io.github.edwinmindcraft.apoli.api.ApoliAPI;
import io.github.edwinmindcraft.apoli.api.component.IPowerContainer;
import io.github.edwinmindcraft.apoli.api.power.configuration.ConfiguredPower;
import net.merchantpug.apugli.power.AbstractActiveCooldownPower;
import net.merchantpug.apugli.power.configuration.FabricActiveCooldownConfiguration;
import net.merchantpug.apugli.power.factory.CustomProjectilePowerFactory;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import org.jetbrains.annotations.Nullable;

@AutoService(value={CustomProjectilePowerFactory.class})
public class CustomProjectilePower
extends AbstractActiveCooldownPower
implements CustomProjectilePowerFactory<ConfiguredPower<FabricActiveCooldownConfiguration, ?>> {
    public CustomProjectilePower() {
        super((Codec<FabricActiveCooldownConfiguration>)CustomProjectilePowerFactory.getSerializableData().xmap(FabricActiveCooldownConfiguration::new, FabricActiveCooldownConfiguration::data).codec());
        this.ticking();
    }

    protected DataContainer access(ConfiguredPower<FabricActiveCooldownConfiguration, ?> configuration, IPowerContainer container) {
        return (DataContainer)configuration.getPowerData(container, DataContainer::new);
    }

    @Override
    public void execute(ConfiguredPower<FabricActiveCooldownConfiguration, ?> power, Entity entity) {
        this.setFiringProjectiles(power, entity, true);
    }

    public void tick(ConfiguredPower<FabricActiveCooldownConfiguration, ?> configuration, Entity entity) {
        if (entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            CustomProjectilePowerFactory.super.tick(configuration, living);
        }
    }

    public void serialize(ConfiguredPower<FabricActiveCooldownConfiguration, ?> configuration, IPowerContainer container, CompoundTag tag) {
        this.access(configuration, container).serialize(tag);
    }

    public void deserialize(ConfiguredPower<FabricActiveCooldownConfiguration, ?> configuration, IPowerContainer container, CompoundTag tag) {
        this.access(configuration, container).deserialize(tag);
    }

    @Override
    public ResourceLocation getPowerId(ConfiguredPower<FabricActiveCooldownConfiguration, ?> power) {
        return power.getRegistryName();
    }

    protected long getLastUseTime(ConfiguredPower<FabricActiveCooldownConfiguration, ?> configuration, @Nullable IPowerContainer container) {
        return container != null ? this.access(configuration, (IPowerContainer)container).lastUseTime : Long.MAX_VALUE;
    }

    protected void setLastUseTime(ConfiguredPower<FabricActiveCooldownConfiguration, ?> configuration, @Nullable IPowerContainer container, long value) {
        if (container != null) {
            this.access(configuration, (IPowerContainer)container).lastUseTime = value;
        }
    }

    @Override
    public int getShotProjectiles(ConfiguredPower<FabricActiveCooldownConfiguration, ?> power, Entity entity) {
        return this.access(power, (IPowerContainer)ApoliAPI.getPowerContainer((Entity)entity)).shotProjectiles;
    }

    @Override
    public boolean isFiringProjectiles(ConfiguredPower<FabricActiveCooldownConfiguration, ?> power, Entity entity) {
        return this.access(power, (IPowerContainer)ApoliAPI.getPowerContainer((Entity)entity)).isFiringProjectiles;
    }

    @Override
    public boolean finishedStartDelay(ConfiguredPower<FabricActiveCooldownConfiguration, ?> power, Entity entity) {
        return this.access(power, (IPowerContainer)ApoliAPI.getPowerContainer((Entity)entity)).finishedStartDelay;
    }

    @Override
    public void setShotProjectiles(ConfiguredPower<FabricActiveCooldownConfiguration, ?> power, Entity entity, int value) {
        this.access(power, (IPowerContainer)ApoliAPI.getPowerContainer((Entity)entity)).shotProjectiles = value;
    }

    @Override
    public void setFiringProjectiles(ConfiguredPower<FabricActiveCooldownConfiguration, ?> power, Entity entity, boolean value) {
        this.access(power, (IPowerContainer)ApoliAPI.getPowerContainer((Entity)entity)).isFiringProjectiles = value;
    }

    @Override
    public void setFinishedStartDelay(ConfiguredPower<FabricActiveCooldownConfiguration, ?> power, Entity entity, boolean value) {
        this.access(power, (IPowerContainer)ApoliAPI.getPowerContainer((Entity)entity)).finishedStartDelay = value;
    }

    @Override
    public long getLastUseTime(ConfiguredPower<FabricActiveCooldownConfiguration, ?> power, Entity entity) {
        return super.getLastUseTime(power, entity);
    }

    private static class DataContainer {
        private long lastUseTime = Long.MIN_VALUE;
        private int shotProjectiles;
        private boolean finishedStartDelay;
        private boolean isFiringProjectiles;

        private DataContainer() {
        }

        public void serialize(CompoundTag tag) {
            tag.m_128356_("LastUseTime", this.lastUseTime);
            tag.m_128405_("ShotProjectiles", this.shotProjectiles);
            tag.m_128379_("FinishedStartDelay", this.finishedStartDelay);
            tag.m_128379_("IsFiringProjectiles", this.isFiringProjectiles);
        }

        public void deserialize(CompoundTag tag) {
            this.lastUseTime = tag.m_128454_("LastUseTime");
            this.shotProjectiles = tag.m_128451_("ShotProjectiles");
            this.finishedStartDelay = tag.m_128471_("FinishedStartDelay");
            this.isFiringProjectiles = tag.m_128471_("IsFiringProjectiles");
        }
    }
}

