/*
 * Decompiled with CFR 0.152.
 */
package net.merchantpug.apugli.power;

import io.github.apace100.apoli.power.Power;
import io.github.apace100.apoli.power.PowerType;
import io.github.apace100.calio.data.SerializableData;
import java.util.HashMap;
import java.util.Map;
import net.merchantpug.apugli.platform.Services;
import net.merchantpug.apugli.power.factory.SimplePowerFactory;
import net.merchantpug.apugli.registry.power.ApugliPowers;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.player.Player;

public class CrawlingPower
extends Power {
    private static final Map<Entity, Boolean> WAS_ACTIVE = new HashMap<Entity, Boolean>();

    public CrawlingPower(PowerType<?> type, LivingEntity entity) {
        super(type, entity);
    }

    public static void tickOnceForge(Player player) {
        if (!WAS_ACTIVE.containsKey(player)) {
            return;
        }
        if (player.m_21255_() || player.m_5803_() || player.m_21209_()) {
            if (CrawlingPower.wasActive(player)) {
                Services.PLATFORM.setForcedPlayerPose(player, null);
                CrawlingPower.setWasActive(player, false);
            }
            return;
        }
        if (!CrawlingPower.wasActive(player) && Services.PLATFORM.canSetPose(player) && Services.POWER.hasPower((LivingEntity)player, ApugliPowers.CRAWLING.get()) && (player.m_217003_(Pose.STANDING) || player.m_217003_(Pose.CROUCHING))) {
            Services.PLATFORM.setForcedPlayerPose(player, Pose.SWIMMING);
            CrawlingPower.setWasActive(player, true);
        } else if (CrawlingPower.wasActive(player) && !Services.POWER.hasPower((LivingEntity)player, ApugliPowers.CRAWLING.get())) {
            Services.PLATFORM.setForcedPlayerPose(player, null);
            CrawlingPower.setWasActive(player, false);
        }
    }

    public void onAdded() {
        Player player;
        LivingEntity livingEntity = this.entity;
        if (livingEntity instanceof Player && !WAS_ACTIVE.containsKey(player = (Player)livingEntity)) {
            WAS_ACTIVE.put((Entity)player, false);
        }
    }

    public void onRemoved() {
        boolean wasActive;
        Player player;
        LivingEntity livingEntity = this.entity;
        if (livingEntity instanceof Player && Services.POWER.getPowers((LivingEntity)(player = (Player)livingEntity), ApugliPowers.CRAWLING.get()).size() - 1 <= 0 && (wasActive = WAS_ACTIVE.remove(player).booleanValue())) {
            Services.PLATFORM.setForcedPlayerPose(player, null);
        }
    }

    private static void setWasActive(Player player, boolean value) {
        WAS_ACTIVE.put((Entity)player, value);
    }

    public static boolean wasActive(Player player) {
        return WAS_ACTIVE.get(player);
    }

    public static class Factory
    extends SimplePowerFactory<CrawlingPower> {
        public Factory() {
            super("crawling", new SerializableData(), data -> CrawlingPower::new);
            this.allowCondition();
        }

        @Override
        public Class<CrawlingPower> getPowerClass() {
            return CrawlingPower.class;
        }
    }
}

