/*
 * Decompiled with CFR 0.152.
 */
package net.merchantpug.apugli.platform.services;

import io.github.apace100.apoli.power.Power;
import io.github.apace100.apoli.power.PowerType;
import io.github.apace100.apoli.power.factory.PowerFactory;
import io.github.apace100.calio.data.SerializableData;
import io.github.apace100.calio.data.SerializableDataType;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.merchantpug.apugli.power.factory.SimplePowerFactory;
import net.merchantpug.apugli.power.factory.SpecialPowerFactory;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;

public interface IPowerHelper<T> {
    public Object unwrapSimpleFactory(PowerFactory<?> var1);

    public <F extends SimplePowerFactory<?>> Supplier<F> registerFactory(F var1);

    public <F extends SpecialPowerFactory<?>> Supplier<F> registerFactory(String var1, Class<F> var2);

    public <P> P getPowerFromType(LivingEntity var1, PowerType<?> var2);

    public <P extends Power> List<P> getPowers(LivingEntity var1, SimplePowerFactory<P> var2);

    public <P extends Power> List<P> getPowers(LivingEntity var1, SimplePowerFactory<P> var2, boolean var3);

    public <P> List<P> getPowers(LivingEntity var1, SpecialPowerFactory<P> var2);

    public <P> List<P> getPowers(LivingEntity var1, SpecialPowerFactory<P> var2, boolean var3);

    public <P extends Power> boolean hasPower(LivingEntity var1, SimplePowerFactory<P> var2);

    public <P> boolean hasPower(LivingEntity var1, SpecialPowerFactory<P> var2);

    public SerializableDataType<T> getPowerTypeDataType();

    public <P> boolean isActive(P var1, LivingEntity var2);

    public void syncPower(LivingEntity var1, PowerType<?> var2);

    public <P> void syncPower(LivingEntity var1, P var2);

    public OptionalInt getResource(LivingEntity var1, T var2);

    default public OptionalInt getResource(LivingEntity entity, SerializableData.Instance data, String fieldName) {
        return this.getResource(entity, data.get(fieldName));
    }

    public OptionalInt setResource(LivingEntity var1, T var2, int var3);

    default public OptionalInt setResource(LivingEntity entity, SerializableData.Instance data, String fieldName, int value) {
        return this.setResource(entity, data.get(fieldName), value);
    }

    public <P> ResourceLocation getPowerFromParameter(P var1);

    public <P> ResourceLocation getPowerId(P var1);

    public <P> P getPowerFromId(Entity var1, ResourceLocation var2);

    default public <P extends Power> P getPowerFromId(ResourceLocation powerId, SimplePowerFactory<P> factory, LivingEntity living, boolean includeInactive) {
        Optional<Power> optional = this.getPowers(living, factory, includeInactive).stream().filter(p -> this.getPowerId(p).equals((Object)powerId)).findFirst();
        return (P)((Power)optional.orElse(null));
    }

    @Nullable
    default public <P> P getPowerFromId(ResourceLocation powerId, SpecialPowerFactory<P> factory, LivingEntity living, boolean includeInactive) {
        Optional<Object> optional = this.getPowers(living, factory, includeInactive).stream().filter(p -> this.getPowerId(p).equals((Object)powerId)).findFirst();
        return optional.orElse(null);
    }

    public void grantPower(ResourceLocation var1, ResourceLocation var2, LivingEntity var3);

    public void revokePower(ResourceLocation var1, ResourceLocation var2, LivingEntity var3);

    public boolean hasPowerType(ResourceLocation var1, ResourceLocation var2, LivingEntity var3);

    public Map<ResourceLocation, Double> iterateThroughModifierForResources(LivingEntity var1, List<?> var2);

    public Map<Integer, Map<ResourceLocation, Double>> getInBetweenResources(LivingEntity var1, List<?> var2, List<?> var3, double var4, Map<ResourceLocation, Double> var6);

    public double addAllInBetweensOfResourceModifiers(LivingEntity var1, List<?> var2, List<?> var3, double var4, Map<ResourceLocation, Double> var6);

    public double applyModifierWithSpecificValueAtIndex(LivingEntity var1, List<?> var2, double var3, Map<ResourceLocation, Double> var5);

    public Map<ResourceLocation, Double> getClosestToBaseScale(LivingEntity var1, List<?> var2, double var3);
}

