/*
 * Decompiled with CFR 0.152.
 */
package net.merchantpug.apugli.network.s2c;

import io.github.edwinmindcraft.apoli.api.ApoliAPI;
import io.github.edwinmindcraft.apoli.api.component.IPowerContainer;
import io.github.edwinmindcraft.apoli.api.power.configuration.ConfiguredPower;
import net.merchantpug.apugli.Apugli;
import net.merchantpug.apugli.network.s2c.ApugliPacketS2C;
import net.minecraft.client.Minecraft;
import net.minecraft.core.Holder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;

public record SyncSinglePowerPacket(int entityId, ResourceLocation powerId, CompoundTag powerDataTag) implements ApugliPacketS2C
{
    @Override
    public void encode(FriendlyByteBuf buf) {
        buf.writeInt(this.entityId());
        buf.m_130085_(this.powerId());
        buf.m_130079_(this.powerDataTag());
    }

    public static SyncSinglePowerPacket decode(FriendlyByteBuf buf) {
        return new SyncSinglePowerPacket(buf.readInt(), buf.m_130281_(), buf.m_130260_());
    }

    @Override
    public ResourceLocation getFabricId() {
        throw new RuntimeException("ApugliPacket#getFabricId is not meant to be used in Forge specific packets.");
    }

    @Override
    public void handle() {
        Minecraft.m_91087_().execute(new Runnable(){

            @Override
            public void run() {
                Entity entity = Minecraft.m_91087_().f_91073_.m_6815_(SyncSinglePowerPacket.this.entityId);
                if (!(entity instanceof LivingEntity)) {
                    Apugli.LOG.warn("Could not find living entity to sync configured power with.");
                    return;
                }
                IPowerContainer container = ApoliAPI.getPowerContainer((Entity)entity);
                Holder configuredPower = container.getPower(SyncSinglePowerPacket.this.powerId());
                if (configuredPower != null && configuredPower.m_203633_()) {
                    if (!SyncSinglePowerPacket.this.powerDataTag().m_128456_()) {
                        ((ConfiguredPower)configuredPower.m_203334_()).deserialize(container, SyncSinglePowerPacket.this.powerDataTag());
                    }
                } else {
                    Apugli.LOG.warn("Invalid power container capability for entity {}", (Object)entity.m_6302_());
                }
            }
        });
    }
}

