/*
 * Decompiled with CFR 0.152.
 */
package net.merchantpug.apugli.network.s2c;

import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.merchantpug.apugli.Apugli;
import net.merchantpug.apugli.access.ExplosionAccess;
import net.merchantpug.apugli.network.s2c.ApugliPacketS2C;
import net.merchantpug.apugli.platform.Services;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.ExplosionDamageCalculator;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;

public record SyncExplosionPacket<BI, B>(int userId, double x, double y, double z, List<?> damageModifiers, List<?> knockbackModifiers, List<?> volumeModifiers, List<?> pitchModifiers, @Nullable BI biEntityConditions, boolean hasCalculator, @Nullable B blockConditions, boolean indestructible, float power) implements ApugliPacketS2C
{
    public static final ResourceLocation ID = Apugli.asResource("sync_explosion");

    @Override
    public void encode(FriendlyByteBuf buf) {
        buf.writeInt(this.userId());
        buf.writeDouble(this.x());
        buf.writeDouble(this.y());
        buf.writeDouble(this.z());
        Services.PLATFORM.getModifiersDataType().send(buf, this.damageModifiers());
        Services.PLATFORM.getModifiersDataType().send(buf, this.knockbackModifiers());
        Services.PLATFORM.getModifiersDataType().send(buf, this.volumeModifiers());
        Services.PLATFORM.getModifiersDataType().send(buf, this.pitchModifiers());
        buf.writeBoolean(this.biEntityConditions() != null);
        if (this.biEntityConditions() != null) {
            Services.CONDITION.biEntityDataType().send(buf, this.biEntityConditions());
        }
        buf.writeBoolean(this.hasCalculator());
        buf.writeBoolean(this.blockConditions() != null);
        if (this.blockConditions() != null) {
            Services.CONDITION.blockDataType().send(buf, this.blockConditions());
        }
        buf.writeBoolean(this.indestructible());
        buf.writeFloat(this.power());
    }

    public static <BI, B> SyncExplosionPacket<BI, B> decode(FriendlyByteBuf buf) {
        int userId = buf.readInt();
        double x = buf.readDouble();
        double y = buf.readDouble();
        double z = buf.readDouble();
        List damageModifiers = (List)Services.PLATFORM.getModifiersDataType().receive(buf);
        List knockbackModifiers = (List)Services.PLATFORM.getModifiersDataType().receive(buf);
        List volumeModifiers = (List)Services.PLATFORM.getModifiersDataType().receive(buf);
        List pitchModifiers = (List)Services.PLATFORM.getModifiersDataType().receive(buf);
        boolean hasBiEntityCondition = buf.readBoolean();
        Object biEntityCondition = null;
        if (hasBiEntityCondition) {
            biEntityCondition = Services.CONDITION.biEntityDataType().receive(buf);
        }
        boolean hasCalculator = buf.readBoolean();
        boolean hasBlockDataCondition = buf.readBoolean();
        Object blockDataCondition = null;
        if (hasBlockDataCondition) {
            blockDataCondition = Services.CONDITION.blockDataType().receive(buf);
        }
        boolean indestructible = buf.readBoolean();
        float radius = buf.readFloat();
        return new SyncExplosionPacket<Object, Object>(userId, x, y, z, damageModifiers, knockbackModifiers, volumeModifiers, pitchModifiers, biEntityCondition, hasCalculator, blockDataCondition, indestructible, radius);
    }

    @Override
    public ResourceLocation getFabricId() {
        return ID;
    }

    @Override
    public void handle() {
        Minecraft.m_91087_().execute(new Runnable(){

            @Override
            public void run() {
                ClientLevel level = Minecraft.m_91087_().f_91073_;
                Entity entity = level.m_6815_(SyncExplosionPacket.this.userId);
                Explosion explosion = new Explosion((Level)level, entity, null, SyncExplosionPacket.this.createBlockConditionedExplosionDamageCalculator(SyncExplosionPacket.this.blockConditions(), (Level)level, SyncExplosionPacket.this.indestructible), SyncExplosionPacket.this.x, SyncExplosionPacket.this.y, SyncExplosionPacket.this.z, SyncExplosionPacket.this.power, false, Explosion.BlockInteraction.KEEP);
                ((ExplosionAccess)explosion).apugli$setExplosionDamageModifiers(SyncExplosionPacket.this.damageModifiers());
                ((ExplosionAccess)explosion).apugli$setExplosionKnockbackModifiers(SyncExplosionPacket.this.knockbackModifiers());
                ((ExplosionAccess)explosion).apugli$setExplosionVolumeModifiers(SyncExplosionPacket.this.volumeModifiers());
                ((ExplosionAccess)explosion).apugli$setExplosionPitchModifiers(SyncExplosionPacket.this.pitchModifiers());
                ((ExplosionAccess)explosion).apugli$setBiEntityPredicate(SyncExplosionPacket.this.biEntityConditions());
                explosion.m_46075_(true);
            }
        });
    }

    private <C> ExplosionDamageCalculator createBlockConditionedExplosionDamageCalculator(final C blockCondition, final Level levelIn, final boolean indestructible) {
        return new ExplosionDamageCalculator(){

            public Optional<Float> m_6617_(Explosion explosion, BlockGetter level, BlockPos pos, BlockState blockState, FluidState fluidState) {
                Optional ovr;
                Optional def = super.m_6617_(explosion, level, pos, blockState, fluidState);
                Optional<Object> optional = ovr = Services.CONDITION.checkBlock(blockCondition, levelIn, pos) == indestructible ? Optional.of(Float.valueOf(Blocks.f_49990_.m_7325_())) : Optional.empty();
                return ovr.isPresent() ? (def.isPresent() ? (((Float)def.get()).floatValue() > ((Float)ovr.get()).floatValue() ? def : ovr) : ovr) : def;
            }
        };
    }
}

