/*
 * Decompiled with CFR 0.152.
 */
package net.merchantpug.apugli.network.s2c;

import net.merchantpug.apugli.Apugli;
import net.merchantpug.apugli.network.s2c.ApugliPacketS2C;
import net.merchantpug.apugli.platform.Services;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;

public record ExecuteBiEntityActionClientPacket<A>(int actorId, int targetId, A entityAction) implements ApugliPacketS2C
{
    public static final ResourceLocation ID = Apugli.asResource("execute_bientity_action_clientside");

    @Override
    public void encode(FriendlyByteBuf buf) {
        buf.writeInt(this.actorId);
        buf.writeInt(this.targetId);
        Services.ACTION.entityDataType().send(buf, this.entityAction);
    }

    public static <A> ExecuteBiEntityActionClientPacket<A> decode(FriendlyByteBuf buf) {
        int actorId = buf.readInt();
        int targetId = buf.readInt();
        Object entityAction = Services.ACTION.entityDataType().receive(buf);
        return new ExecuteBiEntityActionClientPacket<Object>(actorId, targetId, entityAction);
    }

    @Override
    public ResourceLocation getFabricId() {
        return ID;
    }

    @Override
    public void handle() {
        Minecraft.m_91087_().execute(new Runnable(){

            @Override
            public void run() {
                ClientLevel level = Minecraft.m_91087_().f_91073_;
                Entity actor = level.m_6815_(ExecuteBiEntityActionClientPacket.this.actorId);
                Entity target = level.m_6815_(ExecuteBiEntityActionClientPacket.this.targetId);
                if (actor == null) {
                    Apugli.LOG.warn("Could not find actor entity for clientsided bi-entity action.");
                    return;
                }
                if (target == null) {
                    Apugli.LOG.warn("Could not find target entity for clientsided bi-entity action.");
                    return;
                }
                Services.ACTION.executeBiEntity(ExecuteBiEntityActionClientPacket.this.entityAction, actor, target);
            }
        });
    }
}

